#include "cthugha.h"
#include "interface.h"
#include "keys.h"
#include "sound.h"
#include "cd_player.h"
#include "options.h"
#include "display.h"
#include "action.h"				/* display_sound() */
#include "translate.h"
#include "information.h"
#include "waves.h"

#include <string.h>
#include <stdlib.h>
#include <signal.h>

int_var_t int_var = { 
    CK_NONE, 
    IM_main
}; 

int dummy_pre_key() {
    return 1;
}
int dummy_post_key() {
    return 0;
}

typedef struct {
    int (*pre_key)(void);		/* called before key-loop */
    void  (*do_key)(void);		/* handle a key press */
    int (*post_key)(void);		/* called when no more keys */
} int_mode_t;
int_mode_t modes[] = {
    { dummy_pre_key, main_do_key, dummy_post_key },
    { sel_pre_key, sel_do_key, dummy_post_key },
    { opt_pre_key, opt_do_key, dummy_post_key },
    { cred_pre_key, cred_do_key, dummy_post_key },
    { cd_pre_key, cd_do_key, cd_post_key },
    { stat_pre_key, main_do_key, dummy_post_key },
    { help_pre_key, main_do_key, dummy_post_key }
};

interface_mode_t interface_mode = IM_main;

int default_do_key();

text_t * main_text = NULL;
text_t * msg_text = NULL;

int interface() {
    int mode = int_var.mode;

    if( modes[mode].pre_key() ) {
	display_remove_text(main_text);
	main_text = NULL;
    }

    while( (int_var.key = getkey()) != CK_NONE) {
	if( ! default_do_key() )
	    modes[mode].do_key();
    }

    modes[mode].post_key();

    if(cthugha_pause) {
	/* this is here to be sure not to interrupt a graphics
	   operation. */
	cthugha_pause = 0;

	exit_graph_mode();			/* turn off graphics */
	free_sound();				/* and sound */
	
	raise(SIGTSTP);				/* default action */
    }

    return 0;
}

/*
 * handle keys, that are recognized in all moded
 */
int default_do_key() {

    if(int_var.mode == IM_credits)	/* don't handle keys, when credits are running */
	return 0;

    switch(int_var.key) {

    case CK_ESC: case 'q': case 'Q':				/* Exit */
	int_var.mode = (int_var.mode != IM_main) ? IM_main : IM_credits;
	break;

    case 'c': case 'C':
	int_var.mode = (int_var.mode != IM_panel) ? IM_panel : IM_main;
	break;

    case 'o': case 'O':
	int_var.mode = (int_var.mode != IM_options) ? IM_options : IM_main;
	break;

    case 'i': case 'I':
	int_var.mode = (int_var.mode != IM_status) ? IM_status : IM_main;
	break;


    case CK_FKT(1): case '1': case '': case '?':
	int_var.mode = (int_var.mode != IM_main_help) ? IM_main_help : IM_main;
	break;

    case CK_FKT(2):
	selection(&screens);
	break;
    case CK_FKT(3):
	selection(&waves);
	break;
    case CK_FKT(4):
	selection(&flames);
	break;
    case CK_FKT(5):
	selection(&translations);
	break;
    case CK_FKT(6):
	selection(&palettes);
	break;
    case CK_FKT(7):
	select_pcx(); 
	break;
    case CK_FKT(8):
	selection(&objects);
	break;
	
    default:
	return 0;
    }
    return 1;	/* could handle key */
}

/*****************************************************************************
 * Credits
 *****************************************************************************/

static text_t * credits_text = NULL;
static void add_credits_line(int i) {

    display_add_text(credits_text, info_credits[i]+1, 0, 'c', 0, 
		     info_credits[i][0] == 'n' ? TEXT_COLOR_NORMAL : 
		     info_credits[i][0] == 'e' ? TEXT_COLOR_ERROR :
		     TEXT_COLOR_HIGHLIGHT);
}

int cred_pre_key() {
    static int i = 0;
    static int lasttime = 0;
    static int j = 0;

    if(lasttime == 0) {
	/* start from bottom */
	credits_text = display_print(" ", disp_size.y/8 - 3, 'c', 0, TEXT_COLOR_NORMAL);

	for(i=0; i < 4; i++)
	    add_credits_line(i);

	lasttime = gettime();
    }
	
    if( (gettime() - lasttime) > 4) {
	display_scroll_text(credits_text, 1);
	if( ++j == 8) {
	    j = 0;

	    add_credits_line(i);

	    i = (i+1) % info_nr_credits;
	}
	lasttime = gettime();
    }
    return 1;
}

void cred_do_key() {
    cthugha_close = 1;
}




