/***********************************************************************/
/*                                                                     */
/*                           Objective Caml                            */
/*                                                                     */
/*            Xavier Leroy, projet Cristal, INRIA Rocquencourt         */
/*                                                                     */
/*  Copyright 1996 Institut National de Recherche en Informatique et   */
/*  Automatique.  Distributed only by permission.                      */
/*                                                                     */
/***********************************************************************/

/* $Id: opendir.c,v 1.4 1996/09/04 14:15:01 xleroy Exp $ */

#include <mlvalues.h>
#include "unixsupport.h"
#include <sys/types.h>
#ifdef HAS_DIRENT
#include <dirent.h>
#else
#include <sys/dir.h>
#endif

value unix_opendir(path)         /* ML */
     value path;
{
  DIR * d;
  d = opendir(String_val(path));
  if (d == (DIR *) NULL) uerror("opendir", path);
  return (value) d;
}
