/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
/*
** ctypeList.c
**
** based on list_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "basic.h"

/*@only@*/ ctypeList
ctypeList_new ()
{
  ctypeList s = (ctypeList) dmalloc (sizeof (*s));
  
  s->nelements = 0;
  s->nspace = ctypeListBASESIZE; 
  s->elements = (ctype *) dmalloc (sizeof (*s->elements) * ctypeListBASESIZE);

  return (s);
}

static void
ctypeList_grow (/*@notnull@*/ ctypeList s)
{
  int i;
  ctype *newelements;
  
  s->nspace += ctypeListBASESIZE; 
  newelements = (ctype *) dmalloc (sizeof (*newelements) * (s->nelements + s->nspace));

  if (newelements == (ctype *) 0)
    {
      llfatalerror (cstring_makeLiteral ("ctypeList_grow: out of memory!"));
    }
    
  for (i = 0; i < s->nelements; i++)
    {
      newelements[i] = s->elements[i];
    }
  
  sfree (s->elements);
  s->elements = newelements;
}

void ctypeList_addh (ctypeList s, ctype el)
{
  llassert (ctypeList_isDefined (s));
  llassert (ctypeListBASESIZE > 0);

  if (s->nspace <= 0) ctypeList_grow (s);
  
  s->nspace--;
  s->elements[s->nelements] = el;
  s->nelements++;
}

/*@only@*/ cstring
ctypeList_unparse (ctypeList ct)
{
  cstring s = cstring_undefined;
  int i;
  bool first = TRUE;

  if (ctypeList_isUndefined (ct) || ctypeList_size (ct) == 0)
    {
      return (cstring_makeLiteral ("void"));
    }

  for (i = 0; i < ct->nelements; i++)
    {
      if (first)
	{
	  s = cstring_copy (ctype_unparse (ct->elements[i]));
	  first = FALSE;
	}
      else
	{
	  s = message ("%q, %s", s, ctype_unparse (ct->elements[i]));
	}
    }

  return s;
}

void
ctypeList_free (/*@only@*/ ctypeList s)
{
  if (ctypeList_isDefined (s))
    {
      int i;
      for (i = 0; i < s->nelements; i++)
	{
	  /*      ctype_free (s->elements[i]); */
	}
      
      sfree (s->elements); /* not quite!!! */
      sfree (s);
    }
}







