package biss.jde;

import jas.*;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.tools.java.RuntimeConstants;

/**
 * ClassLoader to instanciate real-life windows from Designer-generated
 * physical views
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
class DesignPreviewLoader
  extends ClassLoader
{
	Hashtable Cache;
	Class Exec;

public DesignPreviewLoader ( byte[] data, String clsName)
	throws ClassFormatError
{
	Cache = new Hashtable();
	Exec  = defineClass( data, 0, data.length);
	Cache.put( clsName, Exec);
	resolveClass( Exec);
}

public void exec ()
	throws Exception
{
	Exec.newInstance();
}

public synchronized Class loadClass( String name, boolean resolve)
	throws ClassNotFoundException
{
	Class c = (Class) Cache.get( name);
	if ( c == null) {
		c = findSystemClass( name);
		Cache.put( name, c);
	}
	if ( resolve)
		resolveClass( c);
	return c;
}
}

/**
 * class to dynamically create (bytecode) classes which are used to preview a
 * designed layout. The generated classes are plain logical views containing just
 * the required Component fields/layouts. There is no 'preview' of dynamic behavior
 * (not even switching between notebook pages). You can just preview the currently
 * selected layout
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
class DesignPreviewer
  implements RuntimeConstants
{
	ClassEnv CEnv = new ClassEnv();
	CodeAttr CtC = new CodeAttr();

public DesignPreviewer () {
	CEnv.setClass(new ClassCP("TmpClass"));
	CEnv.setSuperClass(new ClassCP("biss/awt/TopWindow"));
	CEnv.setClassAccess((short) ACC_PUBLIC);
}

void addFields ( Vector v) {
	for ( Enumeration e = v.elements(); e.hasMoreElements(); ){
		DesignObject os = (DesignObject)e.nextElement();
		String fp = os.PkgName.replace( '.', '/') + "/";

		CEnv.addField(new Var((short)(ACC_PUBLIC),
		                      new AsciiCP( os.FldName),
		                      new AsciiCP( "L" + fp + os.ClsName +";"),
		                      null) );
	}
	CEnv.addField( new Var((short)(ACC_PUBLIC),
	                       new AsciiCP( "Lo"),
	                       new AsciiCP( "Lbiss/awt/Layouter;"),
	                       null) );
}

public void buildCt ( String title, Vector v, Rectangle or) {
	try {
		// super( title);
		CtC.addInsn( new Insn( opc_aload_0));
		CtC.addInsn( new Insn( opc_ldc, new StringCP( title)));
		CtC.addInsn( new Insn( opc_invokenonvirtual,
		                       new MethodCP( "biss/awt/TopWindow", "<init>",
		              "(Ljava/lang/String;)V" )));

		initFields( v);
		setLayout( v);

		// openIn()
		CtC.addInsn( new Insn( opc_aload_0));
		CtC.addInsn( new Insn( opc_sipush, or.x));
		CtC.addInsn( new Insn( opc_sipush, or.y));
		CtC.addInsn( new Insn( opc_sipush, or.width));
		CtC.addInsn( new Insn( opc_sipush, or.height));

		CtC.addInsn( new Insn( opc_invokevirtual,
		                       new MethodCP( "biss/awt/TopWindow", "openIn",
		              "(IIII)V" )));
		// return;
		CtC.addInsn( new Insn( opc_return));

		CtC.setStackSize((short)100);

		CEnv.addMethod( (short)(ACC_PUBLIC), "<init>",
		                "()V", CtC, null);
	}
	catch( Throwable t) {
		System.out.println( "error building ct()");
	}
}

public void buildMain () {
	try {
		CodeAttr cam = new CodeAttr();

		cam.addInsn( new Insn( opc_new, new ClassCP( "TmpClass")));
		cam.addInsn( new Insn( opc_dup));
		cam.addInsn( new Insn( opc_invokenonvirtual,
		                       new MethodCP( "TmpClass", "<init>", "()V" )));

		cam.addInsn( new Insn( opc_return));
		cam.setStackSize((short)2);

		CEnv.addMethod( (short)(ACC_PUBLIC|ACC_STATIC), "main",
		                "([Ljava/lang/String;)V", cam, null);
	}
	catch( Throwable t) {
		System.out.println( "error building main()");
	}
}

public void buildPreview ( String title, Vector v, Rectangle or) {
	//  long t1, t2;
	//  t1 = System.currentTimeMillis();
	addFields( v);
	buildCt( title, v, or);
	//  t2 = System.currentTimeMillis();
	//  System.out.println( "jas build time: " + (t2 -t1));
}

void initFields ( Vector v) {
	try {
		for ( Enumeration e = v.elements(); e.hasMoreElements(); ) {
			DesignObject os = (DesignObject) e.nextElement();
			String fp = os.PkgName.replace( '.', '/') + "/";

			CtC.addInsn( new Insn( opc_aload_0));
			CtC.addInsn( new Insn( opc_new,
			                       new ClassCP( fp + os.ClsName )));
			CtC.addInsn( new Insn( opc_dup));
			if ( os.hasText() ){
				CtC.addInsn( new Insn( opc_ldc,
				                       new StringCP( os.Text)));
				CtC.addInsn( new Insn( opc_invokenonvirtual,
				                       new MethodCP( fp + os.ClsName, "<init>",
				              "(Ljava/lang/String;)V" ) ));
			}
			else {
				CtC.addInsn( new Insn( opc_invokenonvirtual,
				                       new MethodCP( fp + os.ClsName, "<init>",
				              "()V" ) ));
			}
			CtC.addInsn( new Insn( opc_putfield,
			                       new FieldCP( "TmpClass", os.FldName,
			             "L" + fp + os.ClsName +";") ));
		}

		CtC.addInsn( new Insn( opc_aload_0));
		CtC.addInsn( new Insn( opc_new,
		                       new ClassCP( "biss/awt/Layouter" )));
		CtC.addInsn( new Insn( opc_dup));
		CtC.addInsn( new Insn( opc_aload_0));
		CtC.addInsn( new Insn( opc_invokenonvirtual,
		                       new MethodCP( "biss/awt/Layouter", "<init>",
		              "(Ljava/awt/Container;)V" ) ));
		CtC.addInsn( new Insn( opc_putfield,
		                       new FieldCP( "TmpClass", "Lo",
		             "Lbiss/awt/Layouter;") ));
	}
	catch( Throwable t) {
		System.out.println( "error initializing fields");
	}
}

public void save() {
	try {
		String fName = "TmpClass.class";
		File f = new File( fName);
		CEnv.write(new DataOutputStream(new FileOutputStream( fName)));
	}
	catch( Throwable t) {;}
}

void setLayout ( Vector v) {
	try {
		for ( Enumeration e = v.elements(); e.hasMoreElements(); ) {
			DesignObject os = (DesignObject) e.nextElement();
			String fp = os.PkgName.replace( '.', '/') + "/";
			DesignObjLayout ol = os.LoSpec;

			CtC.addInsn( new Insn( opc_aload_0));
			CtC.addInsn( new Insn( opc_getfield,
			                       new FieldCP( "TmpClass", "Lo",
			             "Lbiss/awt/Layouter;") ));
			CtC.addInsn( new Insn( opc_aload_0));
			CtC.addInsn( new Insn( opc_getfield,
			                       new FieldCP( "TmpClass", os.FldName,
			             "L" + fp +os.ClsName + ";") ));
			CtC.addInsn( new Insn( opc_sipush, ol.X0));
			CtC.addInsn( new Insn( opc_sipush, ol.Y0));
			CtC.addInsn( new Insn( opc_sipush, ol.X1));
			CtC.addInsn( new Insn( opc_sipush, ol.Y1));
			CtC.addInsn( new Insn( ol.DUOffset ? opc_iconst_1 : opc_iconst_0));
			CtC.addInsn( new Insn( opc_sipush, ol.OffX0));
			CtC.addInsn( new Insn( opc_sipush, ol.OffY0));
			CtC.addInsn( new Insn( opc_sipush, ol.OffX1));
			CtC.addInsn( new Insn( opc_sipush, ol.OffY1));
			CtC.addInsn( new Insn( opc_sipush, ol.VarSides));
			CtC.addInsn( new Insn( opc_invokevirtual,
			                       new MethodCP( "biss/awt/Layouter", "add",
			              "(Ljava/awt/Component;IIIIZIIIII)V" ) ));
		}
	}
	catch( Throwable t) {
		System.out.println( "error setting layout");
	}
}

public void show() {
	try {
		//  long t1, t2, t3, t4;
		//  t1 = System.currentTimeMillis();
		ByteArrayOutputStream bos = new ByteArrayOutputStream( 1000);
		CEnv.write( new DataOutputStream( bos));
		//  t2 = System.currentTimeMillis();
		DesignPreviewLoader pl = new DesignPreviewLoader( bos.toByteArray(), "TmpClass" );
		//  t3 = System.currentTimeMillis();
		pl.exec();
		//  t4 = System.currentTimeMillis();
		//  System.out.println( "class write time: " + (t2 -t1));
		//  System.out.println( "preview load time: " + (t3 -t2));
		//  System.out.println( "preview exec time: " + (t4 -t3));
	}
	catch( Throwable t) {
		System.out.println( "cannot load class");
	}
}
}
