;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/recette/wind.scm                     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun Mar  8 19:31:00 1998                          */
;*    Last change :  Sun Mar  8 20:28:20 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    Wind test (dynamic-wind and unwind-protect).                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module wind
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-wind)))

;*---------------------------------------------------------------------*/
;*    A global variable                                                */
;*---------------------------------------------------------------------*/
(define *kont* #unspecified)

;*---------------------------------------------------------------------*/
;*    test-wind ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-wind)
   (test-module "wind" "wind.scm" #f)
   (let ((exg *exitd-top*))
      (test "unwind-protect"
	    (let ((x 3))
	       (call/cc (lambda (exit)
			   (unwind-protect
			      (begin
				 (set! x (+ 1 x))
				 (exit (begin (set! x (+ 1 x)) x))
				 (set! x (+ 1 x)))
			      (set! x (+ 1 x)))))
	       x)
	    6)
      (let ((ex *exitd-top*))
	 (test "unwind-protect"
	       (let* ((x     10)
		      (value (unwind-protect
				(call/cc (lambda (exit)
					    (begin
					       (set! x (+ 1 x))
					       (set! *kont* exit)
					       (set! x (+ 1 x)))))
				(set! x (+ 1 x)))))
		  (if (not (eq? value 4))
		      (*kont* 4)
		      x))
	       14)
	 (test "unwind-protect" ex *exitd-top*)
	 (test "unwind-protect"
	       (let* ((x     10)
		      (value (unwind-protect
				(call/cc (lambda (exit)
					    (begin
					       (set! x (+ 1 x))
					       (set! *kont* exit)
					       (set! x (+ 1 x)))))
				(set! x (+ 1 x)))))
		  (if (not (eq? value 4))
		      (*kont* 4)
		      x))
	       14)
	 (test "unwind-protect" ex *exitd-top*))
      (test "dynamic-wind"
	    (let ((path '())
		  (c    #f))
	       (let ((add (lambda (s) (set! path (cons s path)))))
		  (dynamic-wind
		   (lambda () (add 'connect))
		   (lambda ()
		      (add (call/cc
			    (lambda (c0)
			       (set! c c0)
			       'talk1))))
		   (lambda ()
		      (add 'disconnect)))
		  (if (< (length path) 4)
		      (c 'talk2)
		      (reverse path))))
	    (let ((path '())
		  (c    #f))
	       (let ((add (lambda (s) (set! path (cons s path)))))
		  (dynamic-wind
		   (lambda () (add 'connect))
		   (lambda ()
		      (add (call/cc
			    (lambda (c0)
			       (set! c c0)
			       'talk1))))
		   (lambda ()
		      (add 'disconnect)))
		  (if (< (length path) 4)
		      (c 'talk2)
		      (reverse path)))))
      (test "dynamic-wind"
	    (let ((path '())
		  (c    #f))
	       (let ((add (lambda (s) (set! path (cons s path)))))
		  (dynamic-wind
		   (lambda () (add 'connect))
		   (lambda ()
		      (add (call/cc
			    (lambda (c0)
			       (set! c c0)
			       'talk1))))
		   (lambda ()
		      (add 'disconnect)))
		  (if (< (length path) 4)
		      (c 'talk2)
		      (reverse path))))
	    '(CONNECT TALK1 DISCONNECT CONNECT TALK2 DISCONNECT))
      (test "dynamic-wind" exg *exitd-top*)))

