/* --------------------------------------------------------------------*/
/*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
/*                                                                     */
/*                                     ,--^,                           */
/*                               _ ___/ /|/                            */
/*                           ,;'( )__, ) '                             */
/*                          ;;  //   L__.                              */
/*                          '   \   /  '                               */
/*                               ^   ^                                 */
/*                                                                     */
/*                                                                     */
/*    This program is distributed in the hope that it will be useful.  */
/*    Use and copying of this software and preparation of derivative   */
/*    works based upon this software are permitted, so long as the     */
/*    following conditions are met:                                    */
/*           o credit to the authors is acknowledged following         */
/*             current academic behaviour                              */
/*           o no fees or compensation are charged for use, copies,    */
/*             or access to this software                              */
/*           o this copyright notice is included intact.               */
/*      This software is made available AS IS, and no warranty is made */
/*      about the software or its performance.                         */
/*                                                                     */
/*      Bug descriptions, use reports, comments or suggestions are     */
/*      welcome. Send them to                                          */
/*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
/*-------------------------------------------------------------------- */
/*---------------------------------------------------------------------*/
/*    serrano/prgm/project/bigloo/recette/c-file.c                     */
/*                                                                     */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue May 19 15:37:20 1992                          */
/*    Last change :  Thu Dec  7 10:26:23 1995 (serrano)                */
/*                                                                     */
/*    Le fichier C du foreign-test                                     */
/*---------------------------------------------------------------------*/
#include "c-file.h"

/*---------------------------------------------------------------------*/
/*    Une variable globale                                             */
/*---------------------------------------------------------------------*/
int var = 9;

/*---------------------------------------------------------------------*/
/*    Un pointeur vers une fonction                                    */
/*---------------------------------------------------------------------*/
static int lolo( int x )
{
   return 4 + x;
}

int (*f1)(int) = &lolo;

/*---------------------------------------------------------------------*/
/*    Une recuperation externe                                         */
/*---------------------------------------------------------------------*/
extern struct el *malloc();

/*---------------------------------------------------------------------*/
/*    bar ...                                                          */
/*---------------------------------------------------------------------*/
bar( x )
int x;
{
   return x+1;
}

/*---------------------------------------------------------------------*/
/*    hux ...                                                          */
/*---------------------------------------------------------------------*/
char *
hux( s )
char *s;
{
   static char string[ 500 ];

   strcpy( string, "TOTO EST CONTENT" );

   return string;
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    sum_el ...                                                       */
/*---------------------------------------------------------------------*/
int
sum_el( head )
struct el *head;
{
	int val = 0;

	while( head )
	   val += head->key, head = head->next;

	return val;
}

/*---------------------------------------------------------------------*/
/*    int                                                              */
/*    sum_tab ...                                                      */
/*---------------------------------------------------------------------*/
double
sum_tab( tab, max )
int tab[];
int max;
{
	double res;
	int    i;

	for( i = 0, res = 0.0; i< max; res = res + (double)(tab[ i ]), i++ )
	   ;
	
	return res;
}

/*---------------------------------------------------------------------*/
/*    struct el*                                                       */
/*    define_el ...                                                    */
/*---------------------------------------------------------------------*/
struct el*
define_el( key )
int key;
{
	struct el* res;
	
	res = malloc( sizeof( struct el) );

	res->key = key;

	return res;
}

/*---------------------------------------------------------------------*/
/*    make_dummy_el ...                                                */
/*---------------------------------------------------------------------*/
struct el *
make_dummy_el()
{
	static struct el *_truc_ = 0L;
	
	if( _truc_ )
	   return _truc_;
	else
	{
		_truc_ = malloc( sizeof( struct el ) );

		_truc_->next = 0L;
		_truc_->key  = -2;

		return _truc_;
	}
}


	
