;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/bool.scm ...                 */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov  3 09:16:12 1992                          */
;*    Last change :  Wed Feb 10 13:09:18 1993  (serrano)               */
;*                                                                     */
;*    On test les operations booleenes.                                */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module bool
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-bool)
	    (encore-faux x)))

;*---------------------------------------------------------------------*/
;*    predicat ...                                                     */
;*---------------------------------------------------------------------*/
(define (predicat x)
   (> x 5))

;*---------------------------------------------------------------------*/
;*    faux-predicat ...                                                */
;*---------------------------------------------------------------------*/
(define (faux-predicat x)
   (> x 5))

;*---------------------------------------------------------------------*/
;*    encore-faux ...                                                  */
;*---------------------------------------------------------------------*/
(define (encore-faux x)
   (> x 5))

;*---------------------------------------------------------------------*/
;*    local-pred-1 ...                                                 */
;*---------------------------------------------------------------------*/
(define (local-pred-1 x)
   (labels ((pred (x) (< x 3)))
      (if (pred x) #t #f)))

;*---------------------------------------------------------------------*/
;*    local-pred-2 ...                                                 */
;*---------------------------------------------------------------------*/
(define (local-pred-2 x)
   (labels ((foo (x) (< x 3))
            (bar (x) (if (foo x) 3 4))
            (gee (x) (if (foo x) 3 4)))
      bar
      gee
      (if (foo x) #t #f)))

;*---------------------------------------------------------------------*/
;*    local-pred-3 ...                                                 */
;*---------------------------------------------------------------------*/
(define (local-pred-3 x)
   (labels ((pred (x) (< x 3)))
      (pred x)))

;*---------------------------------------------------------------------*/
;*    test-bool ...                                                    */
;*---------------------------------------------------------------------*/
(define (test-bool)
   (test-module "bool" "bool.scm" #f)
   (test "or" (or #f #f) #f)
   (test "not" (not #f) #t)
   (test "and" (and #t #t) #t)
   (test "and" (and #t #f) #f)
   (test "if" (let ((x 1)) (if x x)) 1)
   (test "ifnot" (let ((x 1)) (if (not x) #t #f)) #f)
   (test "ifor" (let ((x 1) (y #f)) (if (or x y) x y)) 1)
   (test "ifand" (let ((x 1) (y #f)) (if (and x y) #t #f)) #f)
   (test "pred" (if (predicat 6) #t #f) #t)
   (test "faux" (if (faux-predicat 6) (faux-predicat 7) (faux-predicat 3)) #t)
   (test "encore-faux" (if (encore-faux 6) #t #f) #t)
   (test "local-pred-1" (local-pred-1 1) #t)
   (test "local-pred-2" (local-pred-2 1) #t)
   (test "local-pred-3" (if (local-pred-3 1) #t #f) #t))

 
