;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9c/Object/struct.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu May 30 11:52:53 1996                          */
;*    Last change :  Wed Sep 10 09:15:43 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The object<->struct conversion                                   */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module object_struct
   (include "Object/class.sch")
   (import  tools_error
	    tools_misc
	    type_type
	    type_env
	    type_cache
	    type_tools
	    ast_var
	    ast_env
	    tools_error
	    engine_param
	    object_class
	    object_tools)
   (export  (make-object->struct      ::symbol ::type ::symbol slots)
	    (make-struct->object      ::symbol ::type ::symbol slots)
	    (make-wide-object->struct ::symbol ::type ::symbol slots)
	    (make-struct->wide-object ::symbol ::type ::symbol slots)))

;*---------------------------------------------------------------------*/
;*    save-slot ...                                                    */
;*---------------------------------------------------------------------*/
(define (save-slot oname sname cname i slot)
   (define (save-dyna-indexed-slot)
      (let ((vec  (gensym 'vec))
	    (j    (gensym 'j))
	    (loop (gensym 'loop))
	    (len  (gensym 'len)))
	 `(let ((,len (,(symbol-append cname '- (slot-id slot) '-len) ,oname)))
	     (let ((,vec (make-vector ,len)))
		(labels ((,loop (,j) (if (=fx ,j ,len)
					 (struct-set! ,sname ,i ,vec)
					 (begin
					    (vector-set-ur!
					     ,vec
					     ,j
					     (,(symbol-append cname
							      '-
							      (slot-id slot)
							      '-ref)
					      ,oname
					      ,j))
					    (,loop (+fx ,j 1))))))
		   (,loop 0))))))
   (define (save-stat-indexed-slot)
      (let ((vec  (gensym 'vec))
	    (j    (gensym 'j))
	    (loop (gensym 'loop))
	    (len  (gensym 'len)))
	 `(let ((,len (pragma::long ,(slot-stat-bound slot))))
	     (let ((,vec (make-vector ,len)))
		(labels ((,loop (,j) (if (=fx ,j ,len)
					 (struct-set! ,sname ,i ,vec)
					 (begin
					    (vector-set-ur!
					     ,vec
					     ,j
					     (,(symbol-append cname
							      '-
							      (slot-id slot)
							      '-ref)
					      ,oname
					      ,j))
					    (,loop (+fx ,j 1))))))
		   (,loop 0))))))
   (define (save-immediat-slot)
      `(struct-set! ,sname
		    ,i
		    (,(symbol-append cname '- (slot-id slot))
		     ,oname)))
   (cond
      ((slot-dyna-indexed? slot)
       (save-dyna-indexed-slot))
      ((slot-stat-indexed? slot)
       (save-stat-indexed-slot))
      (else
       (save-immediat-slot))))

;*---------------------------------------------------------------------*/
;*    make-object->struct ...                                          */
;*---------------------------------------------------------------------*/
(define (make-object->struct cname type module slots)
   (let ((len   (+fx 1 (length slots)))
	 (oname (gensym 'obj))
	 (sname (gensym 'res)))
      `(define-method (object->struct::struct ,(symbol-append oname 4dots cname))
	  (let ((,sname (make-struct ',cname ,len #unspecified)))
	     (begin
		(struct-set! ,sname 0 #f)
		,@(let loop ((i     1)
			     (slots slots)
			     (res   '()))
		     (if (=fx i len)
			 (reverse! res)
			 (loop (+fx i 1)
			       (cdr slots)
			       (cons (save-slot oname
						sname
						cname
						i
						(car slots))
				     res))))
		,sname)))))

;*---------------------------------------------------------------------*/
;*    make-wide-object->struct ...                                     */
;*---------------------------------------------------------------------*/
(define (make-wide-object->struct cname type module slots)
   (let* ((len    (length slots))
	  (oname  (gensym 'obj))
	  (res    (gensym 'res))
	  (tres   (symbol-append res '::struct))
	  (aux    (gensym 'aux)))
      `(define-method (object->struct::struct ,(symbol-append oname 4dots cname))
	  (let ((,tres (call-next-method)))
	     (let ((,aux (make-struct ',cname ,len #unspecified)))
		,@(let loop ((i     0)
			     (slots slots)
			     (res   '()))
		     (if (=fx i len)
			 (reverse! res)
			 (loop (+fx i 1)
			       (cdr slots)
			       (cons (save-slot oname aux cname i (car slots))
				     res))))
		(struct-set! ,res 0 ,aux)
		;; we now swap the structures' keys
		(struct-key-set! ,aux (struct-key ,res))
		(struct-key-set! ,res ',cname)
		;; and we return res
		,res)))))

;*---------------------------------------------------------------------*/
;*    restore-slot ...                                                 */
;*---------------------------------------------------------------------*/
(define (restore-slot oname sname cname type i slot)
   (let* ((loop          (gensym 'loop))
	  (runner        (gensym 'i))
	  (v             (gensym 'v))
	  (len           (gensym 'len))
	  (runner-typed  (symbol-append runner '::long))) 
      (cond
	 ((slot-dyna-indexed? slot)
	  ;; for an indexed field we have to make a
	  ;; malloc call and to fill all the field slots
	  `(let ((,v (struct-ref s ,i)))
	      (let ((,(symbol-append len '::long) (vector-length ,v)))
		 ,(make-pragma-indexed-init-set!
		   type
		   slot
		   'o
		   (malloc (slot-type slot) len))
		 ;; this loop fill the field slots
		 (labels ((,loop (,runner-typed)
				 (if (=fx ,runner ,len)
				     'done
				     (begin
					,(make-pragma-indexed-set!
					  type
					  slot
					  'o
					  `(vector-ref-ur ,v ,runner)
					  runner)
					(,loop (+fx ,runner 1))))))
		    (,loop 0)))))
	 ((slot-stat-indexed? slot)
	  ;; this loop fills the field slots
	  `(let ((,v (struct-ref s ,i)))
	      (labels ((,loop (,runner-typed)
			      (if (=fx ,runner
				       (pragma::long ,(slot-stat-bound slot)))
				  'done
				  (begin
				     ,(make-pragma-indexed-set!
				       type
				       slot
				       'o
				       `(vector-ref-ur ,v ,runner)
				       runner)
				     (,loop (+fx ,runner 1))))))
		 (,loop 0))))
	 (else
	  `(let ((,(symbol-append v 4dots (type-id (slot-type slot)))
		  (struct-ref s ,i)))
	      ,(make-pragma-direct-set! type slot 'o v))))))

;*---------------------------------------------------------------------*/
;*    make-struct->object ...                                          */
;*    -------------------------------------------------------------    */
;*    This function fills `object' and returns it.                     */
;*    -------------------------------------------------------------    */
;*    This function is very similar to the make-object function        */
;*    execpted that it founds the value in the structure rather than   */
;*    being provided as actual values.                                 */
;*---------------------------------------------------------------------*/
(define (make-struct->object cname type module slots)
   `(define-method (struct+object->object::object ,(symbol-append 'o
								  4dots
								  cname)
					   s::struct)
       (begin
	  (object-widening-set! o (struct-ref s 0))
	  ,@(let loop ((i     1)
		       (slots slots)
		       (res   '()))
	       (if (null? slots)
		   (reverse! res)
		   (let ((new (restore-slot 'o 's cname type i (car slots))))
		      (loop (+fx i 1)
			    (cdr slots)
			    (cons new res)))))
	  o)))

;*---------------------------------------------------------------------*/
;*    make-struct->wide-object ...                                     */
;*---------------------------------------------------------------------*/
(define (make-struct->wide-object cname type module slots)
   (let* ((old       (gensym 'old))
	  (len       (length slots))
	  (aux       (gensym 'aux))
	  (taux      (symbol-append aux '::struct))
	  (new       (gensym 'new))
	  (tid       (type-id type))
	  (holder    (class-holder type))
	  (widening  (symbol-append (class-widening type)
				    '-
				    (type-id type))))
      `(define-method (struct+object->object::object
					      ,(symbol-append 'o 4dots cname)
					      s::struct)
	  (let ((,old  (call-next-method))
		(,taux (struct-ref s 0)))
	     (let ((,(symbol-append new 4dots tid)
		    (,(symbol-append 'pragma 4dots tid)
		     ,(string-append "((" (type-name type) ")($1))")
		     ,old)))
		(object-class-num-set! ,new
				       (class-num
					(@ ,(global-id holder)
					   ,(global-module holder))))
		(object-widening-set!
		 ,new
		 (,widening ,@(let loop ((i    0)
					 (ref* '()))
				 (if (=fx i len)
				     (reverse! ref*)
				     (loop (+fx i 1)
					   (cons `(struct-ref ,aux ,i)
						 ref*))))))
		,new)))))
