;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Cfa/cinfo.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jun 24 15:46:49 1996                          */
;*    Last change :  Tue Jun 10 15:36:23 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The cfa's information structures                                 */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_info
   
   (import type_type
	   type_cache
	   ast_var
	   ast_node)
   
   (export ;; the approximations
	   (class approx
	      ;; the type of the approximation. Just one type, we
	      ;; do not compute several types approximation because
	      ;; anything receiving more than one type is of type obj.
	      (type::type (default *_*))
	      ;; A type locked means that the type field can't be changed
	      ;; (e.g. because the type has been set by the user, as for
	      ;; variable).
	      (type-locked?::bool read-only (default #f))
	      ;; its allocations
	      (allocs read-only)
	      ;; or top
	      (top?::bool (default #f))
	      ;; a stamp to avoid useless multiple loose.
	      (lost-stamp::long (default -1)))

	   ;; function extensions
	   (wide-class cfun/Cinfo::cfun (approx::approx read-only))
	   (wide-class extern-sfun/Cinfo::sfun (approx::approx read-only))
	   (wide-class intern-sfun/Cinfo::sfun
	      (approx::approx read-only)
	      (stamp::long (default -1)))

	   ;; cnst extension
	   (wide-class scnst/Cinfo::scnst (approx::approx read-only))
	   
	   ;; var extensions
	   (wide-class pre-clo-env::svar)
	   (wide-class svar/Cinfo::svar
	       (approx::approx read-only)
	       ;; is this variable holding a closure environement
	       ;; (if it is it won't be lost when loosing the
	       ;; function whose's this variable owner).
	       (clo-env?::bool (default #f)))
	   (wide-class cvar/Cinfo::cvar (approx::approx read-only))

	   ;; exit extensions
	   (wide-class sexit/Cinfo::sexit (approx::approx read-only))

	   ;; global and local reshaping
	   (wide-class reshaped-local::local
	      (binding-value read-only (default #f)))
	   (wide-class reshaped-global::global)
	   
	   ;; node extension
	   (wide-class atom/Cinfo::atom (approx::approx read-only))
	   (wide-class kwote/node::kwote (node::node read-only))
	   (wide-class kwote/Cinfo::kwote (approx::approx read-only))
	   (wide-class app-ly/Cinfo::app-ly (approx::approx read-only))
	   (wide-class funcall/Cinfo::funcall
	      (approx::approx read-only)
	      (va-approx::approx read-only)
	      (arity-error-noticed?::bool (default (not *warning*)))
	      (type-error-noticed?::bool (default (not *warning*))))
	   (wide-class pragma/Cinfo::pragma (approx::approx read-only))
	   (wide-class setq/Cinfo::setq (approx::approx read-only))
	   (wide-class conditional/Cinfo::conditional (approx::approx read-only))
	   (wide-class fail/Cinfo::fail (approx::approx read-only))
	   (wide-class select/Cinfo::select (approx::approx read-only))
	   (wide-class set-ex-it/Cinfo::set-ex-it (approx::approx read-only))
	   (wide-class jump-ex-it/Cinfo::jump-ex-it (approx::approx read-only))

	   ;; boxes
	   (wide-class pre-make-box::make-box
	      ;; the key for the set manipulation
	      (key (default -1)))
	   (wide-class make-box/Cinfo::make-box (approx::approx read-only))
	   (wide-class make-box/O-Cinfo::make-box
              ;; the key for the set manipulation		       
	      (key read-only)
	      approx::approx
	      (value-approx::approx read-only))
	   (wide-class box-set!/Cinfo::box-set! (approx::approx read-only))
	   (wide-class box-ref/Cinfo::box-ref (approx::approx read-only))
	   (wide-class box-set!/O-Cinfo::box-set! (approx::approx read-only))
	   (wide-class box-ref/O-Cinfo::box-ref (approx::approx read-only))

	   ;; procedure
	   (wide-class pre-make-procedure-app::app
	       ;; the allocation owner
	       (owner::variable read-only)
	      ;; the key for the set manipulation
	      (key (default -1)))
	   (wide-class pre-procedure-ref-app::app)
	   (wide-class pre-procedure-set!-app::app)
	   
	   (wide-class make-procedure-app::app
	      ;; the key for the set manipulation
	      (key read-only) 
	      ;; the approx of the make-procedure (i.e. *procedure*)
	      approx::approx
	      ;; the approximations of the values holded by the procedure
	      (* values-approx::approx (default (make-empty-approx)))
	      ;; a stamp to avoid infinit loops when loosing a procedure.
	      ;; This slot also reveals if the procedure has been lost.
	      ;; If the procedure has, lost-stamp > 0.
	      (lost-stamp::long (default -1))
	      ;; the X and T closure property (only used by cfa_closure)
	      (X-T?::bool (default #t))
	      (X::bool (default #f))
	      (T::bool (default #f))
	      ;; an allocation owner
	      (owner::variable read-only)
	      ;; A procedure can be stack allocate if this field is true
	      ;; and if lost-stamp is -1
	      (stackable?::bool (default #t))
	      ;; a stamp use for the stack loosing propagation
	      (stack-stamp (default '())))
	   (wide-class procedure-ref-app::app (approx::approx read-only))
	   (wide-class procedure-set!-app::app (approx::approx read-only))

	   ;; vector
	   (wide-class pre-make-vector-app::app
	       ;; the allocation owner
	       (owner::variable read-only)
	       ;; the set key field
	       (key (default -1)))
	   (wide-class pre-create-vector-app::app
	       ;; the allocation owner
	       (owner::variable read-only)
	       ;; the set key field
	       (key (default -1)))
	   (wide-class pre-vector-ref-app::app)
	   (wide-class pre-vector-set!-app::app)
	   
	   (wide-class make-vector-app::app
	      ;; the key for the set manipulation
	      (key read-only)
	      ;; the approx of the make-vector (i.e. *vector*)
	      approx::approx
	      ;; the approximation of the values holded by the vector
	      (value-approx::approx read-only)
	      ;; a stamp to avoid infinit loop when loosing a vector
	      (lost-stamp::long (default -1))
	      ;; an allocation owner
	      (owner::variable read-only)
	      ;; can we stack allocate this vector (to be use in conjonction
	      ;; with lost-stamp).
	      (stackable?::bool (default #t))
	      ;; a stamp use for the stack loosing propagation
	      (stack-stamp (default '()))
	      ;; Is the vector subject to a vector-ref or a vector-set?
	      ;; If not, this vector cannot be optimized. This is mandatory
	      ;; otherwise this analysis fails for code like:
	      ;; (let ((v #unspecified))
	      ;;     (set! v (make-vector 10 0.0))
	      ;;     (set! v #f)
	      ;;     ...)
	      ;; A type error is detected because v is given
	      ;; an erroneous type.
	      (seen?::bool (default #f)))
	   (wide-class create-vector-app::app
	      ;; the key for the set manipulation
	      (key read-only)
	      ;; the approx of the make-vector (i.e. *vector*)
	      approx::approx
	      ;; the approximation of the values holded by the vector
	      (value-approx::approx read-only)
	      ;; a stamp to avoid infinit loop when loosing a vector
	      (lost-stamp::long (default -1))
	      ;; an allocation owner
	      (owner::variable read-only)
	      ;; can we stack allocate this vector (to be use in conjonction
	      ;; with lost-stamp).
	      (stackable?::bool (default #t))
	      ;; a stamp use for the stack loosing propagation
	      (stack-stamp (default '()))
	      ;; Is the vector subject to a vector-ref or a vector-set?
	      ;; If not, this vector cannot be optimized
	      (seen?::bool (default #f)))
	   (wide-class vector-ref-app::app (approx::approx read-only))
	   (wide-class vector-set!-app::app (approx::approx read-only))
   
	   ;; struct
	   (wide-class pre-make-struct-app::app
	       ;; the allocation owner
	       (owner::variable read-only)
	      ;; the key for the set manipulation
	      (key (default -1)))
	   (wide-class pre-struct-ref-app::app)
	   (wide-class pre-struct-set!-app::app)
	   
	   (wide-class make-struct-app::app
	      ;; the key for the set manipulation
	      (key read-only)
	      ;; the approx of the make-struct (i.e. *struct*)
	      approx::approx
	      ;; the approximation of the values holded by the struct
	      (value-approx::approx read-only)
	      ;; a stamp to avoid infinit loop when loosing a struct
	      (lost-stamp::long (default -1))
	      ;; an allocation owner
	      (owner::variable read-only)
	      ;; can we stack allocate this structure (to be use in conjonction
	      ;; with lost-stamp)
	      (stackable?::bool (default #t))
	      ;; a stamp use for the stack loosing propagation
	      (stack-stamp (default '())))
      
	   (wide-class struct-ref-app::app (approx::approx read-only))
	   (wide-class struct-set!-app::app (approx::approx read-only))))
   
