;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Ast/build.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 14:00:21 1996                          */
;*    Last change :  Thu Aug  8 16:34:59 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    From the code definition, we build the Ast                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_build
   (include "Engine/pass.sch"
	    "Ast/node.sch")
   (import  ast_unit
	    ast_sexp
	    ast_env
	    ast_find-gdefs
	    ast_remove
	    ast_local
	    object_inline
	    tools_args
	    tools_progn
	    tools_location
	    tools_error
	    tools_shape)
   (export  (build-ast             ::obj)
	    (build-ast-sans-remove ::obj)))

;*---------------------------------------------------------------------*/
;*    build-ast ...                                                    */
;*    -------------------------------------------------------------    */
;*    All global variables are now bound, we can now, build the ast.   */
;*---------------------------------------------------------------------*/
(define (build-ast units)
   (remove-var 'ast (build-ast-sans-remove units)))

;*---------------------------------------------------------------------*/
;*    build-ast-sans-remove ...                                        */
;*    -------------------------------------------------------------    */
;*    All global variables are now bound, we can now, build the ast.   */
;*---------------------------------------------------------------------*/
(define (build-ast-sans-remove units)
   (pass-prelude "Ast")
   ;; there are two separate `map' because we can't build
   ;; node of the ast _until_ all the units have been processed
   ;; (otherwise some global variables could be unbound).
   (let ((defs (apply append (map unit->defs units))))
      ;; we can now check if all declared global variables are defined.
      (check-to-be-define)
      ;; and build the regular ast
      (let ((ast (map sfun-def->ast defs)))
	 ;; we inline method into generic functions (this just makes side
	 ;; effects on the body of the generic functions)...
	 (inline-methods!)
	 ;; and we return the constructed ast
	 (pass-postlude ast))))

;*---------------------------------------------------------------------*/
;*    sfun-def->ast ...                                                */
;*---------------------------------------------------------------------*/
(define (sfun-def->ast::global def::global)
   (enter-function (global-id def))
   (let* ((sfun          (global-value def))
	  (sfun-args     (sfun-args sfun))
	  (sfun-body-exp (sfun-body sfun))
	  (def-loc       (find-location (global-src def)))
	  (body          (sexp->node sfun-body-exp
				     sfun-args
				     (find-location/loc sfun-body-exp
							def-loc)
				     'value)))
      (sfun-body-set! sfun body)
      (leave-function)
      def))

