// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: admin.h,v 1.6 1997/10/04 21:13:05 jgg Exp $
/* ######################################################################

   Admin - Base class for all of the administration directory styles
   
   Errors are propagated out through the global Error Class. A return
   result of true indicates the operation succeeded.
   
   Locking and Opening
     Open - Open the administration directory
     Close - Release all locks and close the admin directory
     ReadLock - Aquire a permanent read lock. This is counted, so call 
                UnLock() the same # of times.
     WriteLock - Aquire a permanent write/read lock.
		 This is counted so call UnLock() the same # of times.
     UnLock - Decrease the lock count.

    Note, it will generate an error to write lock a read locked data base.
    Ditto if a readlock or write lock is placed on a writelocked database.
    When open is called the database is readlocked in the filesytem. This
    can be changed to a write lock.

   ##################################################################### */
									/*}}}*/
// Header section: pkglib
#ifndef PKGLIB_ADMIN_H
#define PKGLIB_ADMIN_H

#include <string>

class pkgPackageList;
class pkgConfigData;
class pkgPackage;
class pkgPkgCtrlInfo;

class pkgAdmin
{
   public:
   
   // Locking and opening
   virtual bool Open() = 0;
   virtual bool Close() = 0;
   virtual bool ReadLock() = 0;
   virtual bool WriteLock() = 0;
   virtual bool UnLock() = 0;

   // Construct/destruct
   virtual ~pkgAdmin();
};

#endif
