#include <sys/stat.h>
#include <unistd.h>
#include <time.h>
#include "file.h"
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <utime.h>

int lof_fd(int fd) {
	struct stat buf;

	if(fstat(fd,&buf))
		return -1;
	else
		return buf.st_size;
}

int lof_file(const char *name) {
	struct stat buf;

	if(stat(name,&buf))
		return -1;
	else
		return buf.st_size;
}

int get_mtime_file(const char * name, time_t * t) {
	struct stat buf;

	if(stat(name, &buf))
		return -1;
	if(t)
		memcpy(t, &buf.st_mtime, sizeof(time_t));
	return 0;
}
int get_mtime_fd(int fd, time_t *t) {
	struct stat buf;

	if(fstat(fd, &buf))
		return -1;
	if(t)
		memcpy(t, &buf.st_mtime, sizeof(time_t));
	return 0;
}
int set_mtime_file(const char * name, time_t t) {
	struct utimbuf buf;

	buf.actime = buf.modtime = t;
	return utime(name, &buf);
}
