// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: thread.h,v 1.1 1997/10/25 04:49:55 jgg Exp $
/* ######################################################################

   Thread - Usefull thread classes

   Mutex. These are simple covers to the POSIX pthread_ functions. 
   Mutex is the 'usual' locking mechanism. Use 
       GrabMutex MxGrab(Lock);
   At the top of your function to aquire a lock on the mutex for the 
   duration of the function. This ensured it is released whenever the
   function exits.

   Thread safety in the widget set is simplistic. There is a huge 
   lock around the entire widget set. This provides the simplest to
   explain and to implement form of thread safety. In worker threads 
   you can do something like
         GrabMutex WidgGrab(Widget::WidgetLock);
   So you can use the widget set. For some operations it is probably a
   better idea to use Widget::WidgetLock.TryLock() so the thread doesn't
   block on the GUI. It will update the display approximately 'whenever'
   which is suitable for progress dialogs and the like.
   
   ###################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_THREAD_H
#define DEITY_THREAD_H

#include <pthread.h>

class Mutex
{
   pthread_mutex_t sem;
   void _Dummy();
   
   public:

   inline void Lock() {pthread_mutex_lock(&sem);};
   inline void UnLock() {pthread_mutex_unlock(&sem);};
   inline bool TryLock() {return pthread_mutex_trylock(&sem) == 0;};
   
   inline Mutex() {pthread_mutex_init(&sem,0);};
   inline ~Mutex() {pthread_mutex_destroy(&sem);};
};

class GrabMutex
{
   Mutex *Target;
   void _Dummy();
   
   public:

   void Attach(Mutex &New)
   {
      if (Target != 0)
	 Target->UnLock();
      Target = &New;
      Target->Lock();
   };
   void Detach()
   {
      if (Target != 0)
	 Target->UnLock();
      Target = 0;
   }
   
   inline GrabMutex() : Target(0) {};
   inline GrabMutex(Mutex &Target) : Target(&Target) {Target.Lock();};
   inline ~GrabMutex() {if (Target != 0) Target->UnLock();};
};

#endif
