// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: slangdev.h,v 1.15 1998/01/25 06:46:09 jgg Exp $
/* ######################################################################

   SLangDev - SLang base Input and Graphic support.
   
   The SLang graphic context implements the required graphics support 
   for a Text Grahpic context. In order to do this it needs to provide
   clipping and colour conversion. (See slang.cc for a discussion)
   
   The SLkpFd Keyboard input handler accepts keystrokes from stdin
   through SLang's keymap routines and translates them into Widget
   Events. It is also capable of handling an XTerms mouse reporting
   capability. It also responds to SIGWINCH by resizing the root 
   window.

   SLangAttachDisplay will attempt to attach to slang. It will construct
   and return a Widget which covers the entire screen and has a set 
   colour. It will also attach to the passed select loop anything needed
   to accept input. The size of the returned widget will be kept in sync
   with the actual display size. It also initializes CurGC, CurTextGC and
   CurSLangGC with an instance of SLangGC.

   The correct use for the attach function is to call it, add any new
   widgets/callbacks/etc you need as children of it and then call Loop()
   on the select loop. This will cause the Root widget to be resized
   to match the display (initial sizes of text type root widgets must
   be 80x25) and realize it's family.
   
   ###################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_SLANGDEV_H
#define DEITY_SLANGDEV_H

#include <deity/graphics.h>
#include <deity/selectloop.h>

class Widget;

class SLangGC : public TextGC
{
   struct ColorRec
   {
      unsigned char Fg;
      unsigned char Bg;
   };
   ColorRec Colors[100];
   Rect ClipWin;
   Color Fg;
   Color Bg;
   
   unsigned long MatchColor(Color::TextColor TF,Color::TextColor B);

   protected:
   
   virtual void ClipRect(Rect Win);
   
   public:
   
   static SLangGC *GC;
   
   // String IO
   virtual void DrawText(Rect Pos,Point P,const char *Start,unsigned int Len,
			 unsigned long Flags = 0);
   virtual void DrawText(Point Pos,const char *Start,unsigned int Len,
			 unsigned long Flags = 0);
   virtual unsigned int WrapText(const char *Start,unsigned int Len,long Max);
   
   // Line/box drawing
   virtual void Box(Rect Size);
   virtual void HLine(Point Pos,long Length);
   virtual void Fill(Rect Area,char C = ' ');
   virtual void DrawLineChar(Point Pos,LineChars Char);
   
   // Colors
   virtual void SetColor(Color C);
   virtual void Background(Color C);
   
   // General
   virtual void Flush();
   void Winch();
   
   SLangGC();
   virtual ~SLangGC();
};

class SLkpFd : public SelectLoop::Fd
{
   protected:
   
   // Widget to use as the top of the widget tree
   Widget *Root;
   static bool XTerm;
   unsigned long OldButtons;
   Point LastPos;
   static bool SigWinch;
   static void SigWinchHandler(int);
   static void ResetSLang(int Signal);
   
   virtual bool Read(SelectLoop &Owner);
   virtual bool Signal(SelectLoop &Owner);
   virtual void Setup(SelectLoop &Owner);
   
   public:
   
   SLkpFd(Widget *Root);
   ~SLkpFd();
};

// Attempt to initialize SLang (GPM too)
Widget *SLangAttachDisplay(SelectLoop &Loop);

#endif
