// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: extracache.h,v 1.12 1998/03/02 01:43:36 jgg Exp $
/* ######################################################################

   ExtraCache - Extension data for the cache
   
   Two name sorted lists of packages are maintained. One is sorted purely
   by name and the other is sorted by section and then by name. This
   class also provides Originally pkgDepCache used to be in here, but it 
   has migrated into pkglib.

   ##################################################################### */
									/*}}}*/
#ifndef EXTRACACHE_H
#define EXTRACACHE_H

#include <pkglib/depcache.h>

class Policy;
class ExtraCache : public pkgDepCache
{
   // Helper functions
   static ExtraCache *SortCache;
   static int NameComp(const void *a,const void *b);
   static int SecNameComp(const void *a,const void *b);
   bool Init();
   
   protected:

   // Policy implementation for DepCache
   virtual VerIterator GetCandidateVer(PkgIterator Pkg);
   virtual bool IsImportantDep(DepIterator Dep);
   
   public:
      
   // Name sorted lists of packages
   Package **SortedPkgs;
   Package **SecSortedPkgs;

   Policy &CurPolicy;

   virtual bool ReMap();
   
   ExtraCache(Policy &Pol,string CacheFile,bool Public,bool ReadOnly);   
   ExtraCache(Policy &Pol,bool Public,bool ReadOnly);
   virtual ~ExtraCache();
};

#endif
