/***************************************
  $Header: /home/amb/wwwoffle/RCS/configedit.c 2.12 1998/06/07 09:05:50 amb Exp $

  WWWOFFLE - World Wide Web Offline Explorer - Version 2.2.
  Configuration file management via a web-page.
  ******************/ /******************
  Written by Andrew M. Bishop

  This file Copyright 1997,98 Andrew M. Bishop
  It may be distributed under the GNU Public License, version 2, or
  any higher version.  See section COPYING of the GNU Public license
  for conditions under which this file may be redistributed.
  ***************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/stat.h>
#include <unistd.h>

#include "wwwoffle.h"
#include "misc.h"
#include "config.h"
#include "errors.h"


static void ConfigEditForms(int fd,char ***sections);
static void ConfigEditUpdate(int fd,char *section,char ***sections);

static char ***read_config_file(void);
static int write_config_file(char ***sections);
static void free_sections(char ***sections);


/*++++++++++++++++++++++++++++++++++++++
  The control page that allows editing of the configuration file.

  int fd The file descriptor to write the file to.

  char *args The arguments to the page.

  char *request_body The body of the HTTP request for the page.
  ++++++++++++++++++++++++++++++++++++++*/

void ConfigEditPage(int fd,char *args,char *request_body)
{
 char *newargs=NULL;
 char ***sections;

 if(args)
   {
    if(*args=='!' && strchr(args+1,'!'))
      {
       char *pling;
       newargs=(char*)malloc(strlen(args)+1);
       strcpy(newargs,args+1);
       pling=strchr(newargs,'!');
       *pling=0;
      }
    else if(*args!='!')
      {
       newargs=(char*)malloc(strlen(args)+1);
       strcpy(newargs,args);
      }
   }

 sections=read_config_file();

 if(!sections)
    HTMLMessage(fd,404,"WWWOFFLE Configuration Error",NULL,"ConfigError",
                "section","",
                "reason","ReadError",
                NULL);
 else if(newargs && *newargs)
   {
    int i=0;
    char *section=NULL;

    while(sections[i])
      {
       if(sections[i][1] && !strcmp(sections[i][1],newargs))
         {section=newargs;break;}
       i++;
      }

    if(!section)
       HTMLMessage(fd,404,"WWWOFFLE Configuration Error",NULL,"ConfigError",
                   "section",newargs,
                   "reason","BadSection",
                   NULL);
    else if(!request_body || strncmp(request_body,"value=",6))
       HTMLMessage(fd,404,"WWWOFFLE Configuration Error",NULL,"ConfigError",
                   "section",newargs,
                   "reason","BadBody",
                   NULL);
    else
      {
       char *new,*p,*q;

       new=URLDecode(request_body+6,1);
       for(p=q=new;*p;p++)
          if(*p!='\r')
             *q++=*p;
       *q=0;

       sections[i][2]=new;

       ConfigEditUpdate(fd,section,sections);
      }
   }
 else
    ConfigEditForms(fd,sections);

 if(sections)
    free_sections(sections);

 if(newargs)
    free(newargs);
}


/*++++++++++++++++++++++++++++++++++++++
  The page that contains the forms making up the config file.

  int fd The file descriptor to write to.

  char ***sections The sections of the file.
  ++++++++++++++++++++++++++++++++++++++*/

static void ConfigEditForms(int fd,char ***sections)
{
 int i=-1;
 char *htmlcomment=NULL;

 HTMLMessageHead(fd,200,"WWWOFFLE Configuration Edit Page",
                 NULL);

 if(sections[i] && sections[0][0] && !sections[0][1])
   {
    i=0;
    htmlcomment=HTMLString(sections[i][0]);
   }

 HTMLMessageBody(fd,"ConfigEditPage-Head",
                 "comment",htmlcomment,
                 NULL);

 if(htmlcomment)
    free(htmlcomment);

 while(sections[++i])
    if(sections[i][1])
      {
       if(sections[i][0])
          htmlcomment=HTMLString(sections[i][0]);
       else
          htmlcomment=NULL;

       HTMLMessageBody(fd,"ConfigEditPage-Body",
                       "section",sections[i][1],
                       "comment",htmlcomment,
                       "content",sections[i][2],
                       NULL);

       if(htmlcomment)
          free(htmlcomment);
      }

 HTMLMessageBody(fd,"ConfigEditPage-Tail",
                 NULL);
}


/*++++++++++++++++++++++++++++++++++++++
  Update the configuration file.

  int fd The file descriptor to write the message to.

  char *section The section that was updated.

  char ***sections The sections including the updated one.
  ++++++++++++++++++++++++++++++++++++++*/

static void ConfigEditUpdate(int fd,char *section,char ***sections)
{
 if(write_config_file(sections))
    HTMLMessage(fd,404,"WWWOFFLE Configuration Error",NULL,"ConfigError",
                "section",section,
                "reason","WriteError",
                NULL);
 else
    HTMLMessage(fd,200,"WWWOFFLE Configuration Update",NULL,"ConfigUpdate",
                "section",section,
                NULL);
}


/*++++++++++++++++++++++++++++++++++++++
  Read in the config file into a set of sections.

  char ***read_config_file Returns the sections of the file.
                           x[i][0]=comment, x[i][1]=section name, x[i][2]=section contents,
                           the last x[i] is a NULL.
  ++++++++++++++++++++++++++++++++++++++*/

static char ***read_config_file(void)
{
 int sec_num=0,state=0;
 FILE *conf;
 char ***sections;
 char *line=NULL;
 int line_num=0;

 conf=fopen(ConfigFile,"r");
 if(!conf)
   {PrintMessage(Warning,"Cannot open the config file '%s' for reading.",ConfigFile); return(NULL);}

 sections=(char***)calloc(1,sizeof(char**));

 while((line=fgets_realloc(line,conf)))
   {
    char *l=line;
    char *r=line+strlen(line)-1;

    line_num++;

    while(*l==' ' || *l=='\t' || *l=='\r' || *l=='\n')
       l++;

    if(state==0 && *l=='#')
      {
       state=1;
       sections=(char***)realloc((void*)sections,sizeof(char**)*(sec_num+2));
       sections[sec_num]=(char**)calloc(3,sizeof(char*));
       sections[++sec_num]=NULL;
       sections[sec_num-1][0]=(char*)malloc(strlen(l)+1);
       strcpy(sections[sec_num-1][0],l);
      }
    else if((state==1 || state==2) && *l=='#')
      {
       sections[sec_num-1][0]=(char*)realloc((void*)sections[sec_num-1][0],strlen(sections[sec_num-1][0])+strlen(l)+1);
       strcat(sections[sec_num-1][0],l);
      }
    else if(state==0 && !*l)
      ;
    else if(state==1 && !*l)
       state=0;
    else if((state==0 || state==1) && *l)
      {
       state=2;
       while(r>l && (*r==' ' || *r=='\t' || *r=='\r' || *r=='\n'))
          *r--=0;
       if(sec_num==0 || sections[sec_num-1][1])
         {
          sections=(char***)realloc((void*)sections,sizeof(char**)*(sec_num+2));
          sections[sec_num]=(char**)calloc(3,sizeof(char*));
          sections[++sec_num]=NULL;
         }
       sections[sec_num-1][1]=(char*)malloc(strlen(l)+1);
       strcpy(sections[sec_num-1][1],l);
      }
    else if(state==2 && !*l)
      ;
    else if(state==2 && *l=='{')
      {
       state=3;
       sections[sec_num-1][2]=(char*)malloc(1);
       strcpy(sections[sec_num-1][2],"");
      }
    else if(state==3 && *l=='}')
       state=0;
    else if(state==3)
      {
       sections[sec_num-1][2]=(char*)realloc((void*)sections[sec_num-1][2],strlen(sections[sec_num-1][2])+strlen(line)+1);
       strcat(sections[sec_num-1][2],line);
      }
    else
      {
       line[strlen(line)-1]=0;
       PrintMessage(Warning,"Error parsing config file, line %d = '%s' [state=%d]",line_num,line,state);
       free_sections(sections);
       return(NULL);
      }
   }

 fclose(conf);

 return(sections);
}


/*++++++++++++++++++++++++++++++++++++++
  Write out a set of sections to the config file.

  int write_config_file Returns 1 if in error.

  char ***sections The sections to write out.
  ++++++++++++++++++++++++++++++++++++++*/

static int write_config_file(char ***sections)
{
 char *conf_file_backup=(char*)malloc(strlen(ConfigFile)+5);
 int renamed=0,i=0;
 struct stat buf;
 FILE *conf;

 /* Rename the old file as a backup. */

 strcpy(conf_file_backup,ConfigFile);
 strcat(conf_file_backup,".old");

 if(rename(ConfigFile,conf_file_backup))
    PrintMessage(Warning,"Cannot rename the config file '%s' to '%s'.",ConfigFile,conf_file_backup);
 else
   {
    renamed=1;
    if(stat(conf_file_backup,&buf))
       PrintMessage(Warning,"Cannot stat the config file '%s'.",ConfigFile);
   }

 conf=fopen(ConfigFile,"w");
 if(!conf)
   {PrintMessage(Warning,"Cannot open the config file '%s' for writing.",ConfigFile); return(1);}

 if(renamed)
   {
    chown(ConfigFile,buf.st_uid,buf.st_gid);
    chmod(ConfigFile,buf.st_mode&(~S_IFMT));
   }

 while(sections[i])
   {
    if(sections[i][0])
      {
       fprintf(conf,sections[i][0]);
       fprintf(conf,"\n");
      }
    if(sections[i][1])
      {
       fprintf(conf,"%s\n",sections[i][1]);
       fprintf(conf,"{\n");
       if(sections[i][2])
          fprintf(conf,sections[i][2]);
       if(sections[i][2][strlen(sections[i][2])-1]!='\n')
          fprintf(conf,"\n");
       fprintf(conf,"}\n\n");
      }
    i++;
   }

 fclose(conf);

 free(conf_file_backup);

 return(0);
}


/*++++++++++++++++++++++++++++++++++++++
  Free up a set of sections.

  char ***sections The sections that are to be freed up.
  ++++++++++++++++++++++++++++++++++++++*/

static void free_sections(char ***sections)
{
 int i=0;

 while(sections[i])
   {
    if(sections[i][0])
       free(sections[i][0]);
    if(sections[i][1])
       free(sections[i][1]);
    if(sections[i][2])
       free(sections[i][2]);
    free(sections[i]);
    i++;
   }

 free(sections);
}
