/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import netscape.util.Vector;

public class CompactInputStream
extends InputStream {
    static final int INVALID_BUFFER_COUNT = 8;
    InputStream in;
    int booleanCount = 8;
    int booleanBuffer;
    Vector stringVector = new Vector(128);

    public CompactInputStream(InputStream in) {
        this.in = in;
    }

    public int read() throws IOException {
        this.booleanCount = 8;
        return this.in.read();
    }

    public int read(byte[] value) throws IOException {
        this.booleanCount = 8;
        return this.in.read(value, 0, value.length);
    }

    public int read(byte[] value, int offset, int length) throws IOException {
        this.booleanCount = 8;
        return this.in.read(value, offset, length);
    }

    public long skip(long n) throws IOException {
        if (n > 0L) {
            this.booleanCount = 8;
            return this.in.skip(n);
        }
        return n;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.booleanCount = 8;
        this.in.close();
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public void readFully(byte[] value) throws IOException {
        this.readFully(value, 0, value.length);
    }

    public void readFully(byte[] value, int offset, int length) throws IOException {
        this.booleanCount = 8;
        InputStream in = this.in;
        int total = 0;
        while (total < length) {
            int count = in.read(value, offset + total, length - total);
            if (count < 0) {
                throw new EOFException();
            }
            total += count;
        }
    }

    public int skipBytes(int total) throws IOException {
        int orig = total;
        while (total > 0) {
            total = (int)((long)total - this.skip(total));
        }
        return orig;
    }

    public boolean readCompactBoolean() throws IOException {
        int buf = this.booleanBuffer;
        int count = this.booleanCount;
        if (count >= 8) {
            buf = this.in.read();
            if (buf < 0) {
                throw new EOFException();
            }
            count = 0;
        }
        boolean value = (buf & 1 << count) != 0;
        this.booleanBuffer = buf;
        this.booleanCount = ++count;
        return value;
    }

    public boolean readBoolean() throws IOException {
        this.booleanCount = 8;
        int c = this.in.read();
        if (c < 0) {
            throw new EOFException();
        }
        return c != 0;
    }

    public byte readByte() throws IOException {
        this.booleanCount = 8;
        int c = this.in.read();
        if (c < 0) {
            throw new EOFException();
        }
        return (byte)c;
    }

    public int readUnsignedByte() throws IOException {
        this.booleanCount = 8;
        int c = this.in.read();
        if (c < 0) {
            throw new EOFException();
        }
        return c;
    }

    public short readShort() throws IOException {
        int c2;
        this.booleanCount = 8;
        InputStream in = this.in;
        int c1 = in.read();
        if ((c1 | (c2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (short)((c1 << 8) + c2);
    }

    public int readUnsignedShort() throws IOException {
        int c2;
        this.booleanCount = 8;
        InputStream in = this.in;
        int c1 = in.read();
        if ((c1 | (c2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (c1 << 8) + c2;
    }

    public char readChar() throws IOException {
        int c2;
        this.booleanCount = 8;
        InputStream in = this.in;
        int c1 = in.read();
        if ((c1 | (c2 = in.read())) < 0) {
            throw new EOFException();
        }
        return (char)((c1 << 8) + c2);
    }

    public int readCompactInt() throws IOException {
        this.booleanCount = 8;
        InputStream in = this.in;
        int c = in.read();
        if (c < 0) {
            throw new EOFException();
        }
        if (c == 64) {
            return Integer.MIN_VALUE;
        }
        boolean neg = (c & 0x40) != 0;
        int value = c & 0x3F;
        if ((c & 0x80) != 0) {
            c = in.read();
            if (c < 0) {
                throw new EOFException();
            }
            value |= (c & 0x7F) << 6;
            if ((c & 0x80) != 0) {
                c = in.read();
                if (c < 0) {
                    throw new EOFException();
                }
                value |= (c & 0x7F) << 13;
                if ((c & 0x80) != 0) {
                    c = in.read();
                    if (c < 0) {
                        throw new EOFException();
                    }
                    value |= (c & 0x7F) << 20;
                    if ((c & 0x80) != 0) {
                        c = in.read();
                        if (c < 0) {
                            throw new EOFException();
                        }
                        value |= (c & 0x7F) << 27;
                    }
                }
            }
        }
        if (neg) {
            value = -value;
        }
        return value;
    }

    public int readInt() throws IOException {
        int c4;
        int c3;
        int c2;
        this.booleanCount = 8;
        InputStream in = this.in;
        int c1 = in.read();
        if ((c1 | (c2 = in.read()) | (c3 = in.read()) | (c4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (c1 << 24) + (c2 << 16) + (c3 << 8) + c4;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readCompactUTF() throws IOException {
        int id = this.readCompactInt();
        if (id == 0) {
            return null;
        }
        if (id == 1) {
            return "";
        }
        if (id < 0) {
            String str = this.readUTFBytes(-id);
            this.stringVector.addElement(str);
            return str;
        }
        return (String)this.stringVector.elementAt(id - 2);
    }

    public String readUTF() throws IOException {
        int utflen = this.readUnsignedShort();
        if (utflen == 65535) {
            return null;
        }
        return this.readUTFBytes(utflen);
    }

    private final String readUTFBytes(int utflen) throws IOException {
        this.booleanCount = 8;
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        while (count < utflen) {
            int c = this.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = this.readUnsignedByte();
                    int char3 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                }
                default: {
                    throw new UTFDataFormatException();
                }
            }
        }
        return new String(str, 0, strlen);
    }
}

