/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPEntryComparator;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.client.JDAPMessage;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPSearchResponse;
import netscape.ldap.client.opers.JDAPSearchResultReference;

public class LDAPSearchResults
implements Enumeration {
    private int current = 0;
    private Vector entries;
    private LDAPSearchListener resultSource;
    private boolean searchComplete = true;
    private LDAPConnection connectionToClose = null;
    private LDAPConnection currConn;
    private boolean persistentSearch = false;
    private Vector cacheEntries = null;
    private LDAPSearchConstraints currCons;
    private String currBase;
    private int currScope;
    private String currFilter;
    private String[] currAttrs;
    private boolean currAttrsOnly;
    private Vector referralResults = new Vector();
    private LDAPSearchResults currRes;
    private int totalReferralEntries;
    private boolean firstResult = false;

    public LDAPSearchResults() {
        this.entries = new Vector();
    }

    LDAPSearchResults(LDAPConnection conn, LDAPSearchConstraints cons, String base, int scope, String filter, String[] attrs, boolean attrsOnly) {
        this();
        this.currConn = conn;
        this.currCons = cons;
        this.currBase = base;
        this.currScope = scope;
        this.currFilter = filter;
        this.currAttrs = attrs;
        this.currAttrsOnly = attrsOnly;
    }

    LDAPSearchResults(Vector v) {
        this();
        this.cacheEntries = (Vector)v.clone();
    }

    LDAPSearchResults(Vector v, LDAPConnection conn, LDAPSearchConstraints cons, String base, int scope, String filter, String[] attrs, boolean attrsOnly) {
        this(v);
        this.currConn = conn;
        this.currCons = cons;
        this.currBase = base;
        this.currScope = scope;
        this.currFilter = filter;
        this.currAttrs = attrs;
        this.currAttrsOnly = attrsOnly;
    }

    void add(JDAPProtocolOp sr) {
        if (sr instanceof JDAPSearchResponse) {
            this.add((JDAPSearchResponse)sr);
            return;
        }
        if (sr instanceof JDAPSearchResultReference) {
            this.add((JDAPSearchResultReference)sr);
        }
    }

    void add(JDAPSearchResponse sr) {
        LDAPAttribute[] lattrs = sr.getAttributes();
        LDAPAttributeSet attrs = lattrs != null ? new LDAPAttributeSet(lattrs) : new LDAPAttributeSet();
        String dn = sr.getObjectName();
        LDAPEntry entry = new LDAPEntry(dn, attrs);
        this.entries.addElement(entry);
    }

    void add(JDAPSearchResultReference sr) {
        String[] urls = sr.getUrls();
        if (urls == null) {
            return;
        }
        this.entries.addElement(new LDAPReferralException(null, 0, urls));
    }

    void associate(LDAPSearchListener l) {
        this.resultSource = l;
        this.searchComplete = false;
    }

    void associatePersistentSearch(LDAPSearchListener l) {
        this.resultSource = l;
        this.persistentSearch = true;
        this.searchComplete = false;
        this.firstResult = true;
    }

    void addReferralEntries(LDAPSearchResults res) {
        this.referralResults.addElement(res);
    }

    void closeOnCompletion(LDAPConnection toClose) {
        if (this.searchComplete) {
            try {
                toClose.disconnect();
                return;
            }
            catch (LDAPException lDAPException) {
                return;
            }
        }
        this.connectionToClose = toClose;
    }

    void quicksort(LDAPEntry[] toSort, LDAPEntryComparator compare, int low, int high) {
        if (low >= high) {
            return;
        }
        LDAPEntry pivot = toSort[low];
        int slow = low - 1;
        int shigh = high + 1;
        while (true) {
            if (compare.isGreater(toSort[--shigh], pivot)) {
                continue;
            }
            while (compare.isGreater(pivot, toSort[++slow])) {
            }
            if (slow >= shigh) break;
            LDAPEntry temp = toSort[slow];
            toSort[slow] = toSort[shigh];
            toSort[shigh] = temp;
        }
        this.quicksort(toSort, compare, low, shigh);
        this.quicksort(toSort, compare, shigh + 1, high);
    }

    public synchronized void sort(LDAPEntryComparator compare) {
        while (!this.searchComplete) {
            this.fetchResult();
        }
        while (this.referralResults.size() > 0) {
            this.entries.addElement(this.nextReferralElement());
        }
        this.totalReferralEntries = 0;
        int numEntries = this.entries.size();
        if (numEntries <= 0) {
            return;
        }
        Object[] toSort = new LDAPEntry[numEntries];
        this.entries.copyInto(toSort);
        this.quicksort((LDAPEntry[])toSort, compare, 0, numEntries - 1);
        this.entries.removeAllElements();
        int i = 0;
        while (i < numEntries) {
            this.entries.addElement(toSort[i]);
            ++i;
        }
        this.current = 0;
    }

    public LDAPEntry next() throws LDAPReferralException {
        Object o = this.nextElement();
        if (o instanceof LDAPReferralException) {
            throw (LDAPReferralException)o;
        }
        if (o instanceof LDAPEntry) {
            return (LDAPEntry)o;
        }
        return null;
    }

    public Object nextElement() {
        if (this.cacheEntries == null && !this.persistentSearch && this.current >= this.entries.size() - 1) {
            this.fetchResult();
        }
        if (this.current < this.entries.size()) {
            ++this.current;
            Object next = this.entries.elementAt(this.current - 1);
            this.entries.setElementAt(null, this.current - 1);
            return next;
        }
        if (this.referralResults.size() > 0) {
            return this.nextReferralElement();
        }
        return null;
    }

    Object nextReferralElement() {
        LDAPSearchResults res = (LDAPSearchResults)this.referralResults.elementAt(0);
        if (res.hasMoreElements()) {
            Object obj = res.nextElement();
            if (obj == null || !res.hasMoreElements()) {
                this.referralResults.removeElementAt(0);
            } else {
                ++this.totalReferralEntries;
            }
            return obj;
        }
        this.referralResults.removeElementAt(0);
        return null;
    }

    public boolean hasMoreElements() {
        if (this.current >= this.entries.size() - 1) {
            this.fetchResult();
        }
        if (this.referralResults.size() > 0) {
            return true;
        }
        return this.current < this.entries.size();
    }

    public int getCount() {
        return this.entries.size() + this.totalReferralEntries;
    }

    int getID() {
        if (this.resultSource == null || this.searchComplete) {
            return -1;
        }
        return this.resultSource.getID();
    }

    void abandon() {
        LDAPSearchResults lDAPSearchResults = this;
        synchronized (lDAPSearchResults) {
            this.searchComplete = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void fetchResult() {
        if (this.cacheEntries != null && this.current < this.cacheEntries.size() - 1) {
            LDAPEntry entry = (LDAPEntry)this.cacheEntries.elementAt(this.current + 1);
            LDAPEntry e = new LDAPEntry(entry.getDN(), entry.getAttributeSet());
            this.entries.addElement(e);
            return;
        }
        if (this.resultSource == null) {
            return;
        }
        LDAPSearchResults lDAPSearchResults = this;
        synchronized (lDAPSearchResults) {
            if (this.searchComplete || this.firstResult) {
                this.firstResult = false;
                return;
            }
            JDAPMessage msg = this.resultSource.nextResult();
            if (msg == null) {
                try {
                    JDAPMessage response = this.resultSource.getResponse();
                    this.currConn.checkMsg(response);
                }
                catch (LDAPReferralException e) {
                    try {
                        this.performReferrals(e);
                    }
                    catch (Exception le) {
                        System.err.println("Exception: " + le);
                    }
                }
                catch (LDAPException e) {
                    System.err.println("Exception: " + e);
                }
                this.searchComplete = true;
                if (this.connectionToClose == null) return;
                try {
                    this.connectionToClose.disconnect();
                }
                catch (LDAPException lDAPException) {}
            } else {
                try {
                    this.currConn.checkMsg(msg);
                }
                catch (LDAPReferralException e) {
                    try {
                        this.performReferrals(e);
                        return;
                    }
                    catch (Exception le) {
                        System.err.println("Exception: " + le);
                    }
                }
                catch (LDAPException e) {
                    System.err.println("Exception: " + e);
                }
                JDAPProtocolOp op = msg.getProtocolOp();
                if (op instanceof JDAPSearchResponse) {
                    this.add((JDAPSearchResponse)op);
                } else {
                    this.add(op);
                }
                return;
            }
            this.connectionToClose = null;
            return;
        }
    }

    void performReferrals(LDAPReferralException e) throws LDAPException {
        LDAPSearchResults[] currRes = new LDAPSearchResults[1];
        this.currConn.performReferrals(e, this.currCons, 3, this.currBase, this.currScope, this.currFilter, this.currAttrs, this.currAttrsOnly, null, null, null, currRes, null);
        this.referralResults.addElement(currRes[0]);
    }
}

