(defun ispell-expand-affixes () (interactive)
  (shell-command-on-region (mark) (point) "ispell -d norsk -e"))

(defun ispell-collect-affixes () (interactive)
  (shell-command-on-region (mark) (point) "munchlist -l norsk.aff"))

(defun search-my-string () (interactive)
  (re-search-forward "\\(.*em\\)\n\\1en"))

(defun ispell-expand-line () (interactive)
  (save-excursion
  (beginning-of-line)
  (let ((beg (point)))
  (end-of-line)
  (let ((end (point))))
  (shell-command-on-region beg (point) "ispell -d norsk -e"))))


(global-set-key [?\C-c ?\C-v] 'ispell-expand-affixes)
(global-set-key [?\C-c ?\C-b] 'ispell-collect-affixes)
(global-set-key [?\C-c ?\C-s] 'search-my-string)
(global-set-key [?\C-c ?\C-c] 'ispell-expand-line)

(global-set-key [f3] 'nonincremental-re-search-forward)
(global-set-key [f4] 'nonincremental-repeat-re-search-forward)
(global-set-key [f5] 'insert-register)
(global-set-key [f6] 'copy-to-register)