#include "config.h"

#include <stdio.h>
#include <string.h>

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

/* parses user key definition file */

/* The file is assumed to have a simple format:
 *
 *   set "keyname"  function
 *   unset "keyname"
 *
 * For example:
 *
 *   unsetkey "^K"
 *   setkey exit "^Kx"
 *
 * Comments extend from the first '%' character to the end of the line.
 */

#include <slang.h>
#include "jdmacros.h"
#include "most.h"
#include "keyparse.h"

static unsigned int Line_Num;

static void parse_error (char *s)
{
   fprintf(stderr, "Most: Error reading keymap file on line %u.\n%s\n",
	   Line_Num, s);

   most_exit_error (NULL);
}

static int unsetkey_fun (int, SLcmd_Cmd_Table_Type *);
static int setkey_fun (int, SLcmd_Cmd_Table_Type *);
static SLcmd_Cmd_Type Startup_File_Cmds[] =
{
     {unsetkey_fun, "unsetkey", "S"},
     {setkey_fun, "setkey", "SS"},
     {NULL, "", ""}
};
static SLcmd_Cmd_Table_Type Cmd_Table;

static int setkey_fun (int argc, SLcmd_Cmd_Table_Type *table) /*{{{*/
{
   char *fun = table->string_args[1];
   char *key = table->string_args[2];

   (void) argc;
   if (NULL == SLang_find_key_function(fun, Most_Keymap))
     {
	parse_error ("Undefined function");
     }

   if (0 != SLang_define_key (key, fun, Most_Keymap))
     parse_error ("Error setting key");

   return 0;
}

static int unsetkey_fun (int argc, SLcmd_Cmd_Table_Type *table) /*{{{*/
{
   char *key = table->string_args[1];

   (void) argc;

   SLang_undefine_key (key, Most_Keymap);
   return 0;
}

static int parse_file (FILE *fp)
{
   char buf[256];

   Cmd_Table.table = Startup_File_Cmds;

   Line_Num = 0;
   while (NULL != fgets (buf, sizeof (buf), fp))
     {
	Line_Num++;
	(void) SLcmd_execute_string (buf, &Cmd_Table);
	if (SLang_Error)
	  parse_error ("Undefined keyword");
     }

   return 0;
}

int most_load_user_keymaps (void)
{
#ifndef VMS
   char filebuf[MAX_PATHLEN];
   int len;
#endif
   char *file;
   FILE *fp;

   if (NULL == (file = getenv ("MOST_INITFILE")))
     {
#ifdef VMS
	file = "SYS$LOGIN:MOST.RC";
#else
	*filebuf = 0;
	file = getenv ("HOME");
	if (file != NULL) strcpy (filebuf, file);
	file = filebuf;

	len = strlen (file);
	if (len && (file[len - 1] == '/')) file[len - 1] = 0;
	strcat (file, "/.mostrc");
#endif
     }

   if (NULL == (fp = fopen (file, "r"))) return 1;
   parse_file (fp);
   fclose (fp);
   if (SLang_Error)
     {
	SLang_Error = 0;
	return -1;
     }
   return 0;
}

