;; $Id: dbl1bmno.dsl 1.7 1998/07/19 16:10:53 nwalsh Exp $
;;
;; This file is part of the Modular DocBook Stylesheet distribution.
;; See ../README or http://nwalsh.com/docbook/dsssl/
;;

;; ----------------------------- Localization -----------------------------

;; Norsk Bokml localization.
;; Translated by Stig S. Bakken, ssb@guardian.no
;; Send changes to Norman Walsh, ndw@nwalsh.com

;; The generated text for cross references to elements.  See dblink.dsl
;; for a discussion of how substitution is performed on the %x and #x
;; keywords.
;;

(define (gentext-bmno-xref-strings giname)
  (case giname
    (("APPENDIX") (if %chapter-autolabel%
		      "Tillegg %n"
		      "tillegget kalt %t"))
    (("ARTICLE") "\U-201C;%t\U-201D;")
    (("BOOK") "%t")
    (("CHAPTER") (if %chapter-autolabel%
		     "Kapittel %n"
		     "kapittelet kalt %t"))
    (("EQUATION") "Formel %n")
    (("EXAMPLE") "Eksempel %n")
    (("FIGURE") "Figur %n")
    (("INFORMALTABLE") "%kg %kn")
    (("LISTITEM") "%n")
    (("PART") "Del %n")
    (("PREFACE") "%t")
    (("PROCEDURE") "Prosedyre %n, %t")
    (("SECT1") (if %section-autolabel% 
		   "Seksjon %n" 
		   "seksjonen kalt %t#c"))
    (("SECT2") (if %section-autolabel% 
		   "Seksjon %n" 
		   "seksjonen kalt %t#c"))
    (("SECT3") (if %section-autolabel% 
		   "Seksjon %n" 
		   "seksjonen kalt %t#c"))
    (("SECT4") (if %section-autolabel% 
		   "Seksjon %n" 
		   "seksjonen kalt %t#c"))
    (("SECT5") (if %section-autolabel% 
		   "Seksjon %n" 
		   "seksjonen kalt %t#c"))
    (("STEP") "steg %n#k")
    (("TABLE") "Tabell %n")
    (("TITLE") "%kg %kn")
    (else (string-append "[xref til " 
			 (if giname 
			     giname
			     "ikke-eksisterende element")
			 " ikke st&oslash;ttet]"))))

;; Indirection in the generated text for cross references.  The first
;; element of the list is used for cross references across element
;; boundries, the second element is used for cross references within
;; the same element
;;
(define (gentext-bmno-xref-strings-indirect key)
  (case key
    (("b") '("" ""))
    (("c") '(" i %cg %cn" ""))
    (("d") '("" ""))
    (("k") '(" i %kg %kn" ""))
    (("s") '("" ""))))

;; Should the TOC come first or last?
;;
(define %generate-bmno-toc-in-front% #t)

;; gentext-bmno-element-name returns the generated text that should be 
;; used to make reference to the selected element.
;;
(define (gentext-bmno-element-name giname)
  (case giname
    (("ABSTRACT") "Abstract")
    (("APPENDIX") "Tillegg")
    (("BIBLIOGRAPHY") "Bibliografi")
    (("CAUTION") "OBS")
    (("CHAPTER") "Kapittel")
    (("COPYRIGHT") "Copyright")
    (("DEDICATION") "Dedikasjon")
    (("EQUATION") "Formel")
    (("EXAMPLE") "Eksempel")
    (("FIGURE") "Figur")
    (("GLOSSARY") "Ordliste")
    (("GLOSSSEE") "Se")
    (("GLOSSSEEALSO") "Se Ogs&aring;")
    (("IMPORTANT") "VIKTIG")
    (("INDEX") "Indeks")
    (("LEGALNOTICE") "")
    (("MSGAUD") "Publikum")
    (("MSGLEVEL") "Niv&aring;")
    (("MSGORIG") "Opphav")
    (("NOTE") "NOTAT")
    (("PART") "Del")
    (("PREFACE") "Forord")
    (("PROCEDURE") "Prosedyre")
    (("REFERENCE") "Referanse")
    (("REFNAME") "Navn")
    (("REVHISTORY") "Revisjonshistorie")
    (("REVISION") "Revisjon")
    (("SECT1") "Seksjon")
    (("SECT2") "Seksjon")
    (("SECT3") "Seksjon")
    (("SECT4") "Seksjon")
    (("SECT5") "Seksjon")
    (("SIDEBAR") "")
    (("STEP") "steg")
    (("TABLE") "Tabell")
    (("TIP") "TIPS")
    (("TOC") "Innholdsfortegnelse")
    (("WARNING") "ADVARSEL")
    (else (string-append "UVENTET-ELEMENTNAVN: " giname))))

;; gentext-bmno-element-name-space returns gentext-bmno-element-name with a 
;; trailing space, if gentext-bmno-element-name isn't "".
;;
(define (gentext-bmno-element-name-space giname)
  (string-with-space (gentext-bmno-element-name giname)))

;; gentext-bmno-intra-label-sep returns the seperator to be inserted
;; between multiple occurances of a label (or parts of a label)
;; for the specified element.  Most of these are for enumerated
;; labels like "Figure 2-4", but this function is used elsewhere
;; (e.g. REFNAME) with a little abuse.
;;
(define (gentext-bmno-intra-label-sep giname)
  (case giname
    (("EQUATION") "-")
    (("EXAMPLE") "-")
    (("FIGURE") "-")
    (("PROCEDURE") ".")
    (("REFENTRY") ".")
    (("REFERENCE") ".")
    (("REFNAME") ", ")
    (("REFSECT1") ".")
    (("REFSECT2") ".")
    (("REFSECT3") ".")
    (("SECT1") ".")
    (("SECT2") ".")
    (("SECT3") ".")
    (("SECT4") ".")
    (("SECT5") ".")
    (("STEP") ".")
    (("TABLE") "-")
    (("_PAGENUMBER") "-")  ;; page number psuedo element
    (else "")))

;; gentext-bmno-label-title-sep returns the seperator to be inserted
;; between a label and the text following the label for the
;; specified element.  Most of these are for use between
;; enumerated labels and titles like "1. Chapter One Title", but
;; this function is used elsewhere (e.g. NOTE) with a little
;; abuse.
;;
(define (gentext-bmno-label-title-sep giname)
  (case giname
    (("ABSTRACT") ": ")
    (("APPENDIX") ". ")
    (("CAUTION") "")
    (("CHAPTER") ". ")
    (("EQUATION") ". ")
    (("EXAMPLE") ". ")
    (("FIGURE") ". ")
    (("FOOTNOTE") ". ")
    (("GLOSSSEE") ": ")
    (("GLOSSSEEALSO") ": ")
    (("IMPORTANT") ": ")
    (("NOTE") ": ")
    (("ORDEREDLIST") ". ")
    (("PART") ". ")
    (("PROCEDURE") ". ")
    (("PREFIX") ". ")
    (("REFENTRY") "")
    (("REFERENCE") ". ")
    (("REFSECT1") ". ")
    (("REFSECT2") ". ")
    (("REFSECT3") ". ")
    (("SECT1") ". ")
    (("SECT2") ". ")
    (("SECT3") ". ")
    (("SECT4") ". ")
    (("SECT5") ". ")
    (("STEP") ". ")
    (("TABLE") ". ")
    (("TIP") ": ")
    (("WARNING") "")
    (else "")))

(define ($lot-title-bmno$ lotgi)
  (cond ((string=? "TABLE"   lotgi) "Tabelloversikt")
	((string=? "EXAMPLE" lotgi) "Eksempeloversikt")
	((string=? "FIGURE"  lotgi) "Figuroversikt")
	((string=? "EQUATION" lotgi) "Formeloversikt")
	(else "???-oversikt")))

(define %gentext-bmno-start-quote%  (dingbat "ldquo"))

(define %gentext-bmno-end-quote%  (dingbat "rdquo"))

(define %gentext-bmno-by% "av") ;; e.g. Copyright 1997 "by" A. Nonymous
                           ;; Authored "by" Jane Doe

(define %gentext-bmno-edited-by% "Redigert av")
                           ;; "Edited by" Jane Doe

(define %gentext-bmno-page% "")

(define %gentext-bmno-and% "og")

(define %gentext-bmno-bibl-pages% "Sdr.")

(define %gentext-bmno-endnotes% "Sluttnotater")

(define %gentext-bmno-table-endnotes% "Notater:")

(define %gentext-bmno-index-see% "See")

(define %gentext-bmno-index-seealso% "See Also")
