# Makefile fragment for pdfTeX and web2c. --infovore@xs4all.nl. Public domain.
# This fragment contains the parts of the makefile that are most likely to
# differ between releases of pdfTeX.

# The libraries are not mentioned.  As the matter stands, a change in their
# number or how they are configured requires changes to the main distribution
# anyway.

Makefile: $(srcdir)/pdftexdir/pdftex.make

# The C sources.
pdftex_c = pdftexini.c pdftex0.c pdftex1.c pdftex2.c
pdftex_o = pdftexini.o pdftex0.o pdftex1.o pdftex2.o pdftexextra.o

# Generation of the web and ch files.
pdftex.web: tie tex.web tex.ch pdftexdir/pdftex.ch
	./tie -m pdftex.web $(srcdir)/tex.web $(srcdir)/tex.ch \
         $(srcdir)/pdftexdir/pdftex.ch
pdftex.ch: 
	-rm -f pdftex.ch
	cp /dev/null pdftex.ch

linux_build_dir = $(HOME)/pdftex/build/linux/texk/web2c

pdftex-djgpp: $(web2c_programs)
	@if test ! -x $(linux_build_dir)/tangle; then echo Error: linux_build_dir not ready; exit -1; fi
	rm -f web2c/fixwrites web2c/splitup web2c/web2c
	ln -s $(linux_build_dir)/web2c/fixwrites web2c
	ln -s $(linux_build_dir)/web2c/splitup web2c
	ln -s $(linux_build_dir)/web2c/web2c web2c
	touch web2c/fixwrites web2c/splitup web2c/web2c
	make tie; rm -f tie
	ln -s $(linux_build_dir)/tie .; touch tie
	make tangleboot; rm -f tangleboot
	ln -s $(linux_build_dir)/tangleboot .; touch tangleboot
	make tangle; rm -f tangle
	ln -s $(linux_build_dir)/tangle .; touch tangle
	make pdftex

pdftex.zip: pdftex ttf2afm
	rm -f pdftex.zip pdftex ttf2afm
	XLDFLAGS=-static make pdftex ttf2afm
	strip pdftex ttf2afm
	cp ../kpathsea/texmf.cnf .
	zip pdftex.zip pdftex pdftex.pool texmf.cnf ttf2afm

pdftex-djgpp.zip: pdftex ttf2afm
	rm -f pdftex.zip pdftex ttf2afm
	XLDFLAGS=-static make pdftex ttf2afm
	dos-strip pdftex ttf2afm
	dos-stubify pdftex ttf2afm
	cp ../kpathsea/texmf.cnf .
	zip pdftex.zip pdftex.exe pdftex.pool texmf.cnf ttf2afm.exe

pdftex_sources = \
configure \
configure.in \
Makefile.in \
libs \
reautoconf \
selfautofix \
tetex.ac \
withenable.ac \
texk/config.guess \
texk/kpathsea/configure.in \
texk/kpathsea/configure \
texk/kpathsea/stamp-auto.in \
texk/kpathsea/withenable.ac \
texk/make/library.make \
texk/web2c/Makefile.in \
texk/web2c/c-auto.in \
texk/web2c/fmtutil.in \
texk/web2c/configure \
texk/web2c/configure.in \
texk/web2c/stamp-auto.in \
texk/web2c/tex.ch \
texk/web2c/pdftexdir

pdftex_test_files = \
texk/web2c/tests/texmf.cnf \
texk/web2c/tests/pdftex.cfg \
texk/web2c/tests/test.map \
texk/web2c/tests/pdftest.tex \
texk/web2c/tests/pdftex.ini \
texk/web2c/tests/8a.enc \
texk/web2c/tests/cmtext.enc \
texk/web2c/tests/cmr10.tfm \
texk/web2c/tests/ptmr.tfm \
texk/web2c/tests/ptmr.vf \
texk/web2c/tests/rptmr.tfm \
texk/web2c/tests/rpsyr.tfm \
texk/web2c/tests/image.jpg \
texk/web2c/tests/image.pdf \
texk/web2c/tests/image.png \
texk/web2c/tests/cmr10.pfb

pdftexsrc:
	cd $(kpathsea_srcdir_parent)/..; tar cvfz ~/pdftex/misc/$@.tgz $(pdftex_sources) $(pdftex_test_files)

pdftex_test:
	rm -rf tests; mkdir tests; cp pdftex.pool tests
	for i in $(pdftex_test_files); do cp $(kpathsea_srcdir_parent)/../$$i tests; done
	cd tests; TEXMFCNF=. ../pdftex -ini pdftex.ini && ../pdftex pdftest.tex

ttf2afm: ttf2afm.o
	$(kpathsea_link) ttf2afm.o
ttf2afm.o: ttf2afm.c macnames.c
	$(compile) $<
ttf2afm.c:
	$(LN) $(srcdir)/pdftexdir/ttf2afm.c .
macnames.c:
	$(LN) $(srcdir)/pdftexdir/macnames.c .

# end of pdftex.make
