
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <X11/Intrinsic.h>
#include <linux/soundcard.h>
#include <signal.h>

#include "types.h"
#include "audio_types.h"

void play_file(char *fname)
{
   WaveHeader wh;
   int  wfile,audio;
   byte *audiobuf=NULL;
   int abuf_size,check;
   int i,j;
   
   if ((wfile=open(fname,O_RDONLY))==-1) {
     perror("wplay: Couldn't open file !\n");
     return;
   }
   
   read (wfile,&wh,sizeof(WaveHeader));
   
   if (strncmp(wh.main_chunk,"RIFF",4)!=0) {
     perror("wplay: Not a Wave file !\n");
     close(wfile);
     return;
   }
   
   if (strncmp(wh.wave_chunk,"WAVEfmt ",8)!=0) {
     perror("wplay: Not a Wave file !\n");
     close(wfile);
     return;
   }
   /* only pcm coded waves supported yet ! */
   if (wh.format!=1) {
     perror("wplay: Only pcm coded wave supported yet !\n");
     close(wfile);
     return;
   }

   if ((wh.res!=8) && (wh.res!=16)) {
     perror("wplay: Unsupported resolution !\n");
     close(wfile);
     return;
   }
   /* seek to begin of data header */
   if (lseek(wfile,wh.chunk_length-12,SEEK_CUR)==-1)  {
   	perror("wplay: While call fseek !\n");
	close(wfile);
	return;
   }   

   read (wfile,&wh.length,sizeof(ulong));

   audio=open ("/dev/dsp", O_WRONLY, 0);
   if (audio == -1) {
	perror("wplay: While opening audio device !\n");
	close(wfile);
	return;
   }
   check=wh.res;
   if (ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &check)==-1) {
	perror("wplay: While setting sample resolution !\n");
	close(wfile);
	close(audio);
	return;
   }
   check=wh.modus-1;
   if (ioctl(audio, SNDCTL_DSP_STEREO, &check)==-1) {
	perror("wplay: While setting stereo/mono !\n");
	close(wfile);
	close(audio);
	return;
   }
   check=(int) wh.freq;
   if (ioctl(audio, SNDCTL_DSP_SPEED, &check)==-1) {
	perror("wplay: While setting speed !\n");
	close(wfile);
	close(audio);
	return;
   }
   ioctl(audio, SNDCTL_DSP_GETBLKSIZE, &abuf_size);
   if (abuf_size < 1024 || abuf_size > 2*65536) {
	perror("wplay: While getting audio buffer size !\n");
	close(wfile);
	close(audio);
	return;
   }
   if ((audiobuf = (byte *) malloc(abuf_size)) == NULL) {
	perror("wplay: While alloc mem for audio buffer !\n");
	close(wfile);
	close(audio);
	return;
   }
	   
   while(wh.length) {
	i = wh.length;
	if (i > abuf_size) i = abuf_size;
        if (read (wfile,audiobuf,i)==0) wh.length=0;
	j = i;
	if (j > 0) {
		if (write(audio, audiobuf, j) != j) {
			perror("wplay: While writing audio device !\n");
			close(wfile);
			close(audio);
			free(audiobuf);
			return;
		}
		wh.length -= j;
	} else wh.length = 0;	/* stop */
   }
   close(wfile);
   close(audio);
   free(audiobuf);
   return;
}

void main(int argc,char *argv[])
{
   int i;
   for (i=1;i<argc;i++) play_file(argv[i]);
}
   