/******************************************************************************
*   WMSound	WindowMaker Sound Server	                              *
*   Copyright (C) 1998  Anthony Quinn <southgat@frontiernet.net               *
*									      *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.					      *
*									      *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                 *
*******************************************************************************/

#include "formats.h"

#define NO_SOUND_DEV    1
#define NO_MEMORY       2
#define ERR_DSP_SYNC    3
#define ERR_DSP_CHAN    4
#define ERR_DSP_SETFMT  5
#define ERR_DSP_STEREO  6
#define ERR_DSP_SPEED   7
#define ERR_WRITE_DATA  8
#define ERR_READ_DATA   9
#define ERR_NOT_RIFF    10
#define ERR_FORMAT_TAG  11
#define ERR_DATA_TAG    12
#define ERR_NOFSTREAM   13
#define ERR_UNSUPPORTED 14
#define ERR_ONSTAT      15

const char *ErrorMsg[] = {
	"",
	"Could not open sound device",
	"Out of Memory",
	"Error synchronizing dsp",
	"Error setting channels",
	"Error with dsp setfmt",
	"Error with dsp stereo",
	"Error with dsp speed",
	"Error writing data",
	"Error reading data",
	"Error file not in RIFF format",
	"Error Format Tag not found",
	"Error Data Tag Not Found",
	"Could not open a file stream",
	"Error Unsuported Wav Format",
	"Error on stat call"
};
int sPlayFile(char *sound_file, char *audiodev);
int sCoreAu(char *sound_file, char *audiodev);
int sCoreRiff(char *sound_file, char *audiodev);
int sCoreDumpWav(char *sound_file);
int sCoreDumpAu(char *sound_file);
int goto_chunk(FILE *instream, int chunk);
dword Read_LE_DWORD(FILE *fstream);
word Read_LE_WORD(FILE *fstream);
dword Read_BE_DWORD(FILE *fstream);
word Read_BE_WORD(FILE *fstream);
