set dirpath {"/tcl/lib/tcl7.5" "/Program Files/tcl/lib/tcl7.5"}

proc my_copy {src dst} {
	if {[catch {open $src r} sf]} {
		puts stderr "couldn't copy from $src: $sf"
		return 0
	}
	if {[catch {file stat $src sstat} err]} {
		puts stderr "couldn't stat $src for permissions: $err"
		close $src
		return 0
	}
	if {[file isdirectory $dst]} {
		set dst [file join $dst [file tail $src]]
	}
	if {[catch {open $dst w $sstat(mode)} df]} {
		puts stderr "couldn't copy to $dst: $df"
		close $sf
		return 0
	}
	fconfigure $sf -translation binary
	fconfigure $df -translation binary
#	if {[catch {read $sf} data]} {
#		puts stderr "couldn't read data from $src: $data"
#		close $sf
#		close $df
#		return 0
#	}
#	close $sf
#	if {[catch {puts -nonewline $df $data} err]} {
#		puts stderr "couldn't write data to $dst: $err"
#		close $df
#		return 0
#	}
#	close $df
	if {[catch {unsupported0 $sf $df $sstat(size)} err]} {
		puts stderr "couldn't copy data using unsupported0: $err"
		close $sf
		close $df
		return 0
	}
	close $sf
	close $df
	return 1
}

proc do_install dir {
	if {$tcl_version >= 7.6} {
		if {[catch {file copy -force tclmidi.dll "$dir"} err]} {
			puts stderr "couldn't copy tclmidi.dll to $dir"
			gets stdin
			exit 1
		}
	} else {
		if {![my_copy tclmidi.dll "$dir"]} {
			puts stderr "couldn't copy tclmidi.dll to $dir"
			gets stdin
			exit 1
		}
	}
	puts "about to call pkg_mkIndex \"$dir\" *.dll"
	if {[catch {pkg_mkIndex "$dir" *.dll} errMsg]} {
		puts stderr "Installation in $dir failed: $errMsg"
		gets stdin
	}
}

foreach d $dirpath {
	if {[file exists $d] && [file isdirectory $d]} {
		puts -nonewline stdout "Install in $d? "
		flush stdout
		set repl [gets stdin]
		set first [string index $repl 0]
		if {$first == "y" || $first == "Y"} {
			do_install $d
			puts "Installation complete in $d"
			puts "Press return to exit"
			gets stdin
			exit 0
		}
	}
}

puts -nonewline stdout "Enter installation directory for tclmidi: "
flush stdout
set repl [gets stdin]
if {[string length $repl] == 0} {
	puts stderr "Installation aborted"
	puts "Press return to exit"
	exit 1
}
regsub {\\} $repl / cust_dir
do_install $cust_dir
puts "Installation complete in $cust_dir"
puts "Press return to exit"
gets stdin
exit 0
