/* Synaesthesia - program to display sound graphically
   Copyright (C) 1997  Paul Francis Harrison

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  675 Mass Ave, Cambridge, MA 02139, USA.

  The author may be contacted at:
    phar6@student.monash.edu.au
  or
    27 Bond St., Mt. Waverley, 3149, Melbourne, Australia
*/

/***************************************/
/*   For the incurably fiddle prone:   */

/* log2 of sample size */
#define m 8 

/* overlap amount between samples. Set to 1 or 2 if you have a fast computer */
#define overlap 0 

/* Brightness */
#define brightness 150

/* Sample frequency*/
#define frequency 22050

/***************************************/


#define PROGNAME "synaesthesia"

#ifdef __FreeBSD__

typedef unsigned short sampleType;

#else

typedef short sampleType;

#ifndef __linux__

#warning This target has not been tested!

#endif
#endif

void error(char *str);
void inline attempt(int x,char *y) { if (x == -1) error(y); }  
void warning(char *str);
void inline attemptNoDie(int x,char *y) { if (x == -1) warning(y); } 

#define n (1<<m)
#define recSize (1<<m-overlap)

/* core */
extern volatile sampleType *data;
extern unsigned char *output;
extern int outWidth, outHeight;
extern int brightFactor;

void coreInit();
int coreGo();

void screenInit(int xHint,int yHint,int widthHint,int heightHint);
void screenEnd(void);
void screenShow(void);
void sizeRequest(int width,int height);
int sizeUpdate(void);

void inputUpdate(int &mouseX,int &mouseY,int &mouseButtons,char &keyHit);

int processUserInput(void); //True == abort now
void showOutput(void);

/* bitmap */
enum SymbolID {
  Bulb = 0, 
  Speaker = 1, Play = 2, Pause = 3, Stop = 4, SkipFwd = 5, SkipBack = 6,
  Handle = 7, Pointer = 8, Open = 9, NoCD = 10, Exit = 11,
  Zero = 12, One = 13, Two = 14, Three = 15, Four = 16,
  Five = 17, Six = 18, Seven = 19, Eight = 20, Nine = 21, Ten = 22,
  Colon = 22, Slider = 23, Selector = 24,
  SymbolCount = 25
};

enum TransferType {
  HalfBlue, HalfRed, MaxBlue, MaxRed
};

void putSymbol(int x,int y,int id,TransferType typ);

void putString(char *string,int x,int y,int red,int blue);

/* sound */
enum SoundSource { SourceLine, SourceCD, SourcePipe };

void cdOpen(char *cdromName);
void cdClose(void);
void cdGetStatus(int &track, int &frames, SymbolID &state);
void cdPlay(int trackFrame, int endFrame=-1); 
void cdStop(void);
void cdPause(void);
void cdResume(void);
void cdEject(void);
void cdCloseTray(void);
int cdGetTrackCount(void);
int cdGetTrackFrame(int track);
void openSound(SoundSource sound, int downFactor, int windowSize, 
               char *dspName, char *mixerName);
void closeSound();
void setupMixer(double &loudness);
void setVolume(double loudness);
int getNextFragment(void);

