// Sound recorder 0.05 Aug 01 1998, GPL 2 (see COPYRIGHTS)
// 1997, 1998  B. Warmerdam

#ifndef _soundrec_h
#define _soundrec_h

#include <sys/soundcard.h>
#include <string.h>
#include <iostream.h>

enum OUTPUT_FORMATS { WAV = 1, PCM };

class recordSettings {

	public:
		recordSettings();
		~recordSettings();

		const bool		setChannels(const unsigned _channels);
		const bool		setSampleRate(const unsigned _sampleRate);
		const bool		setFileFormat(const unsigned _fileFormat);
		const bool		setRecordFormat(const unsigned _recordFormat);
		const bool		setBitsPerSample(const unsigned _bitsPerSample);
		const bool		setExecStmt(const char * _statement);
		const bool		setIoFile(const char * _iofile);
		const bool		setNumberOfSamples(const long _numberOfSamples);
		const bool		setStartTimeOfSamples(const long _startTimeOfSamples);
		const bool		setStopTimeOfSamples(const long _stopTimeOfSamples);
		const bool		setShowSettings(const bool _show);
		const bool		setQuiet(const bool _quiet);
		const bool		setQuitOnError(const bool _quitOnError);
		const bool		setForceFileCreate(const bool _forceFileCreate);
		const bool		setHighPrioOnAudioThr(const bool _highPrioOnAudioThr);
		const bool		setSoundDevice(const char * _soundDevice);
		const bool		setMixerDevice(const char * _mixerDevice);
		const bool		setCdromDevice(const char * _cdromDevice);

		const unsigned		getChannels() const;
		const unsigned		getBitsPerSample() const;
		const unsigned		getSampleRate() const;
		const unsigned		getFileFormat() const;
		const unsigned		getRecordFormat() const;
		const bool		getQuiet() const;
		const char		* getIoFile() const;
		const char		* getExecStmt() const;
		const long		getStartTimeOfSamples() const;
		const long		getStopTimeOfSamples() const;
		const bool		getQuitOnError() const;
		const bool		getForceFileCreate() const;
		const bool		getHighPrioOnAudioThr() const;
		const char *		getSoundDevice() const;
		const unsigned long	getNumberOfSamples() const;
		const char *		getMixerDevice() const;
		const char *		getCdromDevice() const;

		char			track_list[100];		// track 00-99
	private:
		char			* iofile;
		unsigned		bitsPerSample;
		unsigned		recordFormat;
		unsigned		sampleRate;
		int			channels;
		int			fileFormat;
		char			* exec_stmt;
		unsigned long		numberOfSamples;
		unsigned		startTimeOfSamples;
		unsigned		stopTimeOfSamples;
		bool			show;
		bool			quiet;
		bool			quitOnError;
		bool			forceFileCreate;
		bool			highPrioOnAudioThr;

		char			soundDevice[1024];
		char			mixerDevice[1024];
		char			cdromDevice[1024];
};

#endif
