/* Copyright (c) 1997 The Regents of the University of California.
* For information on usage and redistribution, and for a DISCLAIMER OF ALL
* WARRANTIES, see the file, "LICENSE.txt," in this distribution.  */

/* misc. */

#include "m_pd.h"
#include <math.h>
#include <stdio.h>
#include <string.h>

#ifdef NT
int random(void)
{
    static int foo = 1489853723;
    foo = foo * 435898247 + 9382842987;
    return (foo & 0x7fffffff);
}
#endif

/* -------------------------- random ------------------------------ */
static t_class *random_class;

typedef struct _random
{
    t_object x_obj;
    t_float x_f;
} t_random;

static void *random_new(t_floatarg f)
{
    t_random *x = (t_random *)pd_new(random_class);
    x->x_f = f;
    floatinlet_new(&x->x_obj, &x->x_f);
    outlet_new(&x->x_obj, &s_float);
    return (x);
}

static void random_bang(t_random *x)
{
    int n = x->x_f;
    int range = (n < 1 ? 1 : n);
    int nval = ((double)range) * ((double)random())
    	* (1./2147483648.);
    if (nval >= range) nval = range-1;
    outlet_float(x->x_obj.ob_outlet, nval);
}

static void random_setup(void)
{
    random_class = class_new(gensym("random"), (t_newmethod)random_new, 0,
    	sizeof(t_random), 0, A_DEFFLOAT, 0);
    class_addbang(random_class, random_bang);
}


/* -------------------------- loadbang ------------------------------ */
static t_class *loadbang_class;

typedef struct _loadbang
{
    t_object x_obj;
} t_loadbang;

static void *loadbang_new()
{
    t_loadbang *x = (t_loadbang *)pd_new(loadbang_class);
    outlet_new(&x->x_obj, &s_bang);
    return (x);
}

static void loadbang_loadbang(t_loadbang *x)
{
    outlet_bang(x->x_obj.ob_outlet);
}

static void loadbang_setup(void)
{
    loadbang_class = class_new(gensym("loadbang"), loadbang_new, 0,
    	sizeof(t_loadbang), 0, 0);
    class_addmethod(loadbang_class, loadbang_loadbang, gensym("loadbang"), 0);
}

/* ---------------serial ports (NT only -- hack) ------------------------- */
#define MAXSERIAL 100

static t_class *serial_class;

typedef struct _serial
{
    t_object x_obj;
    int x_portno;
    int x_open;
} t_serial;

static void serial_float(t_serial *x, t_float f)
{
    int n = f;
    char message[MAXSERIAL * 4 + 100];
    if (!x->x_open)
    {
    	sys_vgui("com%d_open\n", x->x_portno);
    	x->x_open = 1;
    }
    sprintf(message, "com%d_send \"\\%3.3o\"\n", x->x_portno, n);
    sys_gui(message);
}

static void *serial_new(t_floatarg fportno)
{
    int portno = fportno;
    t_serial *x = (t_serial *)pd_new(serial_class);
    if (!portno) portno = 1;
    x->x_portno = portno;
    x->x_open = 0;
    return (x);
}

static void serial_setup(void)
{
    serial_class = class_new(gensym("serial"), (t_newmethod)serial_new, 0,
    	sizeof(t_serial), 0, A_DEFFLOAT, 0);
    class_addfloat(serial_class, serial_float);
}

void x_misc_setup(void)
{
    random_setup();
    loadbang_setup();
    serial_setup();
}
