/*************************************************************/
/* sequncer.c: midi sequencer                                */
/*            V 1.00 (juli 97)             by winfried ritsch */
/*************************************************************/
#define debug 0

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
 
#include "times.h"
#include "mididefs.h"
#include "midi_io.h"
#include "midifile.h"
#include "schedule.h"

MD_mfplay *midi_schedule(MIDIPort *mp,MIDIFile *mf)
{

  MD_mfplay *mfp;
  MD_trkplay *mtp;
  MTrk *trk;
  

  if(mf->MThd == NULL)
	 return(NULL);

  if((mfp = (MD_mfplay *) malloc(sizeof(MD_mfplay))) == NULL)
	 return(NULL);

  mfp->first = mfp->ptrack = NULL;
  mfp->ntrks = mf->MThd->ntrks;

  trk = mf->MThd->starttrack;

  while(trk != NULL){

	 if((mtp = (MD_trkplay *) malloc(sizeof(MD_trkplay))) == NULL){
		return(NULL);
	 }

	 if(mfp->first == NULL)
		mfp->first = mtp;

	 mtp->first = mtp->akt = NULL;
	 mtp->track = trk;

	 mtp->ticks = 0l;

	 trk = trk->next;
  };

  return mfp;
}


#ifdef MAIN
/* --- Variables ------ */

int main()
{
  long i,j;
  long count;
  MIDIPort *mp;

  t_systime starttime;
  
  printf("Testing midiout \n");

  if(midi_open() <= 0){
	 fprintf(stderr,"Cannot open midi\n");
	 exit(1);
  }
  mp = midi_getfirstport();

  sys_gettime(&starttime);

  j=i=0;
  while(j<10){

	 if(sys_secsince(&starttime) > 0.5){

		if(i==0){
		  i=1;
		  midi_out(mp,MD_NOTE_ON);
		  midi_out(mp,0x40);
		  midi_out(mp,0x41);
		}
		else{
		  i=0;
		  midi_out(mp,MD_NOTE_ON);
		  midi_out(mp,0x40);
		  midi_out(mp,0x00);
		}

		printf("%ld:%ld out\n",j++,i);

		while(midi_instat(mp))
		  printf("got midi %x\n",midi_in(mp));

		sys_gettime(&starttime);
		
	 }
  }
  midi_out(mp,MD_NOTE_ON);
  midi_out(mp,0x40);
  midi_out(mp,0x00);
  return 0;
}

#endif /* MAIN */
