// id.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
// The Id class stores the 4-char representation of many file header magic
// numbers (such as those used in AIF-C files).

#ifndef ID_H
#define ID_H

#include <string.h>

class Id {
	enum Len { IdLen = 4 };
protected:
	int lmin(int x, int y) const { return (x < y) ? x : y; }
	void copy(const char* string) {
		strncpy(chars, string, lmin(strlen(string), IdLen));
	}
public:
	Id(const char* string="    ") { copy(string); }
	const Id& operator = (const char* string) {
		copy(string); return *this;
	}
	int operator == (const char* string) const {
		return (strncmp(chars, string, lmin(strlen(string), IdLen)) == 0);
	}
	operator const char* () const { return chars; }
private:
	char chars[IdLen];
};

#endif
