/*==============================================================================

  $Id: drv_stdout.c,v 1.7 1998/09/20 21:45:17 miod Exp $

  Output data to stdout

==============================================================================*/

/*
	This library is free software; you can redistribute it and/or modify
	it under the terms of the GNU Library General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
 
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Library General Public License for more details.
 
	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <unistd.h>
#include <stdlib.h>

#include <mikmod.h>

#define BUFFERSIZE 0x10000L
static	char* audiobuffer=NULL;

BOOL stdout_IsThere(void)
{
	return 1;
}

BOOL stdout_Init(void)
{
	if(!(audiobuffer=(char*)_mm_malloc(BUFFERSIZE)))
		return 1;
	return VC_Init();
}

void stdout_Exit(void)
{
	VC_Exit();
	if (audiobuffer) {
		free(audiobuffer);
		audiobuffer=NULL;
	}
}

void stdout_Update(void)
{
	write(1,audiobuffer,VC_WriteBytes((SBYTE*)audiobuffer,BUFFERSIZE));
}

BOOL stdout_Reset(void)
{
	VC_Exit();
	return VC_Init();
}

MDRIVER drv_stdout={
	NULL,
	"stdout",
	"Standard output driver v1.1",
	0,255,
	stdout_IsThere,
	VC_SampleLoad,
	VC_SampleUnload,
	VC_SampleSpace,
	VC_SampleLength,
	stdout_Init,
	stdout_Exit,
	stdout_Reset,
	VC_SetNumVoices,
	VC_PlayStart,
	VC_PlayStop,
	stdout_Update,
	VC_VoiceSetVolume,
	VC_VoiceSetFrequency,
	VC_VoiceSetPanning,
	VC_VoicePlay,
	VC_VoiceStop,
	VC_VoiceStopped,
	VC_VoiceReleaseSustain,
	VC_VoiceGetPosition,
	VC_VoiceRealVolume
};
