#!/usr/local/bin/perl
#
# How to use:
# 1. Make sure the path on the first line of this file points to perl5.
# 2. Make sure Tk and TkUtils.pm can be found.
#    If Tk is not installed on your system uncomment all of the "unshift" lines
#    and the "use" line below and make sure the path is correct.
#    TkUtils.pm is located in lib/perl5 of the PilotManager distribution.
#    You can copy the file to your /usr/local/lib/perl5 dir or uncomment the
#    first "unshift" line below and make sure the path is correct.
BEGIN
{
# use Config;
# unshift(@INC,"/home/pilotmgr,v1.101/lib/perl5");
# unshift(@INC,"/home/pilotmgr,v1.101/lib/perl5/$Config::Config{archname}");
# unshift(@INC,"/home/pilotmgr,v1.101/lib/perl5/$Config::Config{archname}/$]");
}

use Tk;
use TkUtils;

# main window widgets and variables:
my ($gWm, $gFoodListbox, $gTimeCB, @gExtraCB, $gAboutDlg);
my ($gChkTime, $gTimeSelTxt, @gExtraSel, @gUnk, @gUnkLoc);
@gExtraSel = (1,1,1,1);
@gUnkLoc = ([-x => 4, -y => 6], [-x => 4, -y => 6],
	    [-x => 4, -y => 30], [-x => 4, -y => 30]);

# food window widgets and variables:
my ($gFoodDlg, $gFoodNameWgt, $gFoodInfo, $gWeekendWgt, $gWeekdayWgt,
    @gExtraValCB, @gFunk, $gFoodOkBtn);
my ($gFoodName, $gHrsWeekend, $gHrsWeekday, @gExtraVal, @gFunkLoc,
    $gEditMode, $gEditRec, $gFoodVal, $gLocVal);
@gFunkLoc = ([-x => 4, -y => 6], [-x => 4, -y => 30],
	     [-x => 4, -y => 54], [-x => 4, -y => 78]);
$gEditMode = 0;

# select window widgets and variables
my ($gSelectDlg, @gSelectCB, $gSelectDone, @gSelBtn);
my (@gSelection);

# prefs window widgets and variables
my ($gPrefsDlg, @gPrefsRB, @gPrefsFld);
my ($gPrefsCho, $gPrefsLast, @gPrefsVal);

my ($FOODFILE) = ("$ENV{HOME}/.foodDb");
my ($gFoodlist, $gFoodDb, @gFoodIndex);
my (@foodTypes) = ('Mexican', 'Italian', 'BBQ/Burgers', 'Breakfast', 'French',
		   'Greek', '', 'Dessert', 'Chinese', 'Indian', 'Sandwich',
		   'Sushi', 'Thai', '', 'Fast Food', 'Other');
my (@locations) = ('home town', '', '', '', '', '', '', 'other States',
		   'nearby town', '', '', '', '', '', 'other thisstate',
		   'International');
my (@extras) = ('Take Out', 'Reservations', 'My Favorites', 'Free Refills');

## Current selection:
my ($gFoodSel, $gLocSel, $gExtraSel, $gRatingSel, $gTimeSel) =
   (0xFFFF, 0xFFFF, 0, 0, -1);

sub createGui
{
    my ($frame, $obj);

    $gWm = MainWindow->new;
    $gWm->title("Food");

    $frame = $gWm->Frame(-relief => 'raised', -borderwidth => 2);

    $obj = TkUtils::Menu($frame, "Record", \&menuChoice,
			 "New", [], "Edit", [], "Delete", []);
    $obj->configure(-relief => 'flat');
    $obj->pack(-side => 'left');

    $obj = TkUtils::Menu($frame, "Options", \&menuChoice,
			 "Preferences", [], "About", []);
    $obj->configure(-relief => 'flat');
    $obj->pack(-side => 'left');

    $frame->pack(-side => 'top', -fill => 'x');

    $frame = $gWm->Frame;

    $gFoodListbox = $frame->Listbox(-selectmode => "browse");
    $gFoodListbox->bind('<Double-Button-1>', sub { &doInfo; });

    $obj = $frame->Scrollbar(-command => [$gFoodListbox => "yview"]);
    $obj->pack(-side => 'right', -fill => 'y');

    $gFoodListbox->configure(-height => 12, -yscrollcommand => [$obj => 'set']);
    $gFoodListbox->pack(-side => 'right', -fill => 'both', -expand => 1);

    $obj = $frame->Button(-text => 'Show All', -command => sub { &showAll; });
    $obj->pack(-side => 'top', -fill => 'x');

    $obj = $frame->Button(-text => 'Foods...', -command =>
			  sub { &doSelection(\$gFoodSel, \@foodTypes); });
    $obj->pack(-side => 'top', -fill => 'x');

    $obj = $frame->Button(-text => 'Where...', -command =>
			  sub { &doSelection(\$gLocSel, \@locations); });
    $obj->pack(-side => 'top', -fill => 'x');

    $obj = TkUtils::Button($frame, 'Random', \&doRandom);
    $obj->pack(-side => 'top', -fill => 'x');

    $obj = TkUtils::Button($frame, 'Info', \&doInfo);
    $obj->pack(-side => 'top', -fill => 'x');

    $gTimeCB = $frame->Checkbutton(-text => 'Open', -variable => \$gChkTime,
				   -command => sub { &doOpen; });
    $gTimeCB->pack(-side => 'top', -anchor => 'nw');

    $obj = $frame->Entry(-textvariable => \$gTimeSelTxt, -width => 8);
    $obj->pack(-side => 'top', -fill => 'x', -expand => 1, -anchor => 'n');

    $frame->pack(-side => 'top', -fill => 'both', -expand => 1);

    $frame = $gWm->Frame;

    $gExtraCB[0] = $frame->Checkbutton(-text => 'ex1', -onvalue => 2,
				       -variable => \$gExtraSel[0],
				       -command => sub { &doExtra(0); });
    $gExtraCB[0]->pack(-side => 'top', -anchor => 'w');

    $gExtraCB[2] = $frame->Checkbutton(-text => 'ex3', -onvalue => 2,
				       -variable => \$gExtraSel[2],
				       -command => sub { &doExtra(2); });
    $gExtraCB[2]->pack(-side => 'top', -anchor => 'w');

    $gUnk[0] = $frame->Canvas(-width => 8, -height => 9);
    $gUnk[0]->createText(2, 0, -anchor => 'nw', -text => '?');
    $gUnk[0]->place(-x => 4, -y => 6);

    $gUnk[2] = $frame->Canvas(-width => 8, -height => 9);
    $gUnk[2]->createText(2, 0, -anchor => 'nw', -text => '?');
    $gUnk[2]->place(-x => 4, -y => 30);

    $frame->pack(-side => 'left', -fill => 'both', -expand => 1);

    $frame = $gWm->Frame;

    $gExtraCB[1] = $frame->Checkbutton(-text => 'ex2', -onvalue => 2,
				       -variable => \$gExtraSel[1],
				       -command => sub { &doExtra(1); });
    $gExtraCB[1]->pack(-side => 'top', -anchor => 'w');

    $gExtraCB[3] = $frame->Checkbutton(-text => 'ex4', -onvalue => 2,
				       -variable => \$gExtraSel[3],
				       -command => sub { &doExtra(3); });
    $gExtraCB[3]->pack(-side => 'top', -anchor => 'w');

    $gUnk[1] = $frame->Canvas(-width => 8, -height => 9);
    $gUnk[1]->createText(2, 0, -anchor => 'nw', -text => '?');
    $gUnk[1]->place(-x => 4, -y => 6);

    $gUnk[3] = $frame->Canvas(-width => 8, -height => 9);
    $gUnk[3]->createText(2, 0, -anchor => 'nw', -text => '?');
    $gUnk[3]->place(-x => 4, -y => 30);

    $frame->pack(-side => 'left', -fill => 'both', -expand => 1);

    # $obj = $gWm->Photo('myicon', -file => 'path');
    # $gWm->Icon(-image => 'myicon');
    # $gWm->iconname('text');

    &createFoodDlg;
    &createSelectDlg;
    $gWm->bind('<Destroy>', sub { $gSelectDone=1; &writeFile; });

    foreach $obj (0..3)
    {
	$gExtraCB[$obj]->bind('<Map>', sub {
		$gUnkLoc[$obj] = [-x => $gExtraCB[$obj]->x+5,
				  -y => $gExtraCB[$obj]->y+7];
		$gUnk[$obj]->place(@{$gUnkLoc[$obj]});
		$gExtraCB[$obj]->bind('<Map>', ''); });
	$gExtraValCB[$obj]->bind('<Map>', sub {
		$gFunkLoc[$obj] = [-x => $gExtraValCB[$obj]->x+5,
				   -y => $gExtraValCB[$obj]->y+7];
		$gFunk[$obj]->place(@{$gFunkLoc[$obj]})
		    if ($gFunk[$obj]->placeInfo);
		$gExtraValCB[$obj]->bind('<Map>', ''); });
    }
}

sub createFoodDlg
{
    my ($frame, $subfr, $obj);

    $gFoodDlg = $gWm->Toplevel(-title => 'Food Place');
    $gFoodDlg->transient($gWm);

    $frame = $gFoodDlg->Frame(-relief => 'ridge', -bd => 2);
    $subfr = $frame->Frame;

    $obj = $subfr->Label(-text => 'Name');
    $obj->pack(-side => 'left', -anchor => 'e');

    $gFoodNameWgt = $subfr->Entry(-textvariable => \$gFoodName, -width => 30);
    $gFoodNameWgt->pack(-anchor => 'w', -fill => 'x', -expand => 1);

    $subfr->pack(-side => 'top', -anchor => 'e');
    $subfr = $frame->Frame;

    $obj = $subfr->Label(-text => 'Info');
    $obj->pack(-side => 'left', -anchor => 'ne');

    $gFoodInfo = $subfr->Text(-wrap => 'word', -width => 30, -height => 4);
    $gFoodInfo->pack(-anchor => 'w', -fill => 'both', -expand => 1);

    $subfr->pack(-side => 'top', -anchor => 'e');
    $subfr = $frame->Frame;

    $obj = $subfr->Label(-text => 'Open \'Til: Su-Th ');
    $obj->pack(-side => 'left', -anchor => 'e');

    $gWeekdayWgt = $subfr->Entry(-textvariable => \$gHrsWeekday, -width => 5);
    $gWeekdayWgt->pack(-side => 'left', -anchor => 'w');

    $obj = $subfr->Label(-text => 'Fr-Sa ');
    $obj->pack(-side => 'left', -anchor => 'e');

    $gWeekendWgt = $subfr->Entry(-textvariable => \$gHrsWeekend, -width => 5);
    $gWeekendWgt->pack(-anchor => 'w');

    $subfr->pack(-side => 'top');
    $subfr = $frame->Frame;

    $obj = $subfr->Button(-text => 'Dismiss',
			  -command => ['withdraw', $gFoodDlg]);
    $obj->pack(-side => 'right');

    $gFoodOkBtn = $subfr->Button(-text => 'Ok',
				 -command => sub { &saveEdits; });
    $gFoodOkBtn->pack;

    $subfr->pack(-side => 'bottom');
    $subfr = $frame->Frame;

    $gExtraValCB[0] = $subfr->Checkbutton(-text => 'ex1', -onvalue => 2,
					  -variable => \$gExtraVal[0],
					  -command => sub { &chExtra(0); },
					  -disabledforeground => 'black');
    $gExtraValCB[0]->pack(-side => 'top', -anchor => 'w');

    $gExtraValCB[1] = $subfr->Checkbutton(-text => 'ex2', -onvalue => 2,
					  -variable => \$gExtraVal[1],
					  -command => sub { &chExtra(1); },
					  -disabledforeground => 'black');
    $gExtraValCB[1]->pack(-side => 'top', -anchor => 'w');

    $gExtraValCB[2] = $subfr->Checkbutton(-text => 'ex3', -onvalue => 2,
					  -variable => \$gExtraVal[2],
					  -command => sub { &chExtra(2); },
					  -disabledforeground => 'black');
    $gExtraValCB[2]->pack(-side => 'top', -anchor => 'w');

    $gExtraValCB[3] = $subfr->Checkbutton(-text => 'ex4', -onvalue => 2,
					  -variable => \$gExtraVal[3],
					  -command => sub { &chExtra(3); },
					  -disabledforeground => 'black');
    $gExtraValCB[3]->pack(-side => 'top', -anchor => 'w');

    $gFunk[0] = $subfr->Canvas(-width => 8, -height => 9);
    $gFunk[0]->createText(2, 0, -anchor => 'nw', -text => '?');
    $gFunk[0]->place(-x => 4, -y => 6);

    $gFunk[1] = $subfr->Canvas(-width => 8, -height => 9);
    $gFunk[1]->createText(2, 0, -anchor => 'nw', -text => '?');
    $gFunk[1]->place(-x => 4, -y => 30);

    $gFunk[2] = $subfr->Canvas(-width => 8, -height => 9);
    $gFunk[2]->createText(2, 0, -anchor => 'nw', -text => '?');
    $gFunk[2]->place(-x => 4, -y => 54);

    $gFunk[3] = $subfr->Canvas(-width => 8, -height => 9);
    $gFunk[3]->createText(2, 0, -anchor => 'nw', -text => '?');
    $gFunk[3]->place(-x => 4, -y => 78);

    $subfr->pack(-side => 'right');
    $subfr = $frame->Frame;

    $obj = $frame->Button(-text => 'Food Type...', -command =>
	sub { &doSelection(\$gFoodVal, \@foodTypes, $gEditMode); });
    $obj->pack;

    $obj = $frame->Button(-text => 'Location...', -command =>
	sub { &doSelection(\$gLocVal, \@locations, $gEditMode); });
    $obj->pack;

    $subfr->pack;
    $frame->pack;
    $gFoodDlg->withdraw;
}

sub createSelectDlg
{
    my ($frame, $subfr, $obj, $i);

    $gSelectDlg = $gWm->Toplevel(-title => 'Food Select');
    $gSelectDlg->transient($gWm);

    $frame = $gSelectDlg->Frame(-relief => 'ridge', -bd => 2);

    $obj = $frame->Button(-text => 'Ok',
			  -command => sub { $gSelectDone = 1; });
    $obj->pack(-side => 'bottom');

    $subfr = $frame->Frame;

    $gSelBtn[0] = $subfr->Button(-text => 'All', -command =>
	sub { my $i; foreach $i (0..15) { $gSelectCB[$i]->select }});
    $gSelBtn[0]->pack(-side => 'left');

    $gSelBtn[1] = $subfr->Button(-text => 'None', -command =>
	sub { my $i; foreach $i (0..15) { $gSelectCB[$i]->deselect }});
    $gSelBtn[1]->pack(-side => 'left');

    $gSelBtn[2] = $subfr->Button(-text => 'Random', -command =>
	sub { my ($v,$i) = (256*int(rand(256))+int(rand(256)));
	      foreach $i (0..15) {
		if ($v & (1<<$i)) {
		    $gSelectCB[$i]->select;
		} else {
		    $gSelectCB[$i]->deselect;
		}
	      }
	    });
    $gSelBtn[2]->pack(-side => 'left');

    $subfr->pack(-side => 'bottom', -anchor => 'c');

    $subfr = $frame->Frame;
    foreach $i (0..15)
    {
	if ($i == 8)
	{
	    $subfr->pack(-side => 'left', -fill => 'both', -expand => 1);
	    $subfr = $frame->Frame;
	}

	$gSelectCB[$i] = $subfr->Checkbutton(-text => "sel$i",
					     -variable => \$gSelection[$i],
					     -disabledforeground => 'black');
	$gSelectCB[$i]->pack(-side => 'top', -anchor => 'w');
    }
    $subfr->pack(-fill => 'both', -expand => 1);
    $frame->pack;
    $gSelectDlg->withdraw;
}

sub createPrefsDlg
{
    my ($frame, $subfr, $obj, $i);

    $gPrefsDlg = $gWm->Toplevel(-title => 'Food Prefs');
    $gPrefsDlg->transient($gWm);

    $frame = $gPrefsDlg->Frame(-relief => 'ridge', -bd => 2);

    $obj = $frame->Button(-text => 'Ok',
			  -command => sub { $gPrefsDone = 1; });
    $obj->pack(-side => 'bottom');

    $subfr = $frame->Frame;

    $gPrefsRB[0] = $subfr->Radiobutton(-text => 'Food Types', -value => 0,
				       -variable => \$gPrefsCho,
				       -command => sub { &switchPrefs; });
    $gPrefsRB[0]->pack(-side => 'left');

    $gPrefsRB[1] = $subfr->Radiobutton(-text => 'Locations', -value => 1,
				       -variable => \$gPrefsCho,
				       -command => sub { &switchPrefs; });
    $gPrefsRB[1]->pack(-side => 'left');

    $gPrefsRB[2] = $subfr->Radiobutton(-text => 'Extras', -value => 2,
				       -variable => \$gPrefsCho,
				       -command => sub { &switchPrefs; });
    $gPrefsRB[2]->pack(-side => 'left');

    $subfr->pack(-side => 'top');
    $subfr = $frame->Frame;

    foreach $i (0..15)
    {
	if ($i == 8)
	{
	    $subfr->pack(-side => 'left', -fill => 'both', -expand => 1);
	    $subfr = $frame->Frame;
	}

	$gPrefsFld[$i] = $subfr->Entry(-textvariable => \$gPrefsVal[$i],
				       -width => 30);
	$gPrefsFld[$i]->pack(-side => 'top', -anchor => 'w');
    }
    $subfr->pack(-side => 'left', -fill => 'both', -expand => 1);
    $frame->pack;
    $gPrefsDlg->withdraw;
}

sub doPrefs
{
    my ($i);
    &createPrefsDlg unless (defined $gPrefsDlg);

    foreach $i (0..15)
    {
	$gPrefsVal[$i] = $foodTypes[$i];
    }

    $gPrefsCho = $gPrefsLast = $gPrefsDone = 0;
    $gPrefsDlg->Popup(-popanchor => 'c', -overanchor => 'c', -popover => $gWm);
    $gPrefsDlg->grab;
    $gPrefsDlg->waitVariable(\$gPrefsDone);
    $gPrefsDlg->grabRelease;
    $gPrefsDlg->withdraw;

    &switchPrefs;

    for ($i=0; $i<4; $i++)
    {
	$gExtraCB[$i]->configure(-text => $extras[$i]);
	$gExtraValCB[$i]->configure(-text => $extras[$i]);
    }
}

sub switchPrefs
{
    my ($i, $max, $listref);

    if    ($gPrefsLast==0) { $max = 15; $listref = \@foodTypes; }
    elsif ($gPrefsLast==1) { $max = 15; $listref = \@locations; }
    elsif ($gPrefsLast==2) { $max = 3;  $listref = \@extras;    }

    foreach $i (0..$max)
    {
	$listref->[$i] = $gPrefsVal[$i];
    }
    foreach $i ($max+1..15)
    {
	$gPrefsFld[$i]->configure(-state => 'normal');
    }

    return if ($gPrefsLast == $gPrefsCho);

    if    ($gPrefsCho==0) { $max=15; $listref=\@foodTypes; }
    elsif ($gPrefsCho==1) { $max=15; $listref=\@locations; }
    elsif ($gPrefsCho==2) { $max=3;  $listref=\@extras;    }

    foreach $i (0..$max)
    {
	$gPrefsVal[$i] = $listref->[$i];
    }
    foreach $i ($max+1..15)
    {
	$gPrefsVal[$i] = '';
	$gPrefsFld[$i]->configure(-state => 'disabled');
    }

    $gPrefsLast = $gPrefsCho;
}

sub showAll
{
    my ($i);

    $gTimeCB->deselect;
    foreach $i (0..3)
    {
	$gExtraCB[$i]->deselect;
	$gUnk[$i]->place(@{$gUnkLoc[$i]}) unless ($gUnk[$i]->placeInfo);
	$gExtraSel[$i] = 1;
    }

    $gFoodSel = $gLocSel = 0xFFFF;
    $gTimeSel = -1;
    $gExtraSel = $gRatingSel = 0;
    &fillList;
}

sub doRandom
{
    return unless (@gFoodIndex);
    my $sel = int(rand(@gFoodIndex));
    $gFoodListbox->selectionClear(0,'end');
    $gFoodListbox->see($sel);
    $gFoodListbox->selectionSet($sel);
    &doInfo;
}

sub fillInfo
{
    my ($rec, $i) = @_;

    $gFoodName = $rec->{name};

    $gFoodInfo->configure(-state => 'normal');
    $gFoodInfo->delete('0.0', 'end');
    $gFoodInfo->insert('end', $rec->{info});

    $gHrsWeekday = ($rec->{hours_weekday} >= 0) ? $rec->{hours_weekday} : '';
    $gHrsWeekday =~ s/(\d)(\d\d)$/$1:$2/;
    $gHrsWeekend = ($rec->{hours_weekend} >= 0) ? $rec->{hours_weekend} : '';
    $gHrsWeekend =~ s/(\d)(\d\d)$/$1:$2/;

    foreach $i (0..3)
    {
	$gExtraValCB[$i]->deselect;
	if ($rec->{'extraBits'} & (16<<$i))
	{
	    $gFunk[$i]->placeForget;
	    if ($rec->{'extraBits'} & (1<<$i))
	    {
		$gExtraValCB[$i]->select;
		$gExtraVal[$i] = 2;
	    } else {
		$gExtraVal[$i] = 0;
	    }
	} else {
	    $gFunk[$i]->place(@{$gFunkLoc[$i]}) unless ($gFunk[$i]->placeInfo);
	    $gExtraVal[$i] = 1;
	}
    }

    $gFoodVal = $rec->{'foodTypeBits'};
    $gLocVal = $rec->{'locationBits'};
}

sub saveEdits
{
    my ($rec, $i, @sel);

    return unless ($gFoodName);		# must have a name

    if ($gEditMode == 1)
    {
	$rec = $gEditRec;
    }
    elsif ($gEditMode == 2)
    {
	$rec = { 'food_id' => $gFoodDb->{'NEXT_ID'}++ };
	push(@$gFoodlist, $rec);
    }

    $rec->{'name'} = $gFoodName;
    $rec->{'info'} = $gFoodInfo->get('0.0', 'end -1 chars');
    $rec->{'hours_weekday'} = &parseTime($gHrsWeekday);
    $rec->{'hours_weekend'} = &parseTime($gHrsWeekend);

    $rec->{'extraBits'} = 0;
    foreach $i (0..3)
    {
	next if ($gExtraVal[$i] == 1);
	$rec->{'extraBits'} |= 16<<$i;
	$rec->{'extraBits'} |= 1<<$i if ($gExtraVal[$i]);
    }

    $rec->{'foodTypeBits'} = $gFoodVal;
    $rec->{'locationBits'} = $gLocVal;

    $rec->{'rating'} = 0;
    $rec->{'note'} = '';

    $gFoodDlg->withdraw;
    &fillList;
}

sub doInfo
{
    &createFoodDlg unless (defined $gFoodDlg);

    my ($rec, $i, @sel);
    @sel = $gFoodListbox->curselection;
    return unless (@sel);
    $rec = $gFoodlist->[$gFoodIndex[$sel[0]]];

    $gEditMode = 0;
    &fillInfo($rec);

    $gFoodNameWgt->configure(-relief => 'flat', -bd => 0, -state => 'disabled');
    $gFoodInfo->configure(-relief => 'flat', -bd => 0, -state => 'disabled');
    $gWeekdayWgt->configure(-relief => 'flat', -bd => 0, -state => 'disabled');
    $gWeekendWgt->configure(-relief => 'flat', -bd => 0, -state => 'disabled');
    foreach $i (0..3)
    {
	$gExtraValCB[$i]->configure(-state => 'disabled');
    }

    $gFoodOkBtn->packForget;
    $gFoodDlg->Popup(-popanchor => 'c', -overanchor => 'c', -popover => $gWm)
	unless ($gFoodDlg->state eq 'normal');
    $gFoodDlg->focus;
}

sub doEdit
{
    $createFoodDlg unless (defined $gFoodDlg);

    my ($i, @sel);
    @sel = $gFoodListbox->curselection;
    return unless (@sel);
    $gEditRec = $gFoodlist->[$gFoodIndex[$sel[0]]];

    $gEditMode = 1;
    &fillInfo($gEditRec);

    $gFoodNameWgt->configure(-relief => 'sunken', -bd => 2, -state => 'normal');
    $gFoodInfo->configure(-relief => 'sunken', -bd => 2, -state => 'normal');
    $gWeekdayWgt->configure(-relief => 'sunken', -bd => 1, -state => 'normal');
    $gWeekendWgt->configure(-relief => 'sunken', -bd => 1, -state => 'normal');
    foreach $i (0..3)
    {
	$gExtraValCB[$i]->configure(-state => 'normal');
    }

    $gFoodOkBtn->pack;
    $gFoodDlg->Popup(-popanchor => 'c', -overanchor => 'c', -popover => $gWm)
	unless ($gFoodDlg->state eq 'normal');
    $gFoodDlg->focus;
}

sub doNew
{
    $createFoodDlg unless (defined $gFoodDlg);

    $gEditMode = 2;

    $gFoodName = '';
    $gFoodInfo->configure(-state => 'normal');
    $gFoodInfo->delete('0.0', 'end');
    $gHrsWeekday = $gHrsWeekend = '';
    foreach $i (0..3)
    {
	$gExtraValCB[$i]->deselect;
	$gFunk[$i]->place(@{$gFunkLoc[$i]}) unless ($gFunk[$i]->placeInfo);
	$gExtraVal[$i] = 1;
	$gExtraValCB[$i]->configure(-state => 'normal');
    }
    $gFoodVal = $gLocVal = '';

    $gFoodNameWgt->configure(-relief => 'sunken', -bd => 2, -state => 'normal');
    $gFoodInfo->configure(-relief => 'sunken', -bd => 2, -state => 'normal');
    $gWeekdayWgt->configure(-relief => 'sunken', -bd => 1, -state => 'normal');
    $gWeekendWgt->configure(-relief => 'sunken', -bd => 1, -state => 'normal');

    $gFoodOkBtn->pack;
    $gFoodDlg->Popup(-popanchor => 'c', -overanchor => 'c', -popover => $gWm)
	unless ($gFoodDlg->state eq 'normal');
    $gFoodNameWgt->focus;
}

sub doSelection
{
    my ($selref, $listref, $state) = @_;
    &createSelectDlg unless (defined $gSelectDlg);
    $state = (!defined $state || $state) ? 'normal' : 'disabled';

    my ($i);
    foreach $i (0..15)
    {
	$gSelectCB[$i]->configure(-text => $listref->[$i], -state => $state);
	$gSelection[$i] = ($$selref>>$i) & 1;
    }
    foreach $i (0..2)
    {
	$gSelBtn[$i]->configure(-state => $state);
    }

    $gSelectDone = 0;
    $gSelectDlg->Popup(-popanchor =>'c', -overanchor =>'c', -popover => $gWm);
    $gSelectDlg->grab;
    $gSelectDlg->waitVariable(\$gSelectDone);
    $gSelectDlg->grabRelease;
    $gSelectDlg->withdraw;

    return if ($state eq 'disabled');
    $$selref = 0;
    foreach $i (0..15)
    {
	$$selref |= 1<<$i if ($gSelection[$i]);
    }
    &fillList;
}

sub doExtra
{
    my ($i) = @_;

    if ($gExtraSel[$i] == 2)
    {
	if ($gUnk[$i]->placeInfo)
	{
	    $gUnk[$i]->placeForget;
	} else {
	    $gUnk[$i]->place(@{$gUnkLoc[$i]});
	    $gExtraCB[$i]->deselect;
	    $gExtraSel[$i] = 1;
	}
    }

    # calculate $gExtraSel from @gExtraSel
    $gExtraSel = 0;
    foreach $i (0..3)
    {
	next if ($gExtraSel[$i] == 1);
	$gExtraSel |= 16<<$i;
	$gExtraSel |= 1<<$i if ($gExtraSel[$i]);
    }

    &fillList;
}

sub chExtra
{
    my ($i) = @_;

    if ($gExtraVal[$i] == 2)
    {
	if ($gFunk[$i]->placeInfo)
	{
	    $gFunk[$i]->placeForget;
	} else {
	    $gFunk[$i]->place(@{$gFunkLoc[$i]});
	    $gExtraValCB[$i]->deselect;
	    $gExtraVal[$i] = 1;
	}
    }
}

sub doOpen
{
    unless ($gChkTime)
    {
	$gTimeSel = -1;
    }
    else
    {
	$gTimeSel = &parseTime($gTimeSelTxt);
	$gTimeSel = 0 if ($gTimeSel < 0);
    }
    &fillList;
}

sub parseTime
{
    my ($timestr) = @_;

    return 100 * $1 + $2 if ($timestr =~ /(\d+):(\d\d)/);
    return 100 * $1 if ($timestr =~ /(\d+)/);
    return -1;
}

sub menuChoice
{
    my ($choice) = @_;

    ($choice eq 'Options / Preferences') && &doPrefs;
    ($choice eq 'Options / About') && &showAbout;
    ($choice eq 'Record / New') && &doNew;
    ($choice eq 'Record / Edit') && &doEdit;
    ($choice eq 'Record / Delete') && &doDelete;
}

sub doDelete
{
    my ($sel, $dlg, $btn, @sel);
    @sel = $gFoodListbox->curselection;
    return unless (@sel);
    $sel = $gFoodIndex[$sel[0]];

    $dlg = $gWm->DialogBox(-title => 'Delete Food',
			   -buttons => ['Ok', 'Cancel']);
    $dlg->add('Label', -text => 'Are you sure?')->pack;
    $btn = $dlg->Show;

    if ($btn eq 'Ok')
    {
	splice(@$gFoodlist, $sel, 1);
	#XXX: save change NOW?
	&fillList;
    }
}

sub showAbout
{
    &createAboutDlg unless (defined $gAboutDlg);

    $gAboutDlg->Popup(-popanchor =>'sw', -overanchor =>'ne', -popover => $gWm);
}

sub createAboutDlg
{
    my ($frame, $obj);

    $gAboutDlg = $gWm->Toplevel(-title => 'About Food');
    $gAboutDlg->transient($gWm);

    $frame = $gAboutDlg->Frame(-relief => 'ridge', -bd => 2);

    $obj = $frame->Button(-text => 'Dismiss',
			  -command => ['withdraw', $gAboutDlg]);
    $obj->pack(-side => 'bottom');

    $obj = $frame->Label(
	-text => "FOOD v0.91 BETA\nAlan Harder\nAlan.Harder\@Sun.COM");
    $obj->pack;

    $frame->pack;
    $gAboutDlg->withdraw;
}

sub readFile
{
    my ($db, $reclist, $rec) = ({'NEXT_ID'=>0}, []);
    open(FD, "<$FOODFILE") || return($reclist, $db);

    for ($i=0; $i<16; $i++)
    {
	chop($foodTypes[$i] = <FD>);
    }
    for ($i=0; $i<16; $i++)
    {
	chop($locations[$i] = <FD>);
    }
    for ($i=0; $i<4; $i++)
    {
	chop($extras[$i] = <FD>);
    }
    chop($db->{NEXT_ID} = <FD>);

    while (!eof(FD))
    {
	$rec = {};
	chop($rec->{food_id} = <FD>);
	$rec->{name} = &readString(FD);
	$rec->{info} = &readString(FD);
	($rec->{foodTypeBits}, $rec->{locationBits},
	 $rec->{hours_weekday}, $rec->{hours_weekend},
	 $rec->{extraBits}, $rec->{rating}) =
	    split(',', (chop($_ = <FD>),$_)[1]);
	$rec->{note} = &readString(FD);
	$_ = <FD>;

	push(@$reclist, $rec);
#	$db->{$rec->{food_id}} = $#$reclist;
    }
    close(FD);

    return ($reclist, $db);
}

sub writeFile
{
    open(FD, ">$FOODFILE") || return -1;

    for ($i=0; $i<16; $i++)
    {
	print FD $foodTypes[$i], "\n";
    }
    for ($i=0; $i<16; $i++)
    {
	print FD $locations[$i], "\n";
    }
    for ($i=0; $i<4; $i++)
    {
	print FD $extras[$i], "\n";
    }
    print FD $gFoodDb->{'NEXT_ID'}, "\n";

    foreach $rec (@$gFoodlist)
    {
	print FD $rec->{'food_id'}, "\n",
		 length($rec->{'name'}), "\n", $rec->{'name'}, "\n",
		 length($rec->{'info'}), "\n", $rec->{'info'}, "\n",
		 $rec->{'foodTypeBits'}, ',',
		 $rec->{'locationBits'}, ',',
		 $rec->{'hours_weekday'}, ',',
		 $rec->{'hours_weekend'}, ',',
		 $rec->{'extraBits'}, ',',
		 $rec->{'rating'}, "\n",
		 length($rec->{'note'}), "\n", $rec->{'note'}, "\n\n";
    }
    close(FD);
    return 0;
}

sub readString
{
    my ($fd) = @_;
    my ($str, $len) = ("");

    $len = <$fd>;
    while ($len > 0 && !eof($fd))
    {
	$_ = <$fd>;
	$len -= length($_);
	$str .= $_;
    }
    if ($len < 0)
    {
	chop($str);
    } else {
	$_ = <$fd>;
    }

    return($str);
}

sub fillList
{
    my ($i, $rec, $exKnwn, $exVals);
    my ($useExtras, $extraBits) = ($gExtraSel >> 4, $gExtraSel & 0xF);

    @gFoodIndex = ();
    $gFoodListbox->delete(0, 'end');

    foreach $i ($[..$#$gFoodlist)
    {
	$rec = $gFoodlist->[$i];
	$exKnwn = $rec->{'extraBits'} >> 4;
	$exVals = $rec->{'extraBits'} & 0xF;
	if (($rec->{'foodTypeBits'} & $gFoodSel || $gFoodSel == 0xFFFF) &&
	    ($rec->{'locationBits'} & $gLocSel || $gLocSel == 0xFFFF)   &&
	    ($gTimeSel < 0 ||
		(!$isWeekend && $rec->{'hours_weekday'} >= $gTimeSel) ||
		($isWeekend && $rec->{'hours_weekend'} >= $gTimeSel))   &&
	    !( (($useExtras ^ $exKnwn) & $useExtras) ||
		($useExtras & $exKnwn & ($extraBits ^ $exVals)) ) &&
	    (1)) #XXX:saving spot for searching on rating
	{
	    push(@gFoodIndex, $i);
	    $gFoodListbox->insert('end', $rec->{'name'});
	}
    }
}

sub doAlarm
{
    my ($t) = ((stat($FOODFILE))[9]);
    if ($t > $gModTime)
    {
	# XXX: reload database!
print "need to reload database!\n";
	$gModTime = $t;
    }

    $SIG{'ALRM'} = \&doAlarm;
    alarm(5);
}

srand(time|$$);
&createGui;
($gFoodlist, $gFoodDb) = &readFile;

for ($i=0; $i<4; $i++)
{
    $gExtraCB[$i]->configure(-text => $extras[$i]);
    $gExtraValCB[$i]->configure(-text => $extras[$i]);
}

&fillList;

$SIG{'INT'} = $SIG{'QUIT'} = $SIG{'KILL'} =
    sub { $gSelectDone=1; &writeFile; exit };

$gModTime = (stat($FOODFILE))[9];
$SIG{'ALRM'} = \&doAlarm;
alarm(5);

Tk::MainLoop;

