package SyncFood;

use PilotSync;

use Tk;
#use TkUtils;
#use Data::Dumper;
#use strict;

my ($gConfigDlg);
my ($VERSION) = ('0.91 BETA');
my ($FoodFields) = (['name', 'info', 'note',
		     'foodTypeBits', 'locationBits',
		     'hours_weekday', 'hours_weekend',
		     'extraBits', 'rating']);

sub conduitInit
{
}

sub conduitQuit
{
}

sub conduitInfo
{
    return { 'database' =>
		{
		    'name' => 'FoodDB',
		    'creator' => 'FooD',
		    'type' => 'Data',
		    'flags' => 0,
		    'version' => 0,
		},
	     'version' => $VERSION,
	     'author' => 'Alan Harder',
	     'email' => 'Alan.Harder@Sun.COM' };
}

sub conduitConfigure
{
    my ($this, $wm) = @_;

    &createConfigDlg($wm) unless (defined $gConfigDlg);

    $gConfigDlg->Popup(-popanchor => 'c', -overanchor => 'c',
		       -popover => $wm);
}

sub createConfigDlg
{
    my ($wm) = @_;

    $gConfigDlg = $wm->Toplevel(-title => 'SyncFood');
    $gConfigDlg->transient($wm);

    $gConfigDlg->Label(-text => "SyncFood v$VERSION\nAlan Harder\nAlan.Harder\@Sun.COM\nhttp://www.moshpit.org/pilot")->pack(-side => 'top');

    $gConfigDlg->Button(-text => 'Dismiss', -command => ['withdraw', $gConfigDlg])->pack;

    PilotMgr::setColors($gConfigDlg);
}

sub conduitSync
{
    my ($this, $dlp, $info) = @_;

    PilotSync::doSync(	$dlp,
			&conduitInfo->{'database'},
			$FoodFields,
			['foodTypes', 'locations', 'extraBools'],
			'food_id',
			"$ENV{HOME}/.pilotmgr/SyncFood/food.db",
			"$ENV{HOME}/.foodDb",
			sub{ return $_[0]->{'name'}; },
			\&readFile,
			\&writeFile,
			\&newFoodId,
			\&translateFood,
			\&translateAppInfo);

}

sub translateFood
{
    my ($rec, $dir) = @_;
    my ($txt, $val);

    unless ($dir)
    {
	# raw -> expanded
	return if ($rec->{'deleted'});
	$txt = $rec->{'raw'};

	$val = substr($txt, 0, 2);
	$rec->{'foodTypeBits'} = 256 * ord($val) + ord(substr($val, 1, 1));
	$val = substr($txt, 2, 2);
	$rec->{'locationBits'} = 256 * ord($val) + ord(substr($val, 1, 1));
	$val = substr($txt, 4, 2);
	$val = 256 * ord($val) + ord(substr($val, 1, 1));
	$val -= 65536 if ($val > 32767);
	$rec->{'hours_weekday'} = $val;
	$val = substr($txt, 6, 2);
	$val = 256 * ord($val) + ord(substr($val, 1, 1));
	$val -= 65536 if ($val > 32767);
	$rec->{'hours_weekend'} = $val;
	$rec->{'extraBits'} = ord(substr($txt, 8, 1));
	$rec->{'rating'} = ord(substr($txt, 9, 1));

	$txt = substr($txt, 10);
	$val = index($txt, "\000");
	$rec->{'name'} = substr($txt, 0, $val);
	$txt = substr($txt, $val+1);
	$val = index($txt, "\000");
	$rec->{'info'} = substr($txt, 0, $val);
	$txt = substr($txt, $val+1);
	$rec->{'note'} = substr($txt, 0, index($txt, "\000"));
    }
    else
    {
	# expanded -> raw
	$rec->{'raw'} = '';
	$val = $rec->{'foodTypeBits'};
	$rec->{'raw'} .= chr($val/256) . chr($val%256);
	$val = $rec->{'locationBits'};
	$rec->{'raw'} .= chr($val/256) . chr($val%256);
	$val = $rec->{'hours_weekday'};
	$val += 65536 if ($val < 0);
	$rec->{'raw'} .= chr($val/256) . chr($val%256);
	$val = $rec->{'hours_weekend'};
	$val += 65536 if ($val < 0);
	$rec->{'raw'} .= chr($val/256) . chr($val%256);

	$rec->{'raw'} .= chr($rec->{'extraBits'}) .
			 chr($rec->{'rating'}) .
			 $rec->{'name'} . "\000" .
			 $rec->{'info'} . "\000" .
			 $rec->{'note'} . "\000";
    }
}

sub translateAppInfo
{
    my ($appinfo, $dir) = @_;
    my ($txt, $i, $val, $idx) = ($appinfo->{'raw'});

    unless ($dir)
    {
	# raw -> expanded
	$appinfo->{'foodTypes'} = [];
	$appinfo->{'locations'} = [];
	$appinfo->{'extraBools'} = [];

	for ($i=0; $i < 36; $i++)
	{
	    $val = substr($txt, $i*21, 21);
	    $idx = index($val, "\000");
	    $val = substr($val, 0, $idx) if ($idx >= 0);
	    if ($i < 16)	{ push(@{$appinfo->{'foodTypes'}}, $val); }
	    elsif ($i < 32)	{ push(@{$appinfo->{'locations'}}, $val); }
	    else		{ push(@{$appinfo->{'extraBools'}}, $val); }
	}
    } else {
	# expanded -> raw
	$appinfo->{'raw'} = '';

	for ($i=0; $i < 16; $i++)
	{
	    $appinfo->{'raw'} .= $appinfo->{'foodTypes'}->[$i] . ("\000" x
				 (21 - length($appinfo->{'foodTypes'}->[$i])));
	}
	for ($i=0; $i < 16; $i++)
	{
	    $appinfo->{'raw'} .= $appinfo->{'locations'}->[$i] . ("\000" x
				 (21 - length($appinfo->{'locations'}->[$i])));
	}
	for ($i=0; $i < 4; $i++)
	{
	    $appinfo->{'raw'} .= $appinfo->{'extraBools'}->[$i] . ("\000" x
				 (21- length($appinfo->{'extraBools'}->[$i])));
	}
    }
}

sub readFile
{
    my ($FOODFILE) = @_;
    my ($db, $reclist, $rec, $i) = ({ 'NEXT_ID'=>0,
				      '__RECORDS' => [],
				      '__APPINFO' => {  'foodTypes' => [],
							'locations' => [],
							'extraBools' => [] }});
    $reclist = $db->{'__RECORDS'};

    open(FD, "<$FOODFILE") || return $db;

    for ($i=0; $i < 16; $i++)
    {
	chop($rec = <FD>);
	push(@{$db->{'__APPINFO'}->{'foodTypes'}}, $rec);
    }
    for ($i=0; $i < 16; $i++)
    {
	chop($rec = <FD>);
	push(@{$db->{'__APPINFO'}->{'locations'}}, $rec);
    }
    for ($i=0; $i < 4; $i++)
    {
	chop($rec = <FD>);
	push(@{$db->{'__APPINFO'}->{'extraBools'}}, $rec);
    }
    chop($db->{NEXT_ID} = <FD>);

    while (!eof(FD))
    {
	$rec = {};
	chop($rec->{food_id} = <FD>);
	$rec->{name} = &readString(FD);
	$rec->{info} = &readString(FD);
	($rec->{foodTypeBits}, $rec->{locationBits},
	 $rec->{hours_weekday}, $rec->{hours_weekend},
	 $rec->{extraBits}, $rec->{rating}) =
	    split(',', (chop($_ = <FD>),$_)[1]);
	$rec->{note} = &readString(FD);
	$_ = <FD>;

	push(@$reclist, $rec);
	$db->{$rec->{food_id}} = $#$reclist;
    }
    close(FD);
    return $db;
}

sub newFoodId
{
    my ($db) = @_;

    return $db->{NEXT_ID}++;
}

sub writeFile
{
    my ($FOODFILE, $db) = @_;
    my ($rec, $i);

    unless (open(FD, ">$FOODFILE"))
    {
	PilotMgr::msg("Unable to write to $FOODFILE.  Help!");
	return;
    }

    for ($i=0; $i < 16; $i++)
    {
	print FD $db->{'__APPINFO'}->{'foodTypes'}->[$i], "\n";
    }
    for ($i=0; $i < 16; $i++)
    {
	print FD $db->{'__APPINFO'}->{'locations'}->[$i], "\n";
    }
    for ($i=0; $i < 4; $i++)
    {
	print FD $db->{'__APPINFO'}->{'extraBools'}->[$i], "\n";
    }
    print FD $db->{NEXT_ID},"\n";

    foreach $rec (@{$db->{'__RECORDS'}})
    {
	print FD $rec->{food_id},"\n";
	if (defined($rec->{name}))
	{
	    print FD length($rec->{name}),"\n$rec->{name}\n";
	} else {
	    print FD "0\n\n";
	}
	if (defined($rec->{info}))
	{
	    print FD length($rec->{info}),"\n$rec->{info}\n";
	} else {
	    print FD "0\n\n";
	}
	print FD (defined($rec->{foodTypeBits}) ? $rec->{foodTypeBits} : 0),
	    ',', (defined($rec->{locationBits}) ? $rec->{locationBits} : 0),
	    ',', (defined($rec->{hours_weekday}) ? $rec->{hours_weekday} : -1),
	    ',', (defined($rec->{hours_weekend}) ? $rec->{hours_weekend} : -1),
	    ',', (defined($rec->{extraBits}) ? $rec->{extraBits} : 0),
	    ',', (defined($rec->{rating}) ? $rec->{rating} : 0), "\n";
	if (defined($rec->{note}))
	{
	    print FD length($rec->{note}),"\n$rec->{note}\n\n";
	} else {
	    print FD "0\n\n\n";
	}
    }
    close(FD);
}

sub readString
{
    my ($fd) = @_;
    my ($str, $len) = ("");

    $len = <$fd>;
    while ($len > 0 && !eof($fd))
    {
	$_ = <$fd>;
	$len -= length($_);
	$str .= $_;
    }
    if ($len < 0)
    {
	chop($str);
    } else {
	$_ = <$fd>;
    }

    return($str);
}

1;

