#!/usr/bin/python
#
# Note that the defaults and messages in this script are tailored to
# Debian GNU/Linux.  If you are packaging PalmPython for another
# distribution (of Linux or any other OS), you might wish to change
# them or write your own configuration script.
#
# Run with an '-s' to set up the system-wide configuration (assumes
# it is being run as root, so it can chown/chmod stuff)
#
# Otherwise, sets up the configuration file for the current user.
#
"""
  configsetup - simple script used to set up PalmPython
  $Id: configsetup.py,v 1.1 1998/09/01 11:02:50 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


"""

__version__ = '$Id: configsetup.py,v 1.1 1998/09/01 11:02:50 rob Exp $'

import PDA.Palm
from PDA.Palm import Config

import string, os, sys, grp

help_port = '''On Linux systems, /dev/ttyS0 is the equivalent of COM1 and /dev/ttyS1
is the equivalent of COM2.  If you use the default, /dev/pilot, you
should make a symbolic link in /dev which points to the appropriate
port, for example:

  ln -s /dev/ttyS0 /dev/pilot'''

help_datadir = '''
The data directory is where backups and other PalmPilot-related
information is stored.  Each PalmPilot user name is given its own
section of this directory, so it can be shared.
'''

help_username = """You can sync with multiple PalmPilots, but for offline use (eg. deferred installs)
you must specify a default user name.

If you don't know your PalmPilot's user name, or if it doesn't have one, use the
'install-user' utility which is part of pilot-link to check and/or set it."""

help_conduits = """Specify a list of conduit names, separated by commas.  Look in the
'Conduit' package in the source to see what is available; currently,
you can use 'TimeSync', 'Backup', and 'Install', but more may be added
in the future."""

def askgrp(default='root'):
    while 1:
	s = string.strip(raw_input('Group [%s]? ' % default))
	if not s: s = default
	try:
	    gid = grp.getgrnam(s)[2]
	    return gid
	except:
	    print "Invalid group."
	    
def askyn(prompt, de=0, help=None):
    p = prompt
    if de: p = p + " [Y/n]? "
    else: p = p + " [y/N]? "
    s = string.strip(raw_input(p))
    if s == '?' and help:
	print help
	print
    elif s:
	return s[0] in 'yY'
    else:
	return de
    
def ask(r, sec, var, q, de=None, help=None):
    d = r.get(sec, var, de)
    while 1:
	p = "%s [%s]? " % (q, d)
	s = string.strip(raw_input(p))
	if s == '?' and help:
	    print help
	    print
	elif s:
	    r.set(sec, var, s)
	    break
	else:
	    r.set(sec, var, d)
	    break

def edit_system_config():
    r = Config.PalmRegistry()
    try: r.load_file(Config.system_conf)
    except IOError: pass

    print """Setting up PalmPython system configuration.
At many prompts, you may enter '?' for more information."""

    print """
Please enter the port to which your PalmPilot cradle is attached."""
    ask(r, 'defaults', 'port', 'Port', '/dev/pilot', help_port)
    r.set('defaults','default-port',r.get('defaults','port'))

    print """
If you do not set up a system-wide data directory, only users who have
created a private configuration will be able to use PalmPython.
"""
    if askyn("Do you want a system-wide data directory", 1, help_datadir):
	ask(r, 'defaults', 'data-directory', 'Data directory', '/var/state/palm',
	    help_datadir)
	d = r.get('defaults','data-directory')
	if not os.path.exists(d):
	    os.mkdir(d)
            if askyn("Give everyone write permission to the data directory", 0):
		os.chmod(d, 01777)
	    elif askyn("Give a particular group write permission?", 0):
		gid = askgrp('staff')
		os.chown(d, 0, gid)
		os.chmod(d, 03770)
	elif not os.path.isdir(d):
	    print "That path exists but is not a directory.  Fix it by hand before running PalmPython."
    elif r.has_key('defaults','data-directory'):
	r.del_key('defaults','data-directory')
	
    print """
If you set up a system-wide user name, users who have not created a private
configuration will use it whenever their PalmPilot's actual user name is
unavailable.  This probably is not what you want.
"""
    if askyn("Do you want a system-wide default user name",
	     r.has_key('defaults','user'), help_username):
	ask(r, 'defaults', 'user', 'Default user name', 'Nobody', help_username)
	if askyn("Do you want to add this user to the data directory", 1):
	    d = r.get('defaults','user')
	    r.add_user(d)
    elif r.has_key('defaults','user'):
	r.del_key('defaults','user')
	
    if not r.has_section('PalmPython'):
	r.set('PalmPython','HotSync.conduits','TimeSync, Backup, Install')
	
    r.save_file(Config.system_conf)
    
def edit_user_config():
    r = Config.PalmRegistry()
    try: r.load_file(os.path.expanduser(Config.user_conf))
    except IOError: pass

    sr = Config.PalmRegistry()
    try: r.load_file(Config.system_conf)
    except IOError: pass

    print """Setting up PalmPython user configuration.
At many prompts, you may enter '?' for more information."""

    if not sr.has_key('defaults','default-port'):
	print "\nPlease specify the port to which your PalmPilot cradle is attached.\n"
	ask(r, 'defaults','port','Port', '/dev/pilot', help_port)
	r.set('defaults','default-port',r.get('defaults','port'))
	
    if not sr.has_key('defaults','data-directory') and \
       not r.has_key('defaults','data-directory'):
	print "\nYou must set up a private data directory to use PalmPython.\n"
	b = 1
    else:
	b = askyn("Do you want a private data directory",
		  r.has_key('defaults','data-directory'), help_datadir)

    if b:
	ask(r, 'defaults','data-directory','Data directory (relative to $HOME)',
	    'Palm', help_datadir)
	d = r.get('defaults','data-directory')
	if not d[0] == '/':
	    d = os.path.expanduser(os.path.join('~',d))
	    r.set('defaults','data-directory',d)
	if not os.path.exists(d):
	    os.mkdir(d)
	elif not os.path.isdir(d):
	    print "That path exists but is not a directory.  Fix it by hand before running PalmPython."
    elif r.has_key('defaults','data-directory'):
	r.del_key('defaults','data-directory')

    if not sr.has_key('defaults','user') and not r.has_key('defaults','user'):
	print "\nIf you do not set a default user name, you will not be able\nto use some features of PalmPython.\n"
    elif sr.has_key('defaults','user') and not r.has_key('defaults','user'):
	print '\nThe system default user name is "%s".  If this is not the name of\nyour PalmPilot, you should set a different default.\n' % sr.get('defaults','user')
	
    if askyn("Do you want to set a default user name",
	     r.has_key('defaults','user') or not sr.has_key('defaults','user'),
	     help_username):
	un = None
	if askyn("Retrieve the user name from your PalmPilot", 0):
	    p = r.get('defaults','default-port',sr.get('defaults','default-port'))
	    if p:
		print "Waiting for connection on %s (press HotSync now)..." % p
		dlp = PDA.Palm.DLP(p)
		u = dlp.getUserInfo()
		un = u['name']
		dlp.close()
		r.set('defaults','user',un)
		print 'User name: "%s"' % un
	if un is None:
	    ask(r, 'defaults', 'user', 'User name', 'Nobody', help_username)

	q = None
	if r.has_key('defaults','data-directory'):
	    q = r
	    u = r.list_users()
	elif sr.has_key('defaults','data-directory'):
	    q = sr
	    u = r.list_users()
	un = r.get('defaults','user')
	if q is not None and un and un not in u:
	    if askyn('Set up a subdirectory for this user', 1):
		q.add_user(un)
    elif r.has_key('defaults','user'):
	r.del_key('defaults','user')
	
    if not sr.has_key('PalmPython','HotSync.conduits') and \
       not r.has_key('PalmPython','HotSync.conduits'):
	r.set('PalmPython','HotSync.conduits', 'TimeSync, Backup, Install')

    r.save_file(os.path.expanduser(Config.user_conf))


if __name__ == '__main__':
    if '-s' in sys.argv: edit_system_config()
    else: edit_user_config()
    
