"""
  PDA.Palm.Conduit - Conduit API for Python and PalmOS
  $Id: Conduit.py,v 1.6 1998/08/29 01:09:01 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  Each conduit is implemented as a class, with an API conformant
  to the one described here.  The HotSync process should instantiate
  one or more conduits (or perhaps all available ones), and then
  call them in an appropriate order.

  Information:
    Conduits must define the following attributes, which should be
    considered to be read-only:

      name    - the name of the conduit, eg. 'Backup'
      version - version string, eg. '1.0'
      author  - the author's name, which may include an e-mail address
                in the usual way, eg. 'Rob Tillotson <rob@io.com>'
      description - a full description of the conduit (multiple lines
                allowed)
      url     - a url at which current information about the conduit
                can be found

  API:

    __init__ and __del__ should be used for initialization and
    finalization, as usual.

    To run the conduit, call it.  The __call__ method takes two
    parameters, an open DLP connection and a user name.  (It is up to
    the conduit to get the user information from the PalmOS device if
    no name is supplied or if it needs something other than a user
    name.  The name is only supplied as a convenience because most
    conduits probably won't need anything else to locate backup files
    and configuration information.

    To configure the conduit, call its configure method, passing a
    dictionary of option names and values.  The available options
    and valid option values are conduit-dependent.  Note that because
    the possible ways in which options could be stored, edited, etc.
    are almost infinite in number, this module does not support or
    require any particular method of accessing them -- it is up to the
    calling program to supply them, via any appropriate means, to the
    conduit as a dictionary.  To retrieve the current options, call the
    configure method without a parameter.

"""

__version__ = '$Id: Conduit.py,v 1.6 1998/08/29 01:09:01 rob Exp $'

import sys
from PDA.Palm import Options
from PDA.Palm import Plugin

Error = 'PDA.Palm.Conduit.Error'

class Conduit(Plugin.Plugin):
    """Superclass for all conduits.
    """
    def __init__(self, *a, **kw):
	apply(Plugin.Plugin.__init__, (self,)+a, kw)
	self.type = 'Conduit'
	
    def __call__(self, dlp, username):
	"""Invoke the conduit.
	"""
	pass

    def synchronize(self, remote, local, archive, fast=0):
	"""Generic synchronization logic, similar to that used by the
	Palm desktop.  Assumes that the parameters are Databases with
	the appropriate methods; note that, as dictated by the
	capabilities of each side of the connection, the sync process
	is not symmetrical (although its results are).  To make it
	easier to use this function as-is without overloading, there
	are several callbacks which may be used to provide conduit-
	specific behavior.
	"""
	pass
    
	    

			
		    
