"""
  PDA.Palm.App.Address - Address Book
  $Id: Address.py,v 1.5 1998/08/29 01:09:00 rob Exp $

  Copyright 1998 Rob Tillotson <rob@io.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License, version 2,
  as published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write the Free Software Foundation,
  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.


  This module handles databases in the format used by the built-in
  address book application.
"""

__version__ = '$Id: Address.py,v 1.5 1998/08/29 01:09:00 rob Exp $'

import PDA.Palm
from PDA.Palm import _pdapalm, FLD_STRING, FLD_INT, FLD_UNKNOWN, FLD_LIST

import struct, re, quopri, operator

_fields = {}
map(lambda k,d=_fields: operator.setitem(d,k, (FLD_STRING, '')),
    ['lastname', 'firstname', 'company', 'phone1', 'phone2', 'phone3',
     'phone4', 'phone5', 'address', 'city', 'state', 'zip', 'country',
     'title', 'custom1', 'custom2', 'custom3', 'custom4', 'note'])
_fields['showPhone'] = (FLD_INT, 0, 0, 5)
_fields['phoneLabels'] = (FLD_LIST, [0,0,0,0,0], 5, 5)

class Record(PDA.Palm.Record):
    def __init__(self, *a, **kw):
	self.fields = _fields
	apply(PDA.Palm.Record.__init__, (self,)+a, kw)
	
    def unpack(self, raw):
	self.raw = raw
	_pdapalm.AddressUnpack(self.data, raw)

    def pack(self):
	self.raw = _pdapalm.AddressPack(self.data)
	return self.raw

	
class AppBlock(PDA.Palm.AppBlock):
    def __init__(self, raw=None):
	PDA.Palm.AppBlock.__init__(self, raw)

    def unpack(self, raw):
	self.raw = raw
	_pdapalm.AddressUnpackAppBlock(self.data, raw)

    def pack(self):
	self.raw = _pdapalm.AddressPackAppBlock(self.data)
	return self.raw
    

class Database(PDA.Palm.Database):
    def __init__(self, db, info):
	PDA.Palm.Database.__init__(self, db, info)
	self.record_class = Record
	self.appblock_class = AppBlock
	

PDA.Palm.Types.register(Database, {'type':'DATA', 'creator':'addr'})
