
# Description:  This file includes procedures for automatical logging.
#
# Date:         03.03.98
# Author:       Andreas Gelhausen, atte@gecko.north.de
#
# Changes:      03.03.98  Now this script can automatically be loaded
#                         from tkirc (~.tkirc/autoload/) and you
#                         don't need to change your tkircrc!
#
# Install:
#               1. copy this file to `~/.tkirc/autoload/log-support.tcl'
#               2. edit `log_list' (see the examples below)
#               3. reload your tkircrc or restart tkirc


# log_list: Each entry includes three values:
#             1. channel's name
#             2. path for the logfile
#             3. options for command "/log" ("-d" or/and "-r")
global log_list
set log_list {
    {"#tkirc" "~/.tkirc/logfile-tkirc" "-d -r"}
}

# on_join_logs: tkirc will automatically open the logfile by joining
#               that certain channel.
proc on_join_logs { } {
  global on_args log_list crapwindow nickname

  if {[strcmp "$on_args(nick)" "$nickname"] == 0} {
    foreach x "$log_list" {
      if {[strcmp "$on_args(channel)" "[lindex "$x" 0]"] == 0} {
        parsein $crapwindow "/log [lindex "$x" 0] [lindex "$x" 1] [lindex "$x" 2]"
      }
    }
  }
}

# on_leave_logs: The logfile for that channel you leave will be
#                automatically closed.
proc on_leave_logs { } {
  global on_args log_list crapwindow nickname

  if {[strcmp "$on_args(nick)" "$nickname"] == 0} {
    foreach x "$log_list" {
      if {[strcmp "$on_args(channel)" "[lindex "$x" 0]"] == 0} {
	parsein $crapwindow "/closelog [lindex "$x" 0]"
      }
    }
  }
}

# on_signoff_logs: The logfiles for all actual channels will be
#                  automatically closed.
proc on_signoff_logs { } {
  global on_args log_list crapwindow chan nickname

  if {[strcmp "$on_args(nick)" "$nickname"] == 0} {
    foreach x "$log_list" {
      foreach y "$chan(list)" {
        if {[strcmp "$chan($y)" "[lindex "$x" 0]"] == 0} {
	  parsein $crapwindow "/closelog [lindex "$x" 0]"
	}
      }
    }
  }
}
