/*
 * PPPupd - misc.c - Miscellaneous routines for use with pppupd.
 *	Jake Bouvrie <swarthy@thetasys.com>
 */

#include	"pppupd.h"

/*
 * getdate returns the full date string, such as by the shell
 * cmd, "date". Takes no args.
 */ 
char	*getdate(void)
{
	time_t	timep = 0,
		timet = 0;
	
	if ( (timet = time((void *)&timep)) != 0 )
		return ctime(&timep);
	else
		return "Could Not get time";
}


/*
 * err_fatal, just prints out an error, and kills us.
 */
void	err_fatal(char	*s)
{
	if (s != NULL)
		printf("Fatal Error: %s\n", s);
	exit(-1);
}

/*
 * exist() checks to see if the file at 'path' exists, via
 * a call to stat(). Returns 0 if it exists, -1 if not.
 */
int	exist(char	*path)
{
	struct	stat	sbuf;
	int		err = 0;
	extern	int	errno;

	if (path == NULL)
		err_fatal("A horrible memory error occoured. path was null to stat.\n");
	
	if ( (err = stat(path, &sbuf)) == 0 )
		return 0;
	else {
		printf("Fatal Error: The file %s does not exist or does not have the correct permissions.\n", path);
		perror("stat");
		exit(-1);
	}
}

/*
 * makepriority() takes the direct string which the user entered into the
 * configuration file, breaks it down into a string for facility
 * and a string for level. It then returns the ints to be used in
 * syslog(), based on what the strings for facility and level contain.
 */
int	makepriority(char	*priority, int	*levelp, int	*facilityp)
{
	int	level,			/* int for level */
		facility;		/* int for facility */

	char	*facs = NULL,		/* string version of facility */
		*levels = NULL;		/* string version of level */
	char	toksep[] = ". ";	/* can be separated by '.' or ' ' */

	/* 
	 * break down the format given in the conf file 
	 * parse out two tokens in the form foo.bar
	 */

	priority = lowerstr(priority);

	if ((facs = (char *)strtok(priority, toksep)) != NULL)
		if ((levels = (char *)strtok(NULL, toksep)) != NULL)
			;
		else
			printf("priority broke.\n");



#ifdef _DEBUG_
	printf("Debug: priority: %s facility: %s level: %s\n", priority, levels, facs);
#endif
	
	/*
	 * Now, translate the level string that user gave us, to the actual int
	 * value, which we use directly for syslog()
	 */

	if ( (strcmp(facs, "emerg")) == 0 )
		facility = LOG_EMERG;
	else if ( (strcmp(facs, "alert")) == 0 )
                facility = LOG_ALERT;
	else if ( (strcmp(facs, "crit")) == 0 )
                facility = LOG_CRIT;
	else if ( (strcmp(facs, "err")) == 0 )
                facility = LOG_ERR;
	else if ( (strcmp(facs, "warning")) == 0 )
                facility = LOG_WARNING;
	else if ( (strcmp(facs, "notice")) == 0 )
                facility = LOG_NOTICE;
	else if ( (strcmp(facs, "info")) == 0 )
                facility = LOG_INFO; 
	else if ( (strcmp(facs, "debug")) == 0 )
                facility = LOG_DEBUG;
	else
		facility = LOG_NOTICE;

	/*
	 * Translate the string for the facility
	 * yes, the var name is fucked up.
	 */

	if ( (strcmp(levels, "daemon")) == 0 )
		level = LOG_DAEMON;
	else if ( (strcmp(levels, "kern")) == 0 )
                level = LOG_KERN;
	else if ( (strcmp(levels, "mail")) == 0 )
                level = LOG_MAIL;
	else if ( (strcmp(levels, "syslog")) == 0 )
                level = LOG_SYSLOG;
	else if ( (strcmp(levels, "user")) == 0 )
                level = LOG_USER;
	else	
		level = LOG_DAEMON;

#ifdef _DEBUG_
	printf("Debug: IntLevel: %d, IntFacility: %d\n", level, facility);
#endif

	/* place values into intp's given */

	*levelp = level;
	*facilityp = facility;

	return 0;
}

char	*lowerstr(char	*s)
{
        char    *p;

	if (!s)
		return NULL;

        p = s;

        while (*s)
		*s++ = (char)tolower((int)*s);
	
	return	(p ? p : NULL);
}
