/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997, 1998 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#if defined HAVE_LIBCRYPT && !defined HP_UX && !defined FreeBSD
#include <crypt.h>
#endif
#ifdef unicos
#include <fcntl.h>
#endif
#include <setjmp.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>
#ifdef HAS_SHADOW_PASSWD
#include <shadow.h>
#endif
#include "connect.h"
#include "main.h"

extern int set_filter(short, short);
extern short get_var_from_pftprc(const char *, char *, short);
extern short get_login_vars(char *, int, int);
extern void init_user_id(short);
extern void init_user_dir(short);
extern char *time_string(void);
extern long dir_size(char **);

short check_login(int ns, int strnum)
{
   char *username=NULL;
   struct passwd *tmp_un=NULL;
#ifdef HAS_SHADOW_PASSWD
   struct spwd *tmp_spwd=NULL;
#endif
   MEM_CHECK((username = (char *)calloc(SONAME, sizeof(char))));
   *username = '\0';

   /*
    * Send status to the client.
    */
   if ((*statstr)->_PFTP_DAEMON_ & BIT_ONE) {
      if (write((*(statstr+strnum))->ws, "STAT daemon\n", 13) < 0) {
         if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
      }
   }
   else {
      if (write((*(statstr+strnum))->ws, "STAT inetd server\n", 19) < 0) {
         if (slfp) fprintf(slfp, "** write: %s\n", _PFTP_ERROR_ARRAY_);
      }
   }

   /*
    * Read user name and filter id from client.
    */
   if (!get_login_vars(username, ns, strnum)) return 0;

   /*
    * Get entry from /etc/passwd.
    */
   if (!(tmp_un = getpwnam(username))) {
      write((*(statstr+strnum))->ws, "ERRO ** Bad login.\n", 20);
      if (shutdown(ns, 2) < 0) {
         if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
         exit(1);
      }
      if (slfp) fprintf(slfp, "%s getpwnam: Unknown user from %s.\n",
         time_string(), (*statstr)->REMOTEHOSTNAME);
#ifdef USE_POSIX_THREAD
      (*(statstr+strnum))->free = 1;
#endif
      return 0;
   }
#ifdef HAS_SHADOW_PASSWD
   if (!getuid()) {
      if (!(tmp_spwd = getspnam(username))) {
         write((*(statstr+strnum))->ws, "ERRO ** Bad login.\n", 20);
         if (shutdown(ns, 2) < 0) {
            if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         if (slfp) fprintf(slfp, "\n** getspnam: unknown user from %s.\n", (*statstr)->REMOTEHOSTNAME);
#ifdef USE_POSIX_THREAD
         (*(statstr+strnum))->free = 1;
#endif
         return 0;
      }
   }
#endif
   if (slfp) {
      if ((*(statstr+strnum))->from) {
         fprintf(slfp, "%s %s@%s to %s.\n",
         time_string(), (*(statstr+strnum))->from,
         (*statstr)->REMOTEHOSTNAME, username);
      }
      else {
         fprintf(slfp, "%s %s login from %s\n",
         time_string(), username, (*statstr)->REMOTEHOSTNAME);
      }
   }
   if (username) free(username);

   /*
    * Save encrypted password, uid, gid, and
    * home directory in statstr[strnum].
    */
   MEM_CHECK(((*(statstr+strnum))->pw_passwd = (char *)calloc(SONAME, sizeof(char))));
   MEM_CHECK(((*(statstr+strnum))->pw_name = (char *)calloc(SONAME, sizeof(char))));
   MEM_CHECK(((*(statstr+strnum))->pw_dir = (char *)calloc(LONAME, sizeof(char))));
#ifdef HAS_SHADOW_PASSWD
   if (tmp_spwd) strcpy((*(statstr+strnum))->pw_passwd, tmp_spwd->sp_pwdp);
#else
   strcpy((*(statstr+strnum))->pw_passwd, tmp_un->pw_passwd);
#endif
   strcpy((*(statstr+strnum))->pw_name, tmp_un->pw_name);
   strcpy((*(statstr+strnum))->pw_dir, tmp_un->pw_dir);
   (*(statstr+strnum))->pw_uid = tmp_un->pw_uid;
   (*(statstr+strnum))->pw_gid = tmp_un->pw_gid;

   /*
    * Deny root login if pftpnoroot is set.
    */
   if (pftpnoroot && !((*(statstr+strnum))->pw_uid)) {
      write((*(statstr+strnum))->ws, "ERRO ** root access denied.\n", 29);
      if (shutdown(ns, 2) < 0) {
         if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
         exit(1);
      }
      if (slfp) fprintf(slfp, "%s Login as root from %s denied.\n",
         time_string(), (*statstr)->REMOTEHOSTNAME);
#ifdef USE_POSIX_THREAD
      (*(statstr+strnum))->free = 1;
#endif
      return 0;
   }

   /*
    * Set user's home directory and resource file
    * location if the daemon was called from inetd.
    */
   init_user_dir(strnum);
   
   /*
    * Set server filter if '-f' was given
    * by the client on cmdline.
    */
   if (!set_filter(1, strnum)) {
      write((*(statstr+strnum))->ws, "ERRO ** Unknown filter programm.\n", 34);
      sleep(3);
      close((*(statstr+strnum))->ws);
      if (slfp) {
         fprintf(slfp, "** Unknown filter programm.\n");
         fflush(slfp);
      }
      if (shutdown((*(statstr+strnum))->ns, 2) < 0) {
         if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
         exit(1);
      }
#ifdef USE_POSIX_THREAD
      (*(statstr+strnum))->free = 1;
#endif
      return 0;
  }
  return 1;
}


short check_pass(int strnum) {
   int goon=0;
   int check=0;
   char *str=NULL;
   char *tmp=NULL;
   char *sargv[HUNAME];
   char *salt;
   MEM_CHECK((str = (char *)calloc(LONAME, sizeof(char))));

   /*
    * Set user's uid and gid.
    */
   init_user_id(strnum);

   if ((*(statstr+strnum))->from) {
      /*
       * Set the destination directory.  If PFTPRECEIVE
       * is not set the connection is closed.
       */
      if (get_var_from_pftprc("PFTPRECEIVE", str, strnum)) {
         FILE *fp=NULL;
         char *tmp=NULL, *timestr=NULL;
         char *istr=NULL, *wuni=NULL, *wlock=NULL;
         struct stat buf;
         MEM_CHECK((istr = (char *)calloc(LONAME, sizeof(char))));
         MEM_CHECK((tmp = (char *)calloc(SONAME, sizeof(char))));
         MEM_CHECK((timestr = (char *)calloc(SONAME, sizeof(char))));
         MEM_CHECK((wuni = (char *)calloc(SONAME, sizeof(char))));
         MEM_CHECK((wlock = (char *)calloc(SONAME, sizeof(char))));
         sprintf(tmp, "%s@%s",
         (*(statstr+strnum))->from, (*(statstr+strnum))->REMOTEHOSTNAME);

         /*
          * Get maximum upload limit.
          */
         if (get_var_from_pftprc("PFTPUPLIMIT", timestr, strnum)) {
            (*(statstr+strnum))->mul = atol(timestr) * 1024L;
         }
         else {
            (*(statstr+strnum))->mul = MAXIMUM_UPLOAD_LIMIT * 1024L;
         }
         *sargv = str;
         *(sargv+1) = NULL;
         if (((*(statstr+strnum))->mul -= dir_size(sargv)) < 0) {
            send((*(statstr+strnum))->ws, "ERRO ** No space left.\n", 24, MSG_OOB);
            close((*(statstr+strnum))->ws);
            if (shutdown((*(statstr+strnum))->ns, 2) < 0) {
               if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
#ifdef USE_POSIX_THREAD
               (*(statstr+strnum))->free = 1;
#endif
               exit(1);
            }
            if (slfp) {
               fprintf(slfp, "%s %s No space left.\n",
               time_string(), (*(statstr+strnum))->pw_name);
               fflush(slfp);
            }
#ifdef USE_POSIX_THREAD
            (*(statstr+strnum))->free = 1;
#endif
            return 0;
         }

         /*
          * Check if directory exists.  If not create it.
          */
         if (stat(str, &buf)) {
            if (mkdir(str, 0755) < 0) {
               fprintf(stderr, "** %s: %s!\n", str, _PFTP_ERROR_ARRAY_);
               exit(1);
            }
         }

         /*
          * Change to the `upload' directory.
          */
         if (chdir(str) < 0) {
            if (slfp) fprintf(slfp, "** %s: %s\n", str, _PFTP_ERROR_ARRAY_);
            exit(1);
         }

         /*
          * Change to the `from@host' directory.
          */
         if (stat(tmp, &buf)) {
            if (mkdir(tmp, (mode_t)0700)) {
               if (slfp) fprintf(slfp, "** %s: %s\n", tmp, _PFTP_ERROR_ARRAY_);
               exit(1);
            }
         }
         if (chdir(tmp) < 0) {
            if (slfp) fprintf(slfp, "** %s: %s\n", tmp, _PFTP_ERROR_ARRAY_);
            exit(1);
         }

         /*
          * Create index string entry.
          */
         strcpy(timestr, time_string());
         sprintf(istr, "N   %s %s\n", timestr, tmp);
         sprintf(tmp, "%s/Pinfo", str);

         /*
          * Locking file for NFS.
          */
         sprintf(wlock, "%s/wlock", str);
         sprintf(wuni, "%s/%d:%s", str, getpid(),
         getenv("HOSTNAME")? getenv("HOSTNAME"): getenv("HOST")? getenv("HOST"): "unknown_host");
         if ((goon = open(wuni, O_CREAT, 0600)) < 0) {
            fprintf(stderr, "** %s: %s\n", wuni, _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         close(goon);
         for (buf.st_nlink=0, goon=0; buf.st_nlink != 2; goon++) {
            link(wuni, wlock);
            if (stat(wuni, &buf) < 0) {
               fprintf(stderr, "** %s: %s\n", wuni, _PFTP_ERROR_ARRAY_);
               exit(1);
            }
            if (buf.st_nlink != 2) sleep(1);
            /*
             * Just go on.  Probably the lock file is outdated.
             */
            if (goon > 2) break;
         }
         goon = 0;

         /*
          * Open Pinfo for appending.
          */
         if ((fp = fopen(tmp, "a+")) == NULL) {
            if (slfp) fprintf(slfp, "** %s: %s\n", tmp, _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         fprintf(fp, istr);
         fclose(fp);

         /*
          * Unlocking file.
          */
         unlink(wlock);
         unlink(wuni);
         if (wlock) free(wlock);
         if (wuni) free(wuni);

         /*
          * Change to the `time' directory.
          */
         if (mkdir(timestr, (mode_t)0700)) {
            if (slfp) fprintf(slfp, "** %s: %s\n", timestr, _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         if (chdir(timestr) < 0) {
            if (slfp) fprintf(slfp, "** %s: %s\n", timestr, _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         if (timestr) free(timestr);
         if (tmp) free(tmp);
         if (str) free(str);
      }
      else {
         send((*(statstr+strnum))->ws, "ERRO ** User accepts no files.\n", 32, MSG_OOB);
         sleep(3);
         close((*(statstr+strnum))->ws);
         if (slfp) {
            fprintf(slfp, "%s %s accepts no data from %s@%s.\n",
            time_string(), (*(statstr+strnum))->pw_name, (*(statstr+strnum))->from,
            (*statstr)->REMOTEHOSTNAME ? (*statstr)->REMOTEHOSTNAME: "unknown client");
            fflush(slfp);
         }
         if (shutdown((*(statstr+strnum))->ns, 2) < 0) {
            if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         return 0;
      }

      /*
       * Come on client send the stuff.
       */
      write((*(statstr+strnum))->ws, "COME ON", 8);
   }
   else {
      /*
       * If present take password from pftp resource file
       * instread of the one from the password entry.
       */
      if (get_var_from_pftprc("PFTPPASS", str, strnum)) {
         strcpy((*(statstr+strnum))->pw_passwd, str);
      }

      /*
       * Get salt from passwd entry.
       */
      salt = (*(statstr+strnum))->pw_passwd;

      /*
       * Come on client send the stuff.
       */
      write((*(statstr+strnum))->ws, "COME ON", 8);

      /*
       * Read destination directory and password.
       */
      do {
         bzero(str, LONAME);
         if (!fgets(str, LONAME, (*(statstr+strnum))->fp)) {
            check= 0;
            break;
         }
         /* Just for debugging
         if (slfp) {
            fprintf(slfp, "%s", str);
            fflush(slfp);
         }
         */
         for (tmp=str; *tmp && *tmp != '\n' && tmp - str < LONAME; tmp++);
         *tmp = '\0';
         if (strlen(str) < 6 || *(str+4) != ' ') {
            check= 0;
            break;
         }

         /*
          * Setting prot.
          */
         *(str+4) = '\0';
         if (!strcmp(str, "DDIR")) {
            MEM_CHECK((tmp = (char *)calloc(LONAME, sizeof(char))));
            /*
             * Set the appropriate directory.
             */
            if (*(str+5) == '~') {
               strcpy(tmp, (*(statstr+strnum))->pw_dir);
               if (*(str+6)) strcat(tmp, (str+6));
            }
            else strcpy(tmp, (str+5));

            /*
             * Change to the destination directory.
             */
            if (chdir(tmp) < 0) {
               if (slfp) fprintf(slfp, "** %s: %s\n", tmp, _PFTP_ERROR_ARRAY_);
               check= 0;
               break;
            }
            else check |= BIT_TWO;
            free((*(statstr+strnum))->pw_dir);
            (*(statstr+strnum))->pw_dir = NULL;
            if (tmp) free(tmp);
         }
         else if (!strcmp(str, "PASS")) {
            char *rp_ptr=NULL;
            char *lp_ptr=NULL;
            int l=0;
            rp_ptr = (char *)crypt((str+5), salt);
            lp_ptr = (*(statstr+strnum))->pw_passwd;
            /*
             * Checking password.
             */
            for (l=0; *rp_ptr && *lp_ptr && *rp_ptr == *lp_ptr; rp_ptr++, lp_ptr++, l++);
            if (!(*rp_ptr) && !(*lp_ptr) && l >= 13) check |= BIT_ONE;
            else {
               check= 0;
               break;
            }
            free((*(statstr+strnum))->pw_passwd);
            (*(statstr+strnum))->pw_passwd = NULL;
         }
         else if (!strcmp(str, "GOON")) goon=1;
      } while (!goon);
      bzero(str, SONAME);
      if (str) free(str);
      if ((*(statstr+strnum))->pw_passwd) {
         free((*(statstr+strnum))->pw_passwd);
         (*(statstr+strnum))->pw_passwd = NULL;
      }
      if ((*(statstr+strnum))->pw_dir) {
         free((*(statstr+strnum))->pw_dir);
         (*(statstr+strnum))->pw_dir = NULL;
      }
      if (check != (BIT_ONE | BIT_TWO)) {
         send((*(statstr+strnum))->ws, "ERRO ** Login incorrect\n", 25, MSG_OOB);
         sleep(3);
         close((*(statstr+strnum))->ws);
         if (slfp) {
            fprintf(slfp, "%s Bad login from %s.\n", time_string(),
            (*statstr)->REMOTEHOSTNAME ? (*statstr)->REMOTEHOSTNAME: "unknown client");
            fflush(slfp);
         }
         if (shutdown((*(statstr+strnum))->ns, 2) < 0) {
            if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         return 0;
      }
   }
   return 1;
}


jmp_buf lenv;

void lhandler(int sig)
{
   alarm(0);
   longjmp(lenv, 1);
}

short get_login_vars(char *username, int ns, int strnum)
{
   FILE *tmp_fp=NULL;
   char *tmp=NULL;
   char *str=NULL;

   MEM_CHECK((str = (char *)calloc(SONAME, sizeof(char))));
   tmp_fp = fdopen(ns, "r");
   signal(SIGALRM, lhandler);
   if (!setjmp(lenv)) {
      int goon=0;
      alarm(13);
      do {
         bzero(str, SONAME);
         fgets(str, SONAME, tmp_fp);
         /* Just for debugging
         if (slfp) fprintf(slfp, "%s", str);
         */

         for (tmp=str; *tmp && *tmp != '\n'; tmp++);
         *tmp = '\0';
         if (strlen(str) < 6 || *(str+4) != ' ') {
            if (slfp) fprintf(slfp, "%s Wrong protocol from %s\n", time_string(),
            (*statstr)->REMOTEHOSTNAME ? (*statstr)->REMOTEHOSTNAME: "unknown client");
            if (shutdown(ns, 2) < 0) {
               if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
               exit(1);
            }
            return 0;
         }

         /*
          * Setting prot.
          */
         *(str+4) = '\0';
         if (!strcmp(str, "USER")) strcpy(username, (str+5));
         else if (!strcmp(str, "FROM")) {
            MEM_CHECK(((*(statstr+strnum))->from = (char *)calloc(SONAME, sizeof(char))));
            strcpy((*(statstr+strnum))->from, str+5); 
         }
         else if (!strcmp(str, "PROG")) (*(statstr+strnum))->usefilter = atoi(str+5);
         else if (!strcmp(str, "GOON")) goon=1;
      } while (!goon);
      alarm(0);
   }
   else {
      if (slfp) fprintf(slfp, "%s Time out for %s\n", time_string(),
      (*statstr)->REMOTEHOSTNAME ? (*statstr)->REMOTEHOSTNAME: "unknown client");
      if (shutdown(ns, 2) < 0) {
         if (slfp) fprintf(slfp, "** shutdown: %s\n", _PFTP_ERROR_ARRAY_);
         exit(1);
      }
      return 0;
   }
   signal(SIGALRM, SIG_IGN);
   if (str) free(str);
   if (slfp) fflush(slfp);
   return 1;
}
