# A special object that allocates guest users to people as they log into
# the moo. It creates a new guest on the fly each time someone tries to
# log on as it, and logs them on as the new guest instead. Guests are
# given interesting names.

package GuestAllocator;
use strict;
use vars qw(@ISA);

use Person;
use Guest;
use Verb;
use VerbCall;
use Error;
use Text;
use ThingList;
use UNIVERSAL qw(isa);
@ISA=qw{Person};

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $this  = Person::new($class,@_);	
	bless ($this, $class);
	return $this;
}

# Return the next guest, or undef if there are none left.
# You can override this to do strange and wonderful things with guest names
# and descriptions.
sub getguest {
	my $this=shift;
	
	# Find a random guest in the guestlist that is not used.
	my $guestdex;
	my @guestlist=@{$this->guestlist};
	my $start=int(rand($#guestlist));
	foreach $guestdex ($start .. $#guestlist, 0 .. ($start-1)) {
		if (! ThingList::FindByName($guestlist[$guestdex],"Guest")) {
			$this->nextguest($guestdex + 1);
			ActiveUser::setactive();
			my $guest=Guest->new(
				parent => Generics::findgeneric("Person"),
			);
			$guest->name($guestlist[$guestdex]);
			$guest->description("Looks rather nondescript.");
			$guest->home($this->home);
			$guest->owner($guest);
			return $guest;
		}
	}
	return undef;
}

# If someone tries to log in as this object, create a new guest for them
# instead.
sub login {
	my $this=shift;
	my $loginobject=shift;
	my @credentials=@_;

	my $guest=$this->getguest;
	if (Error::iserror($guest)) {
		$loginobject->tell($guest);
		return undef;
	}
	if (!$guest) {
		$loginobject->tell(Text::subst($this->maxguests_msg,{}));
		return undef;
	}

	ActiveUser::setactive($guest);
	return $guest->login($loginobject,@credentials);
}

1
