/***

cfconv.c  - upgrade utility for IPTraf 1.3.0 from 1.2.0

***/


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include "dirs.h"

int main(void)
{
    int fd;
    int newfd;    
    unsigned int portdata;
    char newname[60];
    unsigned int padding = 0;
    int br, bw1, bw2;
     
    printf("Adapting port list file for use with this version...\n\n");
    
    strcpy(newname, PORTFILE);
    rename(PORTFILE, strcat(newname, "-1.2.0"));
    
    fd = open(newname, O_RDONLY);
    newfd = open(PORTFILE, O_WRONLY | O_TRUNC | O_CREAT, S_IRUSR | S_IWUSR);
    
    if (fd < 0) {
        printf("Unable to open 1.2.0 port data file\n");
        return 1;
    }
    
    if (newfd < 0) {
        printf("Unable to open 1.3.0 port data file for writing\n");
        close(fd);
        return 1;
    }
    
    do {
        if ((br = read(fd, &portdata, sizeof(unsigned int))) < 0) {
            printf("Unable to read 1.2.0 port data file\n");
            close(fd);
            close(newfd);
            rename(newname, PORTFILE);
            return 1;
        }
        
        if (br > 0) {
            bw1 = write(newfd, &portdata, sizeof(unsigned int));
            bw2 = write(newfd, &padding, sizeof(unsigned int));
        
            if ((bw1 < 0) || (bw2 < 0)) {
                printf("Unable to write new port data\n");
                close(fd);
                close(newfd);
                rename(newname, PORTFILE);
                return 0;
            }
        }
    } while (br > 0);
    
    close(fd);
    close(newfd);
    
    printf("Data conversion complete\n");
    return 0;
}
