.TH xcal 1 "September 1990" "X Version 11 R5"
.SH NAME
xcal \-  calendar with alarms and a notebook for X11
.SH SYNTAX
.B xcal
[
.B \-debug
][
.B \-alarmscan
][
.B \-format
.I fmt
][
.B \-editformat
.I fmt
][
.B \-stripformat
.I fmt
][
.B \-clocktick
.I tick
][
.B \-u
.I username
]
.SH DESCRIPTION
.de EX		\"Begin example
.ne 5
.if n .sp 1
.if t .sp .5
.nf
.ta +8u*\w'\0'u +8u*\w'\0'u +8u*\w'\0'u +8u*\w'\0'u +8u*\w'\0'u +8u*\w'\0'u
..
.de EE
.fi
.if n .sp 1
.if t .sp .5
..
.I Xcal
is an interactive calendar program.
The user interface has several levels.
When started,
.I xcal
displays today's date in a small command box
that is intended to sit on the screen as a companion to the
.I xclock
program.
The format of the command box may be altered using the resource manager, so you
are not stuck with my preferred layout.
You can set the time in the window too, if you wish (see the format resource).
Access to further levels in
.I xcal
is made by clicking a mouse button in the command box.
The command box is split into several areas and clicking on one of these
will popup a window supporting a new function.
.PP
Clicking with mouse button one on the question mark
in the command box pops up a help window.
.I Xcal
comes with many help buttons.
When you are convinced they are no longer
any use to you, they can all be turned off using an X resource.
.LP
A small button containing a `mouse' bitmap
can be pressed with mouse button one to inspect appointments for today.
This generates a panel showing information from the calendar file for today and
information from a set of seven daily files holding regular commitments.
The panel also contains a text scratchpad, `the memo panel'.
This allows the editing of a memo file.
.LP
The calendar functions are accessed by clicking a mouse
buttons inside date portion of the command window.
.IP 1)
Mouse button one pops up a calendar `strip' for the current month.
The strip has some header lines and then one line per day of the month.
The `line per day' display contains the day in the month and the
day of the week.
Today may be highlighted specially \- the notion of Today alters at midnight.
The strip has a help button which displays a description of the panel.
Command buttons in the header line allows the user to bring up a strip
for the previous or the next month.
.IP 2)
Pressing mouse button two in the date area will bring up a dialogue box
which allows the user to select any month of any year (yes, September 1752
is supported).
The month may be input as month name or abbreviation, even though the
prompt indicates a more restrictive format.
.IP 3)
Pressing mouse button 3 in the date label causes the whole program to
exit, a dialog box is used to ask the user for confirmation.
.LP
Like
.IR xcalendar ,
daily events are stored in set of files, one for each day.
If the file exists when the strip is started,
its data is displayed as the label in the command
button on the right-hand side of the month strip.
The file is created and edited by entering a simple text editor
(the standard text widget) which is started
by pressing the right hand side of the appropriate day line in the strip.
You can also add data to the file by selecting a string on the
screen and clicking with
the middle button on the right-hand side of the month strip.
The string is appended to the file for the day.
This short-hand allows one entry to be loaded into several day files.
.LP
The width of the
month strip is computed from the width of the header. 
Users who
wish to display a wider strip to show more of the stored information
should widen the strip using the
.I minStripWidth
resource (see below).
.LP
The colours and fonts used in the strip is controllable by resources.
The widget that comprises each line in the strip is tagged with the short
form name of the day, so it's easy to vary the strip display showing weekends
differently from the weekdays.
.LP
Data files are stored in a directory usually called
.B Calendar
under the user's home directory.
Each file is stored in a subdirectory containing all the data
for a particular year.
This is incompatible with 
.IR xcalendar ,
the user may specify that the compatibility should be maintained.
.LP
Alarms are supported by
.IR xcal .
When a line in the data file starts with a digit, it is
assumed to be a time specification and a candidate for an alarm.
The line contains a string giving the alarm time and a text string
displayed in a dialogue alarm box that pops up when the alarm fires.
You can also arrange for countdown alarms to fire, so that you can
be told that something is about to happen.
These dialogue boxes will automatically go away after two minutes, unless the
`Stick' button is pressed glueing the box onto the screen.
The box can be made to go away at any time by hitting the `Unpin' button.
.LP
When specifying alarms,
.I Xcal
tries to be liberal about the times that it understands.
Time specifications are: h, hh, hhmm, hmm, hh:mm, h:mm, hh.mm, h.mm;
all of these may be optionally followed by an am/pm indicator \- one
of: A, a, AM, am, Am, aM, P, p, PM, pm, Pm, pM.
Times must always be followed by at least one space or tab.
Some legal examples are:
.br
.nf
	12:00 Lunch - Meet Joe at Burger King
	14.30 Meeting in the cafeteria
	2:30p Ring Mark
	7pm Pizza
.fi
.LP
You can make a time like 2:30 mean 14:30 by setting the resource
.I AlarmWarp
to be true.
If this is the case, an alarm hour will be promoted to a PM time if it is found
to be between the range of
zero and the value of the resource
.IR minAlarmWarp .
.LP
.I Xcal
also supports timed command execution from the data file.
To trigger a command, the data part of the line starts
with an exclamation mark, eg:
.br
	4.30pm !xmessage -message 'ring home'
.LP
The exclamation mark can also be replaced by the string `%cron'.
It is also possible to make 
.I xcal
execute a command whenever an alarm is triggered, see the
.I Cmd
resource below.
.LP
The memo function of
.I Xcal
is accessed by pressing the non-date portion of the command window.
This shows a bitmap diagram of three mouse buttons.
Clicking the left mouse button in this area brings up a complex panel,
clicking on the button again will pop it back down again.
The top half of the panel displays the information held in the diary
for today; pressing the Edit button here will start an edit box for today.
The next section of the panel displays the information held in the
weekly files.
Again you cannot directly change the text in this area, you must
press on the Edit button to bring up a strip enabling you to
change things.
The bottom portion of the panel is an edit window displaying the contents
of a file usually called `memo' in the Calendar directory.
The idea of this panel is to allow you to access your current information
in one button click.
.LP
It is obviously possible to change
.IR Xcal 's
data files without using the inbuilt text widget editor.
In general,
.I Xcal
will not notice this.
Editing random day files with a standard text editor will not
change the contents of any displayed strips until the strips are
popped down and up again.
.I Xcal
knows what days have been altered when the text widget is used to
edit the day files, and will reflect any change immediately into
the displayed strips.
.LP
You can make 
.I Xcal
take notice of today's date file and the current memo file.
The `Update' resource sets a polling time in seconds.
When the clock fires and today's file has been altered,
the alarm list is rebuilt from the current date file
and the memo panel is updated.
The bottom part of the memo panel is also updated if the `memo'
file has been altered on the clock tick.
.SH OPTIONS
.LP
Version 4 of
.I Xcal
permits one user to view another's calendar by giving the
.I \-u
option followed by the user's login name.
The user's calendar storage area
is assumed to be called `Calendar' in their home directory.
The facilities are somewhat rudimentary.
First, the main date box will have the user's login name appended to the
date format string.
When a month strip is generated, you will be given read-only access to their
calendar files, assuming that the file permissions allow you to read them.
This is intended to be one step better than using
.I cat
on their calendar files.
.LP
The
.I \-debug
switch causes contents of the initial date window to be incremented very
frequently, this allows some testing of the program.
.LP
The
.I \-alarmscan
switch prints debugging information about the alarm system on standard output.
.LP
The argument following the
.I \-format
is a date format
used to display dates in the top level window
(see below, the
.I Format
resource).
Changing this to include a time format will make
.I xcal
display a clock in your top level window.
.LP
The argument following the
.I \-stripfmt
argument is a date format used to display month names and years in the monthly
calendar strip.
(see the resource
.IR StripFmt ).
.LP
Similarly, the
.I \-editfmt
argument is the format for dates used in an edit window
(see the
.I Editfmt
resource).
.LP
The
.I \-clocktick
argument is used to set the clock update time of the main date window,
should a time be displayed as well as the date.
See the
.I Clocktick
resource.
.SH RESOURCES
As with all standard X applications,
.I xcal
may be customised through 
entries in the resource manager.
It is a serious mistake to install
.I Xcal
without putting the resource initialisation file 
.I Xcal
in 
.IR /usr/lib/X11/app-defaults .
Resource class names are listed below;
resource instance names are identical, except the first letter is in
lower case.
The following resource manager entries are defined:
.LP
.TP "\w'ReverseVideoMarkNNN'u"
.B Debug
If True enables accelerated time.
Alarms will not function correctly.
Default: False.
.TP
.B OtherUser
the name of the user whose calendar files will be inspected.
This is usually set by the
.B \-u
option.
.TP
.B AlarmScan
If True enables printing of alarm related debugging information
to the standard output.
Default: False.
.TP
.B ReverseVideo
If true display the output in reverse video.
Default: False.
.TP
.B Format
This is a format string used to create the contents of the top command
button and the memo box.
The format is aimed at the system routine:
.IR strftime .
I have chosen to use the system routine because it makes it easier for
non-english language sites to generate their own formats.
However, this means that the names used for months and days may not be compatible
with the ones set in the resources below.
Any characters in the format string are passed to the output unchanged
unless they specify a format.
Format letters are preceded by a `%' character and can be found in the
documentation for
.I strftime
on your system.
The SunOS 4.1.3 routine supports:
.EX
%%	same as %
%a	day of week using abbreviated name
%A	day of week using full weekday names
%b	(%h) month, using locale's abbreviated names
%B	month, using locale's full names
%c	date and time as %x %X
%C	date and time, in local long-format date and
	time representation
%d	day of month (01-31)
%D	date as %m/%d/%y
%e	day of month (1-31; single digits are preceded  by a blank)
%H	hour (00-23)
%I	hour (00-12)
%j	day number of year (001-366)
%k	hour (0-23; single digits are preceded by a blank)
%l	hour (1-12; single digits are preceded by a blank)
%m	month number (01-12)
%M	minute (00-59)
%n	same as \en
%p	local equivalent of AM or PM
%r	time as %I:%M:%S %p
%R	time as %H:%M
%S	seconds (00-59)
%t	same as \et
%U	week number of year (01-52), Sunday is the first day of the week
%W	week number of year (01-52), Monday is the first day of the week
%x	date, using locale's date format
%X	time, using locale's time format
%y	year within century (00-99)
%Y	year, including century (fore example, 1988)
%Z	time zone abbreviation
.EE
The default is "%A %d %B %Y", printing the day, the date, the month and the
full year.
I prefer to use "%A %e %B %Y", but this does not seem to be portable to
different systems.
The format string is scanned to determine the update frequency that
is needed to maintain a correct date image.
The default needs updating every 24 hours, if you insert an AM/PM format
then the strip will be updated every 12 hours.
Adding an hour specification will cause an update every hour and specifying
minutes or seconds will cause appropriate behaviour.
.TP
.B ClockTick
If you specify a second hand in the main
date string and only want it updated every 30 seconds (say)
then setting the ClockTick resource to 30 will force an update for that period.
Default: 0 (derived from the
.I Format
string).
.TP
.B StripFmt
is used to format the date line at the top of each strip.
This uses an internal version of the
.I strftime
routine that only
supports format characters relating to months, years and days.
The supported format characters are: %A, %a, %B, %b, %h, %D, %d, %e, %m, %n,
%t, %x, %y and %%.
Long/short day and month names are taken from the resources.
Default: "%B %y".
.TP
.B EditFmt
provides the format string for any edit window.
This uses the same code as
.BR StripFmt .
Default: "%A %d %B %Y".
Again, I prefer to use "%A %e %B %Y".
.TP
.B MarkToday
If True then highlight today.
Default True.
.TP
.B TodayBackground
the background colour when marking, default Black.
.TP
.B TodayForeground
the foreground colour when marking today, default White.
.TP
.B FontToday
Today may be marked by using a special font, if this is desired the
font is given by this resource.
Default is to use the default font.
.TP
.B Directory
The name of the directory under the home directory
where the day files are stored.
Default: Calendar.
.TP
.B XcalendarCompat
If true then subdirectories are not created in the Calendar directory.
This flag is not relevant when files are being read, so users
can use both programs with existing data files.
Default: False.
.TP
.B GiveHelp
If True than access to the help information is given.
If False, help buttons disappear returning screen real-estate to the user.
You should resist setting this to False in the default resources file.
Default: True.
.TP
.B HelpFromFile
The
.I Xcal
program will usually have help strings compiled into it.
These are in English and it may be desirable to use help data in other languages.
If this resource is true, it forces
.I Xcal
to look in a data file for the help strings.
Default: False.
.TP
.B HelpFile
gives the name of the file used as a database for the help system,
accessed when
.B HelpFromFile
is True.
Default: /usr/lib/X11/XCal.help.
.TP
.B InitialCalendar
If True then the calendar for this month is automatically displayed on
startup.
If False, the calendar is not automatically displayed.
Default: False.
.TP
.B InitialEdit
If True then an edit window for today is automatically displayed on
startup if a file exists for today's date.
If False, the edit window is not automatically displayed.
Default: False.
.TP
.B InitialMemo
If True then the memo window is automatically displayed on startup.
Default: False.
.TP
.B UseWmTitle
If True display the month and the year at the head of each strip.
This information is duplicated if your window manager uses titles
so it is nice to be able to turn it off.
Default: True.
.TP
.B TextBufferSize
the maximum number of bytes which we are prepared to deal with in an
edit window.
Default: 2048 bytes.
.TP
.B Alarms
whether or not to enable the alarm system.
Default: True.
.TP
.B ExecAlarms
if the alarm system is active,
whether or not to invoke timed-execution commands.
Default: True.
.TP
.B Update
When scanning for alarms in the current day file
.I Xcal
inspects it at program startup time and also when it is edited using the
normal built-in editing mechanism.
However, if some external program changes t file
.I xcal
will not see the new contents and new alarms will not be set.
Setting this resource to non-zero will force 
.I xcal
to scan the file every `update' seconds
looking for alterations in size and modification date.
When it detects that the file is altered, then
it will rebuild the internal alarm list.
Default: zero.
.TP
.B Nbeeps
When an alarm window is popped up, it is accompanied by `Nbeeps' beeps.
Default: 3.
.TP
.B Volume
Control the loudness of the beep. Default: 50.
.TP
.B Cmd
This resource contains a command that is executed by calling the shell
when every alarm is triggered.
The command is passed the contents of the data line as one argument.
.TP
.B Countdown
contains a comma separated string of numbers; for example: 10,5,0.
The string allows the user to customise warning alarms: so in the
example, alarm boxes will be displayed 10 minutes before the stated time,
5 minutes before the stated time and exactly on the stated time.
Commands lines in the data prefaced by a `!' will always be triggered
exactly at the stated time.
Default: 10,0.
.TP
.B Autoquit
Each dialogue box containing an alarm message contains an `Unpin' button
allowing the user to remove the message from the screen by using mouse button one.
Additionally, the message box can remove itself from the screen after
a specified period, this resource gives that timeout in seconds.
If the resource is set to zero, then the user is always forced to take
explicit action to remove the box.
Default: 120, alarm boxes disappear after 2 mins.
.TP
.B Alarmleft
contains a
.I printf
string that is displayed in the label at the top
of an alarm box when countdown is in operation and
there is some time before the stated time.
The time before the stated time is supplied as the second argument to printf.
Default: ``%d minutes before...''
.TP
.B Alarmnow
contains the 
.I printf
string that is displayed in the label at the top
of an alarm box when the stated time is reached.
Default: ``Time is now...''.
.TP
.B UseMemo
enables the use of the memo feature.
This defaults to ``True'', but is present to allow users to make 
.I XCal
have as it used to.
.TP
.B MemoLeft
affects the placing of the memo button in the top level date window.
The default is `True' meaning that the button box is placed on the left
of the date portion.
Setting this to `False' will place the button box to the right of the
date portions.
.TP
.B MemoFile
gives the name of the memo file within the Calendar directory.
The default is `memo'.
.TP
.B MaxDisplayLines
controls the maximum number of text lines that can placed in the
top half of the memo panel.
The top hald will normally size to the number of lines in the diary
file for the day, unless the number of lines exceed the value in
this resource.
This ensures that today's events do not dominate the memo panel.
Default: 5 lines.
.TP
.B MaxStripHeight
controls the maximum height of a strip.
A scroll bar will be added into the date part of the scrip of the contents
are larger than this number.
If unset, this defaults to the height of the screen.
Default: unset.
.TP
.B MinStripWidth
The width of month strips are set by the top line, which usually
displays the month and year.
The whole strip can be widened from this default value by setting this
resource to be non-zero.
Default: zero (i.e. off).
.TP
.B January
.B February
and so on.
The names of the long form of the month name.
.TP
.B Jan
.B Feb
and so on.
A short form of the month name - done this way because I doubt that
writing with %3s works in all languages.
Changing this resource means that the data file will no longer be
compatible with
.I xcalendar .
.TP
.B Sunday
.B Monday
and so on.
The
.I long
names of the days: Sunday, Monday etc.
These are used in titles: the top level widget, the title of an edit window
and the memo frame.
.TP
.B Sun
.B Mon
and so on.
The short names of the days \- used in date strips.
.TP
.B Private
Contains the string `Private calendar entry' and is used when the \-u option
is in force. It is displayed when a calendar file entry is unreadable
by the caller.
.TP
.B Alarmleft
Contains the string `%d minutes before'.
.TP
.B Alarmnow
Contains the string `Time is now...'.
.TP
.B Already
Contains the string `Already editing %d %B %Y'
I prefer to use `Already editing %e %B %Y'.
.TP
.B AlreadyWeekly
Contains the string `Already editing %A'.
.SH "PANEL MAP"
.PP
.I Xcal
makes extensive use of the resource manager.
The user needs to know the names of the various panels and widgets which
comprise the application.
.LP
.EX
XCal				Toplevel application
	form			Form containing two buttons
		today		Memo Command button
		date		Strip Command button
		mainHelp		Optional main help button
.EE
.LP
Then we have various popups.
The Calendar Strip is:
.EX
"Mon Year"			the popup shell
	Month			panel containing the strip
		header		label containing month and year
		action		form containing < quit > buttons 
			back	command containing < - last month
			quit	command containing exit button
			next	command containing > - next month
		help		command generating help
	viewport			viewport permitting scrolling of the
	data			data widget
		"DDD"		form containing day button (lots of these)
				these are named for the short days of the week
			label	label containing dd DDD, day of the month
				and day of the week
			info	command containing the file data
.EE
.LP
Note that each day button is named for the day of the week, so that
weekends can be highlighted specially using the standard resources.
.LP
The weekly popup strip is:
.EX
weekly				the popup shell
	weekly			panel containing the strip
		header		label containing the title
		action		form containing quit and help
			quit	command containing exit button
			help	command generating help
	viewport		viewport permitting scrolling of the
	data			data widget
		shortday	form containing days
			label	label containing day of the week
			info	command containing the file data
.EE
.LP
The Edit Window is:
.EX
edit				the popup shell
	panel			the panel inside the shell
		title		the form containing the first line
			quit	the exit button
			save	the save button
			help	the help button
			date	the date string
		text		the text widget for editing
		
.EE	
.LP
The Help Window is:
.EX
help				the popup shell
	helpPanel			the panel inside the shell
		helpForm		the form containing the title line
			quit	the exit button
		helpText		the text widget showing the information
.EE
.LP
The Alarm Window is:
.EX
alarm				the popup shell
	alarmPanel		the panel inside the shell
		alarmForm	form for top line
			alarmQuit	the exit button
			alarmHold	the hold button
			alarmTitle	the title on the alarm window
		alarmText	the text widget for displaying
.EE
.LP
The Memo Window is:
.EX
memo				the popup shell
	memoPanel		the panel inside the shell
		title		Top line form widget
			quit	the exit button
			edit	edit button - edit today's info
			help	the help button
			date	display today's date
		display		text from today's date file
		weeklyMemo	form for the Memo title line
			weeklyEdit	Edit button
			weeklyTitle	Title area
		display		text from today's weekly file
		memoMiddle	Middle line form widget
			save	Save button
			memoTitle	text title of middle line
		memoText	Text widget showing memo file
.EE
.LP
The Middle button date selection popup is:
.EX
question				the popup shell
	newdate			the dialog widget
		ok		the OK button
		cancel		the cancel button
.EE
.LP
The Right button exit selection popup is:
.EX
question				the popup shell
	exit			the dialog widget
		yes		the yes button
		no		the no button
.EE
.LP
An error is shown when a multiple attempts are made to edit the same day file.
.EX
question				the popup shell
	noedit			the dialog widget
		ok		the OK button
.EE
.LP
A dialog box is popped up when an attempt is made to exit from an editing
box without saving the file.
.EX
check				the dialog widget
	yes			the yes button
	no			the no button
.EE
.SH FILES
.PP
$HOME/Calendar/\(**
.LP
.TP "\w'xc<dd><Mon><Year>  'u"
xc<dd><Mon><Year>
A data file is day, Month in three letter format and the year.
.TP
xy<Year>
A year directory.
.TP
xw<Day>
A data file for the weekly code, one per day.
.TP
memo
The memo file.
.LP
The standard resource database can be found in /usr/lib/X11/app-defaults/Xcal.
Assuming that this is where the system admin installed it.
.PP
.SH SEE ALSO
xrdb(1), xcalev(1), xcalpr(1), xcal_cal(1)
.PP
.SH BUGS
There should be some way of removing several edit windows from the screen
at once.
.LP
Setting an alarm 1 minute in the future may not work.
.LP
Countdown does not work in the early hours of the morning, if you have a
ten minute countdown and an alarm set at 0005 \- then you will not get
warning at 2325.
.LP
Alarms set at 0000 probably won't work.
.SH AUTHOR
.LP
Copyright 1989,1990,1993 by Peter Collinson, Hillside Systems
All rights reserved.
.PP
This product includes software developed by the University of
California, Berkeley and its contributors.
.PP
At one time, much of the
.B xcalendar
program was plundered to create
.B xcal ;
author is: Roman J. Budzianowski, MIT Project Athena
.PP
Thanks to Ed Gould, Mt Xinu for the support for the
.IR calendar (1)
program.
Thanks to Mark Majhor, Sequent for the basis of the alarm code.
Thanks to Rod Whitby, Austek Microsystems Pty. Ltd., Australia
for the ideas of the Stick/Unpin code for alarms and for prompting
me to add the memo code.
Thanks to Miles O'Neal from Pencom for revising the help code to be
a little more `X', although this was later revised to use files.
.LP
There are a number of other people who have sent in revisions, some I
have used, some I have not.
Thanks anyway.
