/* 
 *  gstalker stock charter
 * 
 *  Copyright (c) 1998 Stefan S. Stratigakos
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 */

#include "myheader.h"
#include "myerrors.h"
#include <string.h>
#include <dirent.h>
#include <unistd.h>


/***************************************************************************************/
void get_export_filename()
{
	char *tstringpointer, tstring[250];
	int tint;
	extern GtkWidget *openfile, *export_options_entry;
	extern char *error_message;	
	
	tstringpointer = gtk_file_selection_get_filename(GTK_FILE_SELECTION(openfile));
	sscanf(tstringpointer, "%s", tstring);
   	if (strlen(tstring) == 0)
	  RETURN_ERR(gs_nothing_entered);

	tint = strlen(tstring);
	if ((tstring[tint - 1] == '/') || (tstring[tint - 1] == '.'))
	  RETURN_ERR(gs_invalid_entry);

	gtk_entry_set_text(GTK_ENTRY(export_options_entry), tstringpointer);
	if (openfile)
		gtk_widget_destroy(openfile);
}
/******************************************************************************************/
void ok_export()
{
	char *tstringpointer, tstring[250], tstring2[250], sep[2];
	FILE *infile, *outfile;
	GList *list;
	float tfloat;
	unsigned int tuint;
	unsigned long importline = 0;
	int tint, format = 0, seperator = 0, dateformat = 0, datesep = 0;
	extern GtkWidget *export_options_radio, *export_options_radio2, *progwindow;
	extern GtkWidget *export_options_radio3, *export_options_radio4, *export_options_radio5;
	extern GtkWidget *export_options_radio6, *export_options_radio7, *progress_bar;
	extern GtkWidget *export_options_radio8, *export_options_radio9, *export_options_radio10;
	extern GtkWidget *export_options_radio11,*export_options_radio12,*export_options_radio13;
	extern GtkWidget *export_options_clist, *export_options_entry, *date_check;
	extern char *datapath, *error_message;
	extern int header_size, data_size;
	struct record1 data;
	struct record2 header;
	
	
    list = GTK_CLIST (export_options_clist)->selection;
    if (! list)
	RETURN_ERR(gs_nothing_selected);
	
    tstringpointer = gtk_entry_get_text(GTK_ENTRY(export_options_entry));
    sscanf(tstringpointer, "%s", tstring);
    tint = strlen(tstring);
    if ((tstring[tint - 1] == '/') || (tstring[tint - 1] == '.'))
    	RETURN_ERR(gs_invalid_entry);
    	
    outfile = fopen(tstring, "w");
    if (! outfile)
	  RETURN_ERR(gs_cant_create);
	  
    while (list)
    {
	tint = (int) list->data;
	gtk_clist_get_text (GTK_CLIST (export_options_clist), tint, 0, &tstringpointer);  
	strcpy(tstring2, tstringpointer);
	if (GTK_TOGGLE_BUTTON (export_options_radio)->active)
		format = 1;
	if (GTK_TOGGLE_BUTTON (export_options_radio2)->active)
		format = 2;
	if (GTK_TOGGLE_BUTTON (export_options_radio3)->active)
		format = 3;
	if (GTK_TOGGLE_BUTTON (export_options_radio4)->active)
		format = 4;
	if (GTK_TOGGLE_BUTTON (export_options_radio5)->active)
		format = 5;
	if (GTK_TOGGLE_BUTTON (export_options_radio6)->active)
	{
		seperator = 1;
		strcpy(sep, " ");
	}
	if (GTK_TOGGLE_BUTTON (export_options_radio7)->active)
	{
		seperator = 2;
		strcpy(sep, ",");
	}
	if (GTK_TOGGLE_BUTTON (export_options_radio8)->active)
		dateformat = 1;
	if (GTK_TOGGLE_BUTTON (export_options_radio9)->active)
		dateformat = 2;
	if (GTK_TOGGLE_BUTTON (export_options_radio10)->active)
		dateformat = 3;
	if (GTK_TOGGLE_BUTTON (export_options_radio11)->active)
		dateformat = 4;
	if (GTK_TOGGLE_BUTTON (export_options_radio12)->active)
		dateformat = 5;
	if (GTK_TOGGLE_BUTTON (export_options_radio13)->active)
		dateformat = 6;
	if (GTK_TOGGLE_BUTTON (date_check)->active)
		datesep = 1;	
	else
		datesep = 0;
	
	strcpy(tstring, datapath);
	strcat(tstring, tstring2);
	infile = fopen(tstring, "rb");
	if (! infile)
	  RETURN_ERR(gs_cant_open_chart);
	  
	show_progress_window("Exporting...");
	
	fread(&header, header_size, 1, infile);
	importline = 1;
	for (tuint = 0; tuint < header.records; tuint++)
	{
		fread(&data, data_size, 1, infile);
		fputs(header.symbol, outfile);
		fputs(sep, outfile);
		sprintf(tstring, "%ld", data.date);
		switch(dateformat)
		{
			case 1 : if (datesep)
				 {
				 	tstring2[0] = tstring[0];
				 	tstring2[1] = tstring[1];
				 	tstring2[2] = tstring[2];
				 	tstring2[3] = tstring[3];
				 	tstring2[4] = '/';
				 	tstring2[5] = tstring[4];
				 	tstring2[6] = tstring[5];
				 	tstring2[7] = '/';
				 	tstring2[8] = tstring[6];
				 	tstring2[9] = tstring[7];
				 	tstring2[10] = 0;
				 }
				 else
				 {
				 	tstring2[0] = tstring[0];
				 	tstring2[1] = tstring[1];
				 	tstring2[2] = tstring[2];
				 	tstring2[3] = tstring[3];
				 	tstring2[4] = tstring[4];
				 	tstring2[5] = tstring[5];
				 	tstring2[6] = tstring[6];
				 	tstring2[7] = tstring[7];
				 	tstring2[8] = 0;
				 }
				 fputs(tstring2, outfile);
				 break;
			case 2 : if (datesep)
				 {
				 	tstring2[0] = tstring[2];
				 	tstring2[1] = tstring[3];
				 	tstring2[2] = '/';
				 	tstring2[3] = tstring[4];
				 	tstring2[4] = tstring[5];
				 	tstring2[5] = '/';
				 	tstring2[6] = tstring[6];
				 	tstring2[7] = tstring[7];
				 	tstring2[8] = 0;
				 }
				 else
				 {
				 	tstring2[0] = tstring[2];
				 	tstring2[1] = tstring[3];
				 	tstring2[2] = tstring[4];
				 	tstring2[3] = tstring[5];
				 	tstring2[4] = tstring[6];
				 	tstring2[5] = tstring[7];
				 	tstring2[6] = 0;
				 }
				 fputs(tstring2, outfile);
				 break;
			case 3 : if (datesep)
				 {
				 	tstring2[0] = tstring[4];
				 	tstring2[1] = tstring[5];
				 	tstring2[2] = '/';
				 	tstring2[3] = tstring[6];
				 	tstring2[4] = tstring[7];
				 	tstring2[5] = '/';
				 	tstring2[6] = tstring[0];
				 	tstring2[7] = tstring[1];
				 	tstring2[8] = tstring[2];
				 	tstring2[9] = tstring[3];
				 	tstring2[10] = 0;
				 }
				 else
				 {
				 	tstring2[0] = tstring[4];
				 	tstring2[1] = tstring[5];
				 	tstring2[2] = tstring[6];
				 	tstring2[3] = tstring[7];
				 	tstring2[4] = tstring[0];
				 	tstring2[5] = tstring[1];
				 	tstring2[6] = tstring[2];
				 	tstring2[7] = tstring[3];
				 	tstring2[8] = 0;
				 }
				 fputs(tstring2, outfile);
				 break;
			case 4 : if (datesep)
				 {
				 	tstring2[0] = tstring[4];
				 	tstring2[1] = tstring[5];
				 	tstring2[2] = '/';
				 	tstring2[3] = tstring[6];
				 	tstring2[4] = tstring[7];
				 	tstring2[5] = '/';
				 	tstring2[6] = tstring[2];
				 	tstring2[7] = tstring[3];
				 	tstring2[8] = 0;
				 }
				 else
				 {
				 	tstring2[0] = tstring[4];
				 	tstring2[1] = tstring[5];
				 	tstring2[2] = tstring[6];
				 	tstring2[3] = tstring[7];
				 	tstring2[4] = tstring[2];
				 	tstring2[5] = tstring[3];
				 	tstring2[6] = 0;
				 }
				 fputs(tstring2, outfile);
				 break;	 
			case 5 : if (datesep)
				 {
				 	tstring2[0] = tstring[6];
				 	tstring2[1] = tstring[7];
				 	tstring2[2] = '/';
				 	tstring2[3] = tstring[4];
				 	tstring2[4] = tstring[5];
				 	tstring2[5] = '/';
				 	tstring2[6] = tstring[0];
				 	tstring2[7] = tstring[1];
				 	tstring2[8] = tstring[2];
				 	tstring2[9] = tstring[3];
				 	tstring2[10] = 0;
				 }
				 else
				 {
				 	tstring2[0] = tstring[6];
				 	tstring2[1] = tstring[7];
				 	tstring2[2] = tstring[4];
				 	tstring2[3] = tstring[5];
				 	tstring2[4] = tstring[0];
				 	tstring2[5] = tstring[1];
				 	tstring2[6] = tstring[2];
				 	tstring2[7] = tstring[3];
				 	tstring2[8] = 0;
				 }
				 fputs(tstring2, outfile);
				 break;
			case 6 : if (datesep)
				 {
				 	tstring2[0] = tstring[6];
				 	tstring2[1] = tstring[7];
				 	tstring2[2] = '/';
				 	tstring2[3] = tstring[4];
				 	tstring2[4] = tstring[5];
				 	tstring2[5] = '/';
				 	tstring2[6] = tstring[2];
				 	tstring2[7] = tstring[3];
				 	tstring2[8] = 0;
				 }
				 else
				 {
				 	tstring2[0] = tstring[6];
				 	tstring2[1] = tstring[7];
				 	tstring2[2] = tstring[4];
				 	tstring2[3] = tstring[5];
				 	tstring2[4] = tstring[2];
				 	tstring2[5] = tstring[3];
				 	tstring2[6] = 0;
				 }
				 fputs(tstring2, outfile);
				 break;
			default : break;
		}
		fputs(sep, outfile);
		switch(format)
		{
			case 1 : sprintf(tstring, "%g", data.open);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.high);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.low);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.close);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%ld", data.volume);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%ld", data.openint);
				 fputs(tstring, outfile);
				 fputs("\n", outfile);
				 break;
			case 2 : sprintf(tstring, "%g", data.high);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.low);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.close);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%ld", data.volume);
				 fputs(tstring, outfile);
				 fputs("\n", outfile);
				 break;
			case 3 : sprintf(tstring, "%g", data.close);
				 fputs(tstring, outfile);
				 fputs("\n", outfile);
				 break;
			case 4 : sprintf(tstring, "%g", data.open);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.high);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.low);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.close);
				 fputs(tstring, outfile);
				 fputs("\n", outfile);
				 break;
			case 5 : sprintf(tstring, "%g", data.open);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.high);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.low);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%g", data.close);
				 fputs(tstring, outfile);
				 fputs(sep, outfile);
				 sprintf(tstring, "%ld", data.volume);
				 fputs(tstring, outfile);
				 fputs("\n", outfile);
				 break;
			default : break;
		}
		importline++;
		tfloat = ((float)importline / header.records);
		if (tfloat > 1.0)
			tfloat = 1.0;
		if (tfloat < 0.0)
			tfloat = 0.0;
		gtk_progress_bar_update (GTK_PROGRESS_BAR (progress_bar), tfloat);
		while (gtk_events_pending())
			gtk_main_iteration();
	}
	if (progwindow)
		gtk_widget_destroy(progwindow);
	fclose(infile);
	list = list->next;
    }
    fclose(outfile);
    if (progwindow)
	gtk_widget_destroy(progwindow);
    RETURN_ERR(gs_export_complete);
}
/*****************************************************************************************/
void save_export()
{
	extern GtkWidget *openfile;
   	
	
	if (openfile)
		gtk_widget_destroy(openfile);
		
	openfile = gtk_file_selection_new("Enter File To Export");
	gtk_signal_connect (GTK_OBJECT (openfile), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &openfile);
	gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(openfile)->ok_button), "clicked",
			    GTK_SIGNAL_FUNC (get_export_filename), NULL);
	gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION(openfile)->cancel_button),
				  "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
				  GTK_OBJECT(openfile));
	gtk_window_position(GTK_WINDOW (openfile), GTK_WIN_POS_CENTER);
	gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION(openfile));
        gtk_widget_show(openfile);
} 
/*******************************************************************************************/
void export_options()
{
	char *text[] = {"Symbol", "Name", "Start", "End"};
	GtkWidget *vbox, *vbox2, *vbox3, *hbox, *frame2, *hsep, *button, *button2, *frame5;
	GtkWidget *frame3, *frame4, *vbox4, *vbox5, *vbox6, *hbox2, *hbox3, *button3, *button4;
	extern GtkWidget *export_options_window, *export_options_radio, *export_options_radio2;
	extern GtkWidget *export_options_radio3, *export_options_radio4, *export_options_radio5;
	extern GtkWidget *export_options_radio6, *export_options_radio7;
	extern GtkWidget *export_options_radio11,*export_options_radio12,*export_options_radio13;
	extern GtkWidget *export_options_radio8, *export_options_radio9, *export_options_radio10;
	extern GtkWidget *export_options_clist, *export_options_entry, *date_check;
	
	
	if (export_options_window)
		return;
		
	export_options_window = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_signal_connect (GTK_OBJECT (export_options_window), "destroy",
			    GTK_SIGNAL_FUNC (gtk_widget_destroyed), &export_options_window);
	gtk_window_position(GTK_WINDOW (export_options_window), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (export_options_window), "Export Options");
	gtk_container_border_width (GTK_CONTAINER (export_options_window), 0);
	gtk_widget_set_usize(GTK_WIDGET (export_options_window), 0, 0);
	
	vbox = gtk_vbox_new (FALSE, 10);
     	gtk_container_border_width (GTK_CONTAINER (vbox), 0);
      	gtk_container_add (GTK_CONTAINER (export_options_window), vbox);
      	gtk_widget_show (vbox);
      	
      	vbox5 = gtk_vbox_new (FALSE, 10);
     	gtk_container_border_width (GTK_CONTAINER (vbox5), 10);
     	gtk_box_pack_start (GTK_BOX (vbox), vbox5, FALSE, TRUE, 0);
      	gtk_widget_show (vbox5);
      	
      	export_options_clist = gtk_clist_new_with_titles (4, text);
      	gtk_clist_set_column_width(GTK_CLIST(export_options_clist), 0, 70);
      	gtk_clist_set_column_width(GTK_CLIST(export_options_clist), 1, 200);
      	gtk_clist_set_column_width(GTK_CLIST(export_options_clist), 2, 70);
      	gtk_clist_set_column_width(GTK_CLIST(export_options_clist), 3, 70);
      	gtk_clist_set_selection_mode (GTK_CLIST (export_options_clist), GTK_SELECTION_MULTIPLE);
       	gtk_clist_set_policy(GTK_CLIST(export_options_clist),GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
      	gtk_container_add (GTK_CONTAINER (vbox5), export_options_clist);
      	gtk_container_border_width (GTK_CONTAINER (export_options_clist), 0);
      	gtk_widget_set_usize(GTK_WIDGET (export_options_clist), 0, 150);
      	gtk_widget_show (export_options_clist);
      	
      	hbox3 = gtk_hbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox5), hbox3, FALSE, TRUE, 0);
        gtk_container_border_width (GTK_CONTAINER (hbox3), 0);
        gtk_widget_show (hbox3);
      	
      	frame2 = gtk_frame_new("Export Field Format:");
      	gtk_container_border_width (GTK_CONTAINER (frame2), 0);
      	gtk_box_pack_start (GTK_BOX (hbox3), frame2, TRUE, TRUE, 0);
      	gtk_widget_show(frame2);
      	
      	vbox2 = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (frame2), vbox2);
        gtk_container_border_width (GTK_CONTAINER (vbox2), 5);
        gtk_widget_show (vbox2);
        
        export_options_radio = gtk_radio_button_new_with_label(NULL,"Symbol Date Open High Low Close Volume OpenInt");
      	gtk_box_pack_start (GTK_BOX (vbox2), export_options_radio, FALSE, TRUE, 0);
      	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (export_options_radio), TRUE);
      	gtk_widget_show (export_options_radio);

      	export_options_radio2 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(export_options_radio)), "Symbol Date High Low Close Volume");
      	gtk_box_pack_start (GTK_BOX (vbox2), export_options_radio2, FALSE, TRUE, 0);
      	gtk_widget_show (export_options_radio2);

      	export_options_radio3 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(export_options_radio)), "Symbol Date Close");
      	gtk_box_pack_start (GTK_BOX (vbox2), export_options_radio3, FALSE, TRUE, 0);
      	gtk_widget_show (export_options_radio3);
      	
      	export_options_radio4 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(export_options_radio)), "Symbol Date Open High Low Close");
      	gtk_box_pack_start (GTK_BOX (vbox2), export_options_radio4, FALSE, TRUE, 0);
      	gtk_widget_show (export_options_radio4);
      	
      	export_options_radio5 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(export_options_radio)), "Symbol Date Open High Low Close Volume");
      	gtk_box_pack_start (GTK_BOX (vbox2), export_options_radio5, FALSE, TRUE, 0);
      	gtk_widget_show (export_options_radio5);
      	
      	vbox6 = gtk_vbox_new (FALSE, 10);
        gtk_container_border_width (GTK_CONTAINER (vbox6), 0);
        gtk_box_pack_start (GTK_BOX (hbox3), vbox6, TRUE, TRUE, 0);
        gtk_widget_show (vbox6);
      	
      	frame3 = gtk_frame_new("Field Separator:");
      	gtk_container_border_width (GTK_CONTAINER (frame3), 0);
      	gtk_box_pack_start (GTK_BOX (vbox6), frame3, TRUE, TRUE, 0);
      	gtk_widget_show(frame3);
      	
      	vbox3 = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (frame3), vbox3);
        gtk_container_border_width (GTK_CONTAINER (vbox3), 5);
        gtk_widget_show (vbox3);
        
        export_options_radio6 = gtk_radio_button_new_with_label (NULL, "Space");
      	gtk_box_pack_start (GTK_BOX (vbox3), export_options_radio6, FALSE, TRUE, 0);
      	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (export_options_radio6), TRUE);
      	gtk_widget_show (export_options_radio6);

      	export_options_radio7 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(export_options_radio6)), "Comma");
      	gtk_box_pack_start (GTK_BOX (vbox3), export_options_radio7, FALSE, TRUE, 0);
      	gtk_widget_show (export_options_radio7);
      	
      	frame5 = gtk_frame_new("Date Separator:");
      	gtk_container_border_width (GTK_CONTAINER (frame5), 0);
      	gtk_box_pack_start (GTK_BOX (vbox6), frame5, TRUE, TRUE, 0);
      	gtk_widget_show(frame5);
      	
      	date_check = gtk_check_button_new_with_label("Enable");
      	gtk_container_border_width (GTK_CONTAINER (date_check), 5);
      	gtk_container_add (GTK_CONTAINER (frame5), date_check);
      	gtk_widget_show(date_check);
      	
      	frame4 = gtk_frame_new("Date Format:");
      	gtk_container_border_width (GTK_CONTAINER (frame4), 0);
      	gtk_box_pack_start (GTK_BOX (hbox3), frame4, TRUE, TRUE, 0);
      	gtk_widget_show(frame4);
      	
      	vbox4 = gtk_vbox_new (FALSE, 0);
        gtk_container_add (GTK_CONTAINER (frame4), vbox4);
        gtk_container_border_width (GTK_CONTAINER (vbox4), 5);
        gtk_widget_show (vbox4);
        
        export_options_radio8 = gtk_radio_button_new_with_label (NULL, "YYYYMMDD");
      	gtk_box_pack_start (GTK_BOX (vbox4), export_options_radio8, FALSE, TRUE, 0);
      	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (export_options_radio8), TRUE);
      	gtk_widget_show (export_options_radio8);
      	
      	export_options_radio9 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(export_options_radio8)), "YYMMDD");
      	gtk_box_pack_start (GTK_BOX (vbox4), export_options_radio9, FALSE, TRUE, 0);
      	gtk_widget_show (export_options_radio9);
      	
      	export_options_radio10 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(export_options_radio8)), "MMDDYYYY");
      	gtk_box_pack_start (GTK_BOX (vbox4), export_options_radio10, FALSE, TRUE, 0);
      	gtk_widget_show (export_options_radio10);
      	
      	export_options_radio11 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(export_options_radio8)), "MMDDYY");
      	gtk_box_pack_start (GTK_BOX (vbox4), export_options_radio11, FALSE, TRUE, 0);
      	gtk_widget_show (export_options_radio11);
      	
      	export_options_radio12 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(export_options_radio8)), "DDMMYYYY");
      	gtk_box_pack_start (GTK_BOX (vbox4), export_options_radio12, FALSE, TRUE, 0);
      	gtk_widget_show (export_options_radio12);
      	
      	export_options_radio13 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(export_options_radio8)), "DDMMYY");
      	gtk_box_pack_start (GTK_BOX (vbox4), export_options_radio13, FALSE, TRUE, 0);
      	gtk_widget_show (export_options_radio13);
      	
      	hbox2 = gtk_hbox_new (FALSE, 10);
      	gtk_box_pack_start (GTK_BOX (vbox5), hbox2, FALSE, TRUE, 0);
        gtk_container_border_width (GTK_CONTAINER (hbox2), 0);
        gtk_widget_show (hbox2);
        
        button3 = gtk_button_new_with_label("Export To ->");
      	gtk_box_pack_start (GTK_BOX (hbox2), button3, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			    GTK_SIGNAL_FUNC (save_export), NULL);
      	gtk_widget_show (button3);
      	
      	export_options_entry = gtk_entry_new ();
      	gtk_box_pack_start (GTK_BOX (hbox2), export_options_entry, TRUE, TRUE, 0);
      	gtk_entry_set_text(GTK_ENTRY(export_options_entry), "/tmp/export.txt");
      	gtk_widget_show (export_options_entry);
      	
        hsep = gtk_hseparator_new();
	gtk_box_pack_start (GTK_BOX (vbox), hsep, FALSE, TRUE, 0);
        gtk_widget_show(hsep);
        
        hbox = gtk_hbutton_box_new();
        gtk_hbutton_box_set_spacing_default(10);
        gtk_hbutton_box_set_layout_default(GTK_BUTTONBOX_END);
        gtk_container_border_width (GTK_CONTAINER (hbox), 10);
        gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, TRUE, 0);
      	gtk_widget_show(hbox);
      		
      	button = gtk_button_new_with_label("OK");
      	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button), "clicked",
			    GTK_SIGNAL_FUNC (ok_export), NULL);
      	gtk_widget_show (button);
      		
      	button2 = gtk_button_new_with_label("Cancel");
      	gtk_box_pack_start (GTK_BOX (hbox), button2, FALSE, TRUE, 0);
      	gtk_signal_connect_object (GTK_OBJECT (button2), "clicked",
			    GTK_SIGNAL_FUNC (gtk_widget_destroy),
			    GTK_OBJECT(export_options_window));
      	gtk_widget_show (button2);
      	
      	button4 = gtk_button_new_with_label("Help");
      	gtk_box_pack_start (GTK_BOX (hbox), button4, FALSE, TRUE, 0);
      	gtk_signal_connect (GTK_OBJECT (button4), "clicked",
			    GTK_SIGNAL_FUNC (help_export_options_window), NULL);
      	gtk_widget_show (button4);
      	
	show_chart_list(export_options_clist);
      	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
      	gtk_widget_grab_default(button);	
      	gtk_widget_show(export_options_window);
}
