/*
    Copyright (C) 1998  Dennis Roddeman
    email: dennis.roddeman@uibk.ac.at

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation 
    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA
*/

#include "tochnog.h"

void print_data_versus_data( long int ival[] )

{
  long int data_item_name0=0, data_item_index0=0, number0=0,
    data_item_name1=0, data_item_index1=0, number1=0,
    len=0, icontrol=0, swit=0, ldum=0, idum[1], 
    idat[DATA_ITEM_SIZE], dof_label[MUKNWN];
  double ddum[1], ddat[DATA_ITEM_SIZE];
  char filename[MCHAR];

  swit = set_swit(-1,-1,"print_data_versus_data");
  if ( swit ) pri( "In routine PRINT_DATA_VERSUS_DATA" );

  db( DOF_LABEL, 0, dof_label, ddum, ldum, VERSION_NORMAL, GET_IF_EXISTS );
  db( ICONTROL, 0, &icontrol, ddum, ldum, VERSION_NORMAL, GET );

  data_item_name0 = ival[0];
  data_item_index0 = ival[1];
  if ( ival[2]<0 ) {
    array_member(dof_label,ival[2],nuknwn,number0);
    if ( db_len(data_item_name0,data_item_index0,VERSION_NORMAL)==npuknwn ) 
      number0 /= nder;
  }
  else 
    number0 = ival[2];

  data_item_name1 = ival[3];
  data_item_index1 = ival[4];
  if ( ival[5]<0 ) {
    array_member(dof_label,ival[5],nuknwn,number1);
    if ( db_len(data_item_name1,data_item_index1,VERSION_NORMAL)==npuknwn ) 
      number1 /= nder;
  }
  else 
    number1 = ival[5];

  strcpy( filename, "tn.dvd" );
  ofstream out( filename, ios::app );

  if ( db_type(data_item_name0)==INTEGER ) {
    db( data_item_name0, data_item_index0, idat, ddum, len, VERSION_NORMAL, GET );
    if ( number0<0 || number0>len-1 )
      db_error( CONTROL_PRINT_DATA_VERSUS_DATA, icontrol );
    out << idat[number0] << "  ";
  }
  else {
    db( data_item_name0, data_item_index0, idum, ddat, len, VERSION_NORMAL, GET );
    if ( number0<0 || number0>len-1 )
      db_error( CONTROL_PRINT_DATA_VERSUS_DATA, icontrol );
    out << ddat[number0] << "  ";
  }

  if ( db_type(data_item_name1)==INTEGER ) {
    db( data_item_name1, data_item_index1, idat, ddum, len, VERSION_NORMAL, GET );
    if ( number1<0 || number1>len-1 )
      db_error( CONTROL_PRINT_DATA_VERSUS_DATA, icontrol );
    out << idat[number1] << "  ";
  }
  else {
    db( data_item_name1, data_item_index1, idum, ddat, len, VERSION_NORMAL, GET );
    if ( number1<0 || number1>len-1 )
      db_error( CONTROL_PRINT_DATA_VERSUS_DATA, icontrol );
    out << ddat[number1] << "  ";
  }

  out << "\n";

  out.close();

  if ( swit ) pri( "Out routine PRINT_DATA_VERSUS_DATA" );
}
