/* fontsel.c */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>	/* ?????? */

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>

#include "../pw/pw.h"
#include "xpw.h"
#include "../common/fonts.h"
#include "../common/common.h"
#include "../xcommon/dialogs.h"
#include "../xcommon/xcommon.h"

#define NO_GRP 0
#define FONT_GRP 1
#define SIZE_GRP 2
#define VADJ_GRP 3
#define HADJ_GRP 4

static Widget font_pshell, font_form,
	font_namelabel, font_namebox,
	font_attrlabel,
	font_attrbox, font_adjbox, font_adjlabel, font_borderbox,
	font_borderlabel, font_nobox, font_nolabel,
	font_sizelabel, font_sizebox,
	font_okbutton, font_cancelbutton;

typedef enum {nobox, namebox, borderbox, sizebox, attrbox} boxtype;

static struct {
	Widget w;
	boxtype pw;
	char *text;
	int state;
	int grp;
	int value;
} buttons[] = {
	{0, namebox, "Courier", 1, FONT_GRP, COURIER},
	{0, namebox, "Helvetica", 0, FONT_GRP, HELVETICA},
	{0, namebox, "New Century Sch", 1, FONT_GRP, NEW_CENTURY},
	{0, namebox, "Times", 1, FONT_GRP, TIMES},
	{0, borderbox, "Top", 1, NO_GRP, BORDER_TOP},
	{0, borderbox, "Bottom", 1, NO_GRP, BORDER_BOTTOM},
	{0, borderbox, "Left", 1, NO_GRP, BORDER_LEFT},
	{0, borderbox, "Right", 1, NO_GRP, BORDER_RIGHT},
	{0, sizebox, "8", 1, SIZE_GRP, SIZE_8},
	{0, sizebox, "10", 0, SIZE_GRP, SIZE_10},
	{0, sizebox, "12", 1, SIZE_GRP, SIZE_12},
	{0, sizebox, "14", 1, SIZE_GRP, SIZE_14},
	{0, sizebox, "18", 1, SIZE_GRP, SIZE_18},
	{0, sizebox, "24", 1, SIZE_GRP, SIZE_24},
	{0, sizebox, "20", 1, SIZE_GRP, SIZE_20},
	{0, sizebox, "30", 1, SIZE_GRP, SIZE_30},
/*  {0, 190, 25, "Top", 1, VADJ_GRP, VADJ_TOP},*/
/*	{0, , "Center", 0, VADJ_GRP, VADJ_CENTER},*/
/*  {0, 190, 55, "Bottom", 1, VADJ_GRP, VADJ_BOTTOM},*/
/*	{0, 190, 100, "Left", 0, HADJ_GRP, HADJ_LEFT},*/
/*  {0, 190, 115, "Center", 1, HADJ_GRP, HADJ_CENTER},*/
/*  {0, 190, 130, "Right", 1, HADJ_GRP, HADJ_RIGHT},*/
	{0, attrbox, "Bold", 1, NO_GRP, BOLD},
	{0, attrbox, "Italic", 1, NO_GRP, ITALIC}
/*  {0, 190, 205, "Inverted", 1, NO_GRP, INVERT}*/
};

#define NO_OF_BTNS (sizeof buttons / sizeof buttons[0])

#define ABORT 0
#define DONE 1
#define WAITING 2

static int status;

static void font_done(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtPopdown(font_pshell);
	status = DONE;
}

static void font_abort(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtPopdown(font_pshell);
	status = ABORT;
}

static void font_clicked(Widget w, XtPointer client_data, XtPointer call_data)
{
	int i, j;

	for (i = 0; i < NO_OF_BTNS; i++)
		if (w == buttons[i].w) break;
	if (i < NO_OF_BTNS) {
		if (buttons[i].grp != NO_GRP) {	/* is it a radio button? */
			for (j = 0; j < NO_OF_BTNS; j++) {
				if (j != i &&
					buttons[i].grp == buttons[j].grp &&
					buttons[j].state == 0) {
						buttons[j].state = 1;
						state_set(buttons[j].w, 0);
				}
				buttons[i].state = 0;
			}
		} else {
			buttons[i].state = !buttons[i].state;
		}
		state_set(w, !buttons[i].state);
	}
}

/* Returns the widget above the one we're creating */
static int from_vert(int i)
{
	int j;

	for (j = i-1; j >= 0; j--)
		if (buttons[j].pw == buttons[i].pw)
			return j;
	return -1;	/* happens for the first widget in each group */
}

static Widget parentbox(int i)
{
	switch (buttons[i].pw) {
	case nobox:
		return font_nobox;
	case namebox:
		return font_namebox;
	case sizebox:
		return font_sizebox;
	case attrbox:
		return font_attrbox;
	case borderbox:
		return font_borderbox;
	default:
		return font_adjbox;
	}
}

static Widget parentlabel(int i)
{
	switch (buttons[i].pw) {
	case nobox:
		return font_nolabel;
	case namebox:
		return font_namelabel;
	case sizebox:
		return font_sizelabel;
	case attrbox:
		return font_attrlabel;
	case borderbox:
		return font_borderlabel;
	default:
		return font_adjlabel;
	}
}

void font_init(Widget topLevel)
{
	int i;

	font_pshell = XtVaCreatePopupShell("font_pshell",
		transientShellWidgetClass, topLevel,
		XtNtitle, translate("Format"),
		(char *)0);

	font_form = XtCreateManagedWidget("font_form",
		formWidgetClass, font_pshell, NULL, 0);

	font_namebox = XtVaCreateManagedWidget("font_namebox",
		formWidgetClass, font_form, (char *)0);
	font_namelabel = XtVaCreateManagedWidget("font_namelabel",
		labelWidgetClass, font_namebox, (char *)0);
	label_set(font_namelabel, "Family Name");
	font_sizebox = XtVaCreateManagedWidget("font_sizebox",
		formWidgetClass, font_form,
		XtNfromHoriz, font_namebox, (char *)0);
	font_sizelabel = XtVaCreateManagedWidget("font_sizelabel",
		labelWidgetClass, font_sizebox, (char *)0);
	label_set(font_sizelabel, "Size");
	font_attrbox = XtVaCreateManagedWidget("font_attrbox",
		formWidgetClass, font_form,
		XtNfromHoriz, font_sizebox, (char *)0);
	font_attrlabel = XtVaCreateManagedWidget("font_attrlabel",
		labelWidgetClass, font_attrbox, (char *)0);
	label_set(font_attrlabel, "Attributes");
	font_borderbox = XtVaCreateManagedWidget("font_borderbox",
		formWidgetClass, font_form,
		XtNfromHoriz, font_attrbox, (char *)0);
	font_borderlabel = XtVaCreateManagedWidget("font_borderlabel",
		labelWidgetClass, font_borderbox, (char *)0);
	label_set(font_borderlabel, "Borders");
	for (i = 0; i < NO_OF_BTNS; i++) {
		char b[256];
		int vert;

		sprintf(b, "font_button%d", i);
		buttons[i].w = XtVaCreateManagedWidget(b,
			toggleWidgetClass, parentbox(i),
			XtNradioData, buttons[i].value,
			XtNtop, XtChainTop,
			XtNbottom, XtChainTop,
			XtNleft, XtChainLeft,
			XtNright, XtChainRight,
			(char *)0);
		if ((vert = from_vert(i)) >= 0) {
			XtVaSetValues(buttons[i].w,
				XtNfromVert, buttons[vert].w, (char *)0);
		} else {
			XtVaSetValues(buttons[i].w,
				XtNfromVert, parentlabel(i), (char *)0);
		}
		XtAddCallback(buttons[i].w, 
			XtNcallback, font_clicked, (XtPointer)i);
		label_set(buttons[i].w, buttons[i].text);
	}

	font_okbutton = XtVaCreateManagedWidget("font_okbutton",
		commandWidgetClass, font_form, 
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNleft, XtChainRight,
		XtNright, XtChainRight,
		XtNfromHoriz, font_borderbox, (char *)0);
	XtAddCallback(font_okbutton, XtNcallback, font_done, NULL);
	label_set(font_okbutton, "OK");
	XtVaSetValues(font_okbutton, XtNwidth, 80, (char *)0);
	font_cancelbutton = XtVaCreateManagedWidget("font_cancelbutton",
		commandWidgetClass, font_form, 
		XtNtop, XtChainTop,
		XtNbottom, XtChainTop,
		XtNleft, XtChainRight,
		XtNright, XtChainRight,
		XtNfromHoriz, font_borderbox,
		XtNfromVert, font_okbutton, (char *)0);
	XtAddCallback(font_cancelbutton, XtNcallback, font_abort, NULL);
	label_set(font_cancelbutton, "Cancel");
	XtVaSetValues(font_cancelbutton, XtNwidth, 80, (char *)0);
}

static void set_button(int group, int value)
{
	int i;

	for (i = 0; i < NO_OF_BTNS; i++)
		if (buttons[i].grp == group && buttons[i].value == value)
			buttons[i].state = 0;
}

int font_input(int *format, int *mask)
{
	XtAppContext app_context = XtWidgetToApplicationContext(topLevel);
	int i;

	*mask = 0;	/* no fields have been changed yet */
	/* set buttons to what's already there */
	for (i = 0; i < NO_OF_BTNS; i++)
		buttons[i].state = 1;
	set_button(FONT_GRP, *format & FONT_MASK);
	set_button(SIZE_GRP, *format & SIZE_MASK);
	set_button(NO_GRP, *format & ITALIC);
	set_button(NO_GRP, *format & BOLD);
	set_button(NO_GRP, *format & BORDER_LEFT);
	set_button(NO_GRP, *format & BORDER_RIGHT);
	set_button(NO_GRP, *format & BORDER_TOP);
	set_button(NO_GRP, *format & BORDER_BOTTOM);
	set_button(HADJ_GRP, *format & HADJ_MASK);
	set_button(VADJ_GRP, *format & VADJ_MASK);
	set_button(NO_GRP, *format & INVERT);
	for (i = 0; i < NO_OF_BTNS; i++)
		state_set(buttons[i].w, !buttons[i].state);
	status = WAITING;
	center(topLevel, font_pshell);
	XtPopup(font_pshell, XtGrabNonexclusive);
	while (status == WAITING) {
		XEvent event_return;
		XtAppNextEvent(app_context, &event_return);
		XtDispatchEvent(&event_return);
	}
	*format = 0;
	for (i = 0; i < NO_OF_BTNS; i++)
		if (!buttons[i].state) *format |= buttons[i].value;
	return status;
}

