/*
   Pathetic Writer
   Copyright (C) 1997, 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * pw.h
 */

#include "../common/richchar.h"

#include "../common/traceme.h"

#define VERSION "Pathetic Writer " VERSION_NO ". No Warranty."

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

/* originally in types.h */
#define EMPTY 0
#define STRING 5

#define BUFFER_COLS 100000
#define BUFFER_ROWS 100000

#define MAKE_POSITION(p)\
	(cons(flocons((p).row),cons(flocons((p).col),NIL)))

#define POSITION_ROW(p) (get_c_long(car(p)))
#define POSITION_COL(p) (get_c_long(cadr(p)))

typedef struct {
	int row, col;
} position;

typedef struct s_style {
        char *name;             /* Default aso */
        unsigned long format;   /* bitwise OR of formats above */
        int height;             /* in pixels */
        int follower;           /* what style a new line gets */
} style;

extern style styles[16];        /* matrix.c */

/* one line */
typedef struct rich_text {
        int height;
        int sty;
        int adj;
        rich_char *p;
} rich_text;

typedef struct plugin_t {
	long row, col;			/* geometry */
	int ph;				/* handle */
	char *name;			/* file name */
	int displayed;			/* started yet? */
} plugin_t;

typedef struct s_buffer {
	char name[1024];		/* identifies the buffer */
	char path[1024];		/* file name */

	position mark_pos;		/* mark */

	long alloc_lines;       	/* number of allocated lines */
	long used_lines;		/* number of used lines */
	rich_text *text;		/* one pointer for each line */
	int change;			/* if there are unsaved changes */
	plugin_t *plugin;		/* array of plugins */
	int nplugin;			/* number of plugins */
	struct s_buffer *next;		/* next buffer in buffer ring */
} buffer;

typedef struct s_window {
	position point_pos;	/* point */
	buffer *buf;		/* buffer */
	position top;		/* left top of visible part of buffer */
	position blku, blkl;	/* upper left & lower right block corners */
	long current_fmt;	/* currently used format */
	struct pw_ui *ui;	/* user interface specifics (Widgets) */
	struct s_window *next;	/* next window in window ring */
} window;

typedef struct {
  int size;             /* the number of keys pressed */
  int maxsize;          /* size of the buffer */
  char *text;           /* the textual contents */
} textbuf;

typedef enum {SPELL_WAIT = 0, SPELL_REPLACE, SPELL_ACCEPT, SPELL_INSERT,
                SPELL_SKIP, SPELL_CANCEL, SPELL_HELP} spell_state;

#include "user_interface.h"

/* from richchar.c */
extern size_t rc_strlen(rich_char *);
extern rich_char *rc_strcpy(rich_char *, rich_char *);
extern rich_char *rc_strcat(rich_char *, rich_char *);
extern rich_char *rc_strdup(rich_char *);
extern rich_char *rc_strins(rich_char *, rich_char *, size_t);
extern rich_char *rc_makerich(unsigned char *, long);
extern unsigned char *rc_makeplain(rich_char *);

/* from window.c */
extern window *w_list;
extern int pr_scr_flag;		/* if the display needs updating */
extern int pr_line_flag;	/* updating the current line is enough */

extern void activate_window(window *);
extern void llpr(char *);
extern void free_window(window *);
extern window *new_window(buffer *, window *);
extern int remove_window(window *);
extern int split_window(window *);
extern void init_windows(buffer *, int, char **);
extern void exit_windows(void);
extern void show_cur(window *);
extern void hide_cur(window *);

extern void get_char_coords(window *, int, int, int, int, int *, int *);
extern void get_coords_cell(window *, int, int, int *, int *, int, int);

/* from selection.c */
extern int pack_selection(buffer *, char *, int, int, int, int);
extern void transfer_done_proc();	/* FIXME */
extern int unpack_selection(buffer *, char *, int, int);

/* from matrix.c */
extern int max_columns;
extern int max_lines;
extern char *fmt_put(char *, int);
extern char *fmt_get(char *, int);
extern rich_text *new_text(void);
extern void free_text(rich_text *);
extern void alloc_line(buffer *, long);
extern int split_line(buffer *, long, long);
extern int join_lines(buffer *, long);
extern int ins_text(buffer *, position, unsigned char *, long);
extern int ins_char(buffer *, long, long, int, long);
extern unsigned char *peek_line(buffer *, long);
extern int peek_char(buffer *, long, long);
extern long rebreak_line(buffer *, long);
extern int del_char(buffer *, long, long);
extern long del_text(buffer *, position, long);
extern long del_lines(buffer *, long, long);
extern int ins_format(buffer *, long, long, long, long);
extern void set_style(buffer *, long, int);
extern int ret_style(buffer *, long);
extern int ret_format(buffer *, long, long);
extern int ret_font(buffer *, long, long);
extern int ret_vadj(buffer *, long);
extern int ret_hadj(buffer *, long);
extern long line_last_used(buffer *);
extern long col_last_used(buffer *, long);
extern void downshift_text(buffer *, long);
extern void upshift_text(buffer *, long);
extern void position_kludge2(void);

/* from cmds.c */
extern void init_cmds(void);

/* from buffer.c */
extern buffer *b_list;
extern char *buffer_name(char *);
extern buffer *new_buffer(char *, char *);
extern buffer *free_buffer(buffer *);
extern char *plugin_basedir(buffer *, char *);
extern void plugin_unique_name(char *, char *);
extern buffer *find_buffer_by_name(char *);
extern int char_width(buffer *, int, int);
extern int line_height(buffer *, int);
extern int line_width(buffer *, int, int);
extern int line_length(buffer *, int);
#if 0
extern int cell_width(buffer *, int);
#endif
extern int cell_height(buffer *, int);
extern void buffer_global_coords(buffer *, long, long, long *, long *);
extern int buffer_plugin2index(buffer *, int);

/* from input.c */
extern void init_input(void);
extern int ask_for_str_comp(char *, char *, int (*)(char *));
extern int ask_for_str(char *, char *);

/* from main.c */
extern int ok2print;
extern int siod_interpreter;
extern char *siaghome, *siaghelp, *siagdocs, *siag_basedir;

/* from fileio_ps.c */
extern int paper_width;
extern int paper_height;
extern int left_margin, right_margin, top_margin, bottom_margin;
extern void preview(void);
extern void printer(void);

/* from railway.c */
extern int errorflag;
extern char *interpreter2name(int);
extern int name2interpreter(char *);
extern int register_interpreter(char *, double (*)(void), void (*)(char *));
extern int is_constant(char *);
#define execute(p) exec_expr(siod_interpreter,(p))
extern void exec_expr(int, char *);

/* from fileio.c */
extern char *patterns[];
extern void register_format(int (*)(char *, buffer *),
		int (*)(char *, buffer *), int (*)(char *), char *);
extern void fileio_init(void);
extern int savematrix(char *, buffer *, char *);
extern int loadmatrix(char *, buffer *, char *);
extern char *guess_file_format(char *);

/* from position.c */
extern position make_position(int, int);
extern position set_point(window *, position);
extern position get_point(window *);
extern position set_mark(window *, position);
extern position get_mark(window *);
extern position set_top(window *, position);
extern position get_top(window *);
extern position find_beginning_of_buffer(window *);
extern position find_end_of_buffer(window *);
extern int at_end_of_line(window *, position);
extern int at_beginning_of_line(window *, position);
extern position find_beginning_of_line(window *, position);
extern position find_end_of_line(window *, position);
extern position line_forward(window *, position);
extern position line_backward(window *, position);
extern int at_end_of_buffer(window *, position);
extern position cell_forward(window *, position);
extern position cell_backward(window *, position);

extern void init_position(void);

/* from mathwrap.c */
extern void init_mathwrap(void);

/* from fontsel.c */
extern int font_input(int *, int *);

