/*
   Egon Animator
   Copyright (C) 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
   print.c

   Produces data suitable for printing on a Postscript device. I have made
   several assumptions to simplify things:
   - paper size is A4 = 595x842 points
   - margin on all sides = 72 points = 1 inch
   - 1 pixel = 1 point means no scaling is necessary
   - PS font has same geometry as X font
   - no background pattern
   - don't draw the grid
   - The lpr command is used for printing

   This works for me, but will probably break (more or less) for anyone
   not using my printer (a NEC S62P) with A4 paper.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>
#include <X11/xpm.h>

#include "types.h"
#include "../xcommon/Animator.h"
#include "egon.h"
#include "../common/fonts.h"

int paper_height = 842;
int paper_width = 595;
int margin = 72;

extern int font_size[8];

extern char *psformat;	/* from fileio_ps.c */

#if 1	/* boo! */
char *psformat = "Foo";
#endif	/* keep compiler happy */

void preview(void)
{
	char fn[256];

	sprintf(fn, "/tmp/siagprint%ld.ps", (long)getpid());
	if (!savematrix(fn, w_list->buf, psformat)) {
		if (!fork()) {
			execlp("gv", "GV", fn, NULL);
			llpr("Can't exec GV");
#ifdef DEBUG
			fprintf(stderr, "Can't exec GV\n");
#endif
			exit(1);
		}
	} else
		llpr("Can\'t make postscript\n");
}

void printer(void)
{
	char fn[256];

	sprintf(fn, "/tmp/siagprint%ld.ps", (long)getpid());
	if (!savematrix(fn, w_list->buf, psformat)) {
		if (!fork()) {
			execlp("lpr", "lpr", fn, NULL);
			llpr("Can't exec lpr");
#ifdef DEBUG
			fprintf(stderr, "Can't exec lpr\n");
#endif
			exit(1);
		}
	}
}

