/*
   Egon Animator
   Copyright (C) 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * matrix.c
 *
 * This module hides the details of stringpool and matrix handling.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/xpm.h>

#include "../xcommon/Animator.h"
#include "egon.h"
#include "types.h"
#include "../common/fonts.h"
#include "../xcommon/embed.h"
#include "../common/cmalloc.h"

int max_lines = BUFFER_ROWS;
int max_columns = BUFFER_COLS;

/*X
   void free_matrix(spread **matrix)
   Frees the memory used by the matrix.
   X */
void free_matrix(ani_object *matrix)
{
	/* It would be nice if this actually did something */
}

ani_object *last_object(buffer *b)
{
	ani_object *o;
	if (!b) return NULL;
	o = b->cast;
	if (!o) return o;
	while (o->next) o = o->next;
	return o;
}

ani_script *last_script(ani_object *o)
{
	ani_script *s;
	if (!o) return NULL;
	s = o->script;
	if (!s) return s;
	while (s->next) s = s->next;
	return s;
}

int ins_format(buffer *buf, ani_object *o, ani_script *s, int format)
{
	if (!buf || !o || !s) return 0;

	o->font = format & 127;
	o->color = (format & COLOR_MASK) >> COLOR_SHIFT;
	return 1;
}

int ret_format(buffer *buf, ani_object *o, ani_script *s)
{
	if (!buf || !o || !s)
		return HELVETICA | SIZE_14;

	return o->font | (o->color << COLOR_SHIFT);
}

int ret_font(buffer *buf, ani_object *o, ani_script *s)
{
	return ret_format(buf, o, s) & 127;
}

