/*
   Egon Animator
   Copyright (C) 1997, 1998  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * calc.h
 */

#define VERSION "Egon Animator " VERSION_NO ". No Warranty."

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#define BUFFER_COLS 1000
#define BUFFER_ROWS 1000

#define MAKE_POSITION(p)\
	(cons(flocons((p).row),cons(flocons((p).col),NIL)))

#define POSITION_ROW(p) (get_c_long(car(p)))
#define POSITION_COL(p) (get_c_long(cadr(p)))

typedef struct {
        Boolean plugin;
        Boolean play;
} AppData;

extern AppData app_data;

typedef struct plugin_t {
        long row, col;                  /* geometry */
        int ph;                         /* handle */
        char *name;                     /* file name */
        int displayed;                  /* started yet? */
} plugin_t;

typedef struct s_buffer {
	char name[1024];	/* identifies the buffer */
	char path[1024];	/* file name */
	ani_object *cast;	/* objects in animation sequence */
	unsigned long now;	/* time in ms */
	unsigned long delta;	/* ms between frames */
	unsigned long duration;	/* of animation */
	unsigned int width, height;
	int state;		/* ANI_STOP et al */
	char *bg;		/* background */
	int change;		/* if there are pending changes */
	plugin_t *plugin;	/* array of plugins */
	int nplugin;		/* number of plugins */
	struct s_buffer *next;	/* next buffer in buffer ring */
} buffer;

typedef struct s_window {
	ani_object *object;	/* selected object */
	ani_script *script;	/* selected tick */
	buffer *buf;		/* buffer */
	Widget viewport,	/* really a form */
		objv, objl,	/* cast */
		tickv, tickl,	/* script */
		propv, propl;	/* properties */
	struct s_window *next;	/* next window in window ring */
} window;

/* from window.c */

extern window *w_list;
extern int pr_scr_flag;		/* if the display needs updating */
extern int pr_line_flag;	/* updating the current line is enough */
extern Display *display;
extern Window root;

extern void activate_window(window *);
extern void llpr(char *);
extern window *find_window_by_widget(Widget);
extern void free_window(window *);
extern window *new_window(buffer *, window *);
extern int remove_window(window *);
extern int split_window(window *);
extern void init_windows(buffer *, int, char **);
extern void exit_windows(void);
extern void show_cur(window *);
extern void hide_cur(window *);

extern void draw_input(Display *, char *);
extern void draw_status(Display *, char *);
extern void draw_cell(Display *, Window, buffer *, int, int, int, int, window *);
extern void draw_buffer(Display *, window *);
extern Pixmap draw_snapshot(void);
extern void draw_input(Display *, char *);

extern void get_char_coords(window *, int, int, int, int, int *, int *);
extern void get_coords_cell(window *, int, int, int *, int *, int, int);
extern void mainloop(void);

/* from selection.c */
extern Atom target_atom;
extern int pack_selection(buffer *, char *, int, int, int, int);
extern Boolean convert_proc(Widget, Atom *, Atom *, Atom *,
			XtPointer *, unsigned long *, int *);
extern void lose_ownership_proc(Widget, Atom *);
extern void transfer_done_proc(void);
extern int unpack_selection(buffer *, char *, int, int);
extern void requestor_callback(Widget, XtPointer, Atom *, Atom *,
			XtPointer, unsigned long *, int *);

/* from matrix.c */
extern char *fmt_put(char *, int);
extern char *fmt_get(char *, int);
extern void free_matrix(ani_object *);
extern ani_object *last_object(buffer *);
extern ani_script *last_script(ani_object *);
extern int init_pool(void);
extern short pool_size(void);
extern short pool_install(char *);
extern int ins_format(buffer *, ani_object *, ani_script *, int);
extern int ret_format(buffer *, ani_object *, ani_script *);
extern int ret_font(buffer *, ani_object *, ani_script *);

/* from cmds.c */
extern void init_cmds(void);

/* from buffer.c */
extern buffer *b_list;
extern char *buffer_name(char *);
extern buffer *new_buffer(char *, char *);
extern buffer *free_buffer(buffer *);
extern void plugin_unique_name(char *, char *);
extern char *plugin_basedir(buffer *, char *);
extern buffer *find_buffer_by_name(char *);
extern int char_width(buffer *, int, int);
extern int line_height(buffer *, int);
extern int line_width(buffer *, int, int);
extern int line_length(buffer *, int);
#if 0
extern int cell_width(buffer *, int);
#endif
extern int cell_height(buffer *, int);
extern int buffer_plugin2index(buffer *, int);

/* from input.c */
extern void DialogDoneAction(Widget, XEvent *, String *, Cardinal *);
extern void DialogCancelAction(Widget, XEvent *, String *, Cardinal *);
extern void init_input(void);
extern int ask_for_str_comp(char *, char *, int (*)(char *));
extern int ask_for_str(char *, char *);

/* from forminput.c */
extern void init_form(Widget);

/* from main.c */
extern Widget topLevel, topbox, box, form, label1, label2, label3,
	gridpane, edit_shell, stage;
extern Widget btnFont, btnSize, btnStyle, btnColor;
extern Widget cmdBold, cmdItalic, cmdHLeft, cmdHCenter, cmdHRight;

extern int ok2print;
extern int siod_interpreter;
extern char *siaghome, *siaghelp, *siagdocs, *siag_basedir;

/* from print.c */
extern int paper_width;
extern int paper_height;
extern int margin;
extern void preview(void);
extern void printer(void);

/* from railway.c */
extern int errorflag;
extern char *interpreter2name(int);
extern int name2interpreter(char *);
extern int register_interpreter(char *, double (*)(char *), void (*)(char *));
extern int is_constant(char *);
extern double parse_expr(ani_object *, char *, int, int);
extern int calc_matrix(ani_object *);
#define execute(p) exec_expr(siod_interpreter,(p))
extern void exec_expr(int, char *);

/* from fileio.c */
extern char *patterns[];
extern void register_format(int (*)(char *, buffer *),
			int (*)(char *, buffer *),
			int (*)(char *), char *);
extern void fileio_init(void);
extern int savematrix(char *, buffer *, char *);
extern int loadmatrix(char *, buffer *, char *);
extern char *guess_file_format(char *);

/* from position.c */

extern void init_position(void);

/* from fontsel.c */
extern void font_init(Widget);
extern int font_input(int *, int *);

