#include <stdio.h>
#include <string.h>
#include <stdlib.h>

static struct {
	char *key, *xl;
} *dict = NULL;

static long nw = 0;

static void chomp(char *p)
{
        if ((p = strchr(p, '\n'))) *p = '\0';
}

void load_dictionary(char *fn)
{
        FILE *fp = fopen(fn, "r");
        char b[1024], *p, *q;

        if (!fp) {
                fprintf(stderr, "Can't open dictionary\n");
                return;
        }
        while (fgets(b, sizeof b, fp)) {
                chomp(b);
                p = strchr(b, '\t');
                if (!p) continue;
                *p++ = 0;
                p += strspn(p, "\t");
                dict = realloc(dict, (nw+1)*(sizeof dict[0]));
                dict[nw].key = strdup(b);
                dict[nw++].xl = strdup(p);
        }
}

char *translate(char *key)
{
        long i;

        for (i = 0; i < nw; i++)
                if (!strcmp(key, dict[i].key)) return dict[i].xl;
        return key;
}


